/*
 * Decompiled with CFR 0.152.
 */
package rzk.pcg.block;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import rzk.lib.mc.util.Utils;
import rzk.pcg.PCGates;
import rzk.pcg.block.BlockGateEdgeBase;
import rzk.pcg.tile.TileCounter;

public class BlockCounter
extends BlockGateEdgeBase {
    protected void reset(World world, BlockPos pos) {
        Utils.getTileAndDo(world, pos, TileCounter.class, TileCounter::reset);
    }

    protected void count(World world, BlockPos pos, int amount) {
        Utils.getTileAndDo(world, pos, TileCounter.class, tile -> tile.count(amount));
    }

    @Override
    protected boolean isInputSide(BlockState state, Direction side) {
        return side.func_176736_b() != -1 && !this.isOutputSide(state, side);
    }

    @Override
    protected boolean isOutputSide(BlockState state, Direction side) {
        return side == state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        Optional<TileCounter> tile = Utils.getTile(world, pos, TileCounter.class);
        if (world.field_72995_K && tile.isPresent()) {
            PCGates.proxy.openCounterGui(tile.get().getMaxCount(), pos);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    protected void onInputHigh(BlockState state, World world, BlockPos pos, Direction side) {
        if (!world.field_72995_K) {
            Direction facing = (Direction)world.func_180495_p(pos).func_177229_b((IProperty)BlockStateProperties.field_208157_J);
            if (side == facing.func_176734_d()) {
                this.reset(world, pos);
            } else if (side == facing.func_176746_e()) {
                this.count(world, pos, -1);
            } else if (side == facing.func_176735_f()) {
                this.count(world, pos, 1);
            }
        }
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileCounter();
    }

    @Override
    public boolean shouldBePowered(BlockState state, World world, BlockPos pos) {
        return false;
    }
}

