/*
 * Decompiled with CFR 0.152.
 */
package rzk.pcg.block;

import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import rzk.pcg.block.BlockGateBase;

public class BlockGateBasic
extends BlockGateBase {
    private final Type type;

    public BlockGateBasic(Type type) {
        this.type = type;
    }

    @Override
    public boolean isInputSide(BlockState state, Direction side) {
        Direction facing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
        switch (this.type) {
            case BUFFER: 
            case BUFFER_ALL: 
            case NOT: 
            case NOT_ALL: {
                return side == facing.func_176734_d();
            }
            case OR_2: 
            case NOR_2: 
            case AND_2: 
            case NAND_2: 
            case XOR_2: 
            case XNOR_2: {
                return side != facing & side != facing.func_176734_d();
            }
            case OR_3: 
            case NOR_3: 
            case AND_3: 
            case NAND_3: 
            case XOR_3: 
            case XNOR_3: {
                return side != facing;
            }
        }
        return false;
    }

    @Override
    public boolean isOutputSide(BlockState state, Direction side) {
        Direction facing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
        if (this.type == Type.BUFFER_ALL || this.type == Type.NOT_ALL) {
            return side == facing || side == facing.func_176735_f() || side == facing.func_176746_e();
        }
        return side == facing;
    }

    @Override
    public boolean shouldBePowered(BlockState state, World world, BlockPos pos) {
        Direction facing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
        boolean left = this.isPowered(world, pos, facing.func_176735_f());
        boolean back = this.isPowered(world, pos, facing.func_176734_d());
        boolean right = this.isPowered(world, pos, facing.func_176746_e());
        switch (this.type) {
            case BUFFER: 
            case BUFFER_ALL: {
                return back;
            }
            case NOT: 
            case NOT_ALL: {
                return !back;
            }
            case OR_2: {
                return left || right;
            }
            case OR_3: {
                return left || back || right;
            }
            case NOR_2: {
                return !left && !right;
            }
            case NOR_3: {
                return !left && !back && !right;
            }
            case AND_2: {
                return left && right;
            }
            case AND_3: {
                return left && back || right;
            }
            case NAND_2: {
                return !left || !right;
            }
            case NAND_3: {
                return !left || !back || !right;
            }
            case XOR_2: {
                return left && !right || !left && right;
            }
            case XOR_3: {
                return left && !back && !right || !left && back && !right || !left && !back && right;
            }
            case XNOR_2: {
                return !(left && !right || !left && right);
            }
            case XNOR_3: {
                return !(left && !back && !right || !left && back && !right || !left && !back && right);
            }
        }
        return false;
    }

    public static enum Type {
        BUFFER,
        BUFFER_ALL,
        NOT,
        NOT_ALL,
        OR_2,
        OR_3,
        NOR_2,
        NOR_3,
        AND_2,
        AND_3,
        NAND_2,
        NAND_3,
        XOR_2,
        XOR_3,
        XNOR_2,
        XNOR_3;

    }
}

