/*
 * Decompiled with CFR 0.152.
 */
package rzk.pcg.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import rzk.pcg.packet.PacketCounter;
import rzk.pcg.packet.PacketHandler;

@OnlyIn(value=Dist.CLIENT)
public class GuiCounter
extends Screen {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("pcg", "textures/gui/counter.png");
    int guiLeft;
    int guiTop;
    private TextFieldWidget maxCountField;
    private int maxCount;
    private BlockPos pos;
    private int xSize;
    private int ySize;

    public GuiCounter(int maxCount, BlockPos pos) {
        super((ITextComponent)new TranslationTextComponent("gui.pcg.counter", new Object[0]));
        this.maxCount = maxCount;
        this.pos = pos;
    }

    protected void init() {
        this.xSize = 128;
        this.ySize = 80;
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.maxCountField = new TextFieldWidget(this.font, this.width / 2 - 40, this.guiTop + 20, 48, 16, I18n.func_135052_a((String)"gui.pcg.counter.max_count", (Object[])new Object[0])){

            public void func_146191_b(String textToWrite) {
                StringBuilder stringbuilder = new StringBuilder();
                for (char c0 : textToWrite.toCharArray()) {
                    if (c0 < '0' || c0 > '9') continue;
                    stringbuilder.append(c0);
                }
                super.func_146191_b(stringbuilder.toString());
            }
        };
        this.maxCountField.func_146205_d(false);
        this.maxCountField.changeFocus(true);
        this.maxCountField.func_146203_f(35);
        this.maxCountField.func_146180_a("" + this.maxCount);
        this.children.add(this.maxCountField);
        this.func_212928_a((IGuiEventListener)this.maxCountField);
        this.addButton((Widget)new Button(this.width / 2 - 24, this.guiTop + this.ySize - 28, 48, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), onPress -> this.sendCounterPacket()));
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.minecraft.field_71439_g.func_71053_j();
        }
        return this.maxCountField.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) || this.maxCountField.func_212955_f() || super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.drawGuiBackgroundTexture(mouseX, mouseY, partialTicks);
        this.maxCountField.render(mouseX, mouseY, partialTicks);
        this.font.func_211126_b(this.title.func_150254_d(), (float)(this.guiLeft + (this.xSize - this.font.func_78256_a(this.title.func_150254_d())) / 2), (float)(this.guiTop + 6), 0x404040);
        this.font.func_211126_b("max.", (float)(this.guiLeft + 80), (float)(this.guiTop + 24), 0x404040);
        super.render(mouseX, mouseY, partialTicks);
    }

    protected void drawGuiBackgroundTexture(int mouseX, int mouseY, float partialTicks) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(GUI_TEXTURE);
        this.blit(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    private void sendCounterPacket() {
        PacketHandler.INSTANCE.sendToServer((Object)new PacketCounter(Integer.parseInt(this.maxCountField.func_146179_b()), this.pos));
        this.minecraft.field_71439_g.func_71053_j();
    }
}

