/*
 * Decompiled with CFR 0.152.
 */
package rzk.pcg.packet;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import rzk.lib.mc.packet.Packet;
import rzk.lib.mc.util.Utils;
import rzk.pcg.tile.TileCounter;

public class PacketCounter
extends Packet {
    private int maxCount;
    private BlockPos pos;

    public PacketCounter(int maxCount, BlockPos pos) {
        this.maxCount = maxCount;
        this.pos = pos;
    }

    PacketCounter(PacketBuffer buffer) {
        super(buffer);
        this.maxCount = buffer.readInt();
        this.pos = BlockPos.func_218283_e((long)buffer.readLong());
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.writeInt(this.maxCount);
        buffer.writeLong(this.pos.func_218275_a());
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerWorld world;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (world = player.func_71121_q()).func_175667_e(this.pos)) {
                Utils.getTile((World)world, this.pos, TileCounter.class).ifPresent(tile -> tile.setMaxCount(this.maxCount));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

