/*
 * Decompiled with CFR 0.152.
 */
package rzk.pcg.packet;

import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import rzk.lib.mc.packet.Packet;
import rzk.lib.mc.util.Utils;
import rzk.pcg.tile.TileTimer;

public class PacketTimer
extends Packet {
    private int delay;
    private BlockPos pos;

    public PacketTimer(int delay, BlockPos pos) {
        this.delay = delay;
        this.pos = pos;
    }

    PacketTimer(PacketBuffer buffer) {
        super(buffer);
        this.delay = buffer.readInt();
        this.pos = BlockPos.func_218283_e((long)buffer.readLong());
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.writeInt(this.delay);
        buffer.writeLong(this.pos.func_218275_a());
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerWorld world;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (world = player.func_71121_q()).func_175667_e(this.pos)) {
                Utils.getTile((World)world, this.pos, TileTimer.class).ifPresent(tile -> {
                    tile.setDelay(this.delay);
                    BlockState state = world.func_180495_p(this.pos);
                    world.func_184138_a(this.pos, state, state, 3);
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

