/*
 * Decompiled with CFR 0.152.
 */
package rzk.pcg.tile;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntityType;
import rzk.lib.mc.tile.TileRedstoneDevice;
import rzk.lib.util.MathUtils;
import rzk.lib.util.ObjectUtils;
import rzk.pcg.block.BlockCounter;
import rzk.pcg.registry.ModBlocks;

public class TileCounter
extends TileRedstoneDevice {
    public static final TileEntityType<TileCounter> TYPE = TileEntityType.Builder.func_223042_a(TileCounter::new, (Block[])new Block[]{ModBlocks.COUNTER}).func_206865_a(null);
    private int maxCount = 10;
    private int counter = 0;

    public TileCounter() {
        super(TYPE);
    }

    public void reset() {
        this.counter = 0;
        this.count(0);
        this.func_70296_d();
    }

    public void count(int amount) {
        this.counter = MathUtils.constrain(this.counter + amount, 0, this.maxCount);
        Optional<BlockCounter> blockCounter = ObjectUtils.cast(this.func_195044_w().func_177230_c(), BlockCounter.class);
        if (this.counter >= this.maxCount && !((Boolean)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208194_u)).booleanValue()) {
            blockCounter.ifPresent(block -> block.setPoweredState(this.func_195044_w(), this.field_145850_b, this.field_174879_c, true));
        } else if (this.counter < this.maxCount && ((Boolean)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208194_u)).booleanValue()) {
            blockCounter.ifPresent(block -> block.setPoweredState(this.func_195044_w(), this.field_145850_b, this.field_174879_c, false));
        } else {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
        this.func_70296_d();
    }

    public int getCounter() {
        return this.counter;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        if (maxCount >= 0) {
            this.maxCount = maxCount;
            this.count(0);
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.maxCount = compound.func_74762_e("maxCount");
        this.counter = compound.func_74762_e("counter");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("maxCount", this.maxCount);
        compound.func_74768_a("counter", this.counter);
        return compound;
    }
}

