/*
 * Decompiled with CFR 0.152.
 */
package rzk.pcg.tile;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import rzk.lib.mc.tile.TileRedstoneDevice;
import rzk.lib.util.ObjectUtils;
import rzk.pcg.block.BlockTimer;
import rzk.pcg.registry.ModBlocks;

public class TileTimer
extends TileRedstoneDevice
implements ITickableTileEntity {
    public static final TileEntityType<TileTimer> TYPE = TileEntityType.Builder.func_223042_a(TileTimer::new, (Block[])new Block[]{ModBlocks.TIMER, ModBlocks.TIMER_ON_DELAY, ModBlocks.TIMER_OFF_DELAY}).func_206865_a(null);
    private int neededTicks = 20;
    private int currentTicks = 0;
    private boolean enabled = false;

    public TileTimer() {
        super(TYPE);
    }

    public int getDelay() {
        return this.neededTicks;
    }

    public void setDelay(int delay) {
        this.neededTicks = delay;
    }

    public void setEnabled(boolean state) {
        this.enabled = state;
        this.currentTicks = 0;
        this.func_70296_d();
    }

    private void setTimerState() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof BlockTimer.Delay) {
            this.setEnabled(false);
            ObjectUtils.cast(this.func_195044_w().func_177230_c(), BlockTimer.Delay.class).ifPresent(blockTimer -> blockTimer.setPoweredState(this.func_195044_w(), this.field_145850_b, this.field_174879_c, blockTimer.isOnTimer()));
        } else {
            ObjectUtils.cast(this.func_195044_w().func_177230_c(), BlockTimer.class).ifPresent(blockTimer -> {
                blockTimer.setPoweredState(this.func_195044_w(), this.field_145850_b, this.field_174879_c, true);
                blockTimer.scheduleTickIfNotScheduled(this.field_145850_b, this.field_174879_c, 2);
            });
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.enabled) {
            if (this.currentTicks >= this.neededTicks - 1) {
                this.setTimerState();
                this.currentTicks = 0;
            } else {
                ++this.currentTicks;
            }
            this.func_70296_d();
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.neededTicks = compound.func_74762_e("neededTicks");
        this.currentTicks = compound.func_74762_e("currentTicks");
        this.enabled = compound.func_74767_n("enabled");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("neededTicks", this.neededTicks);
        compound.func_74768_a("currentTicks", this.currentTicks);
        compound.func_74757_a("enabled", this.enabled);
        return compound;
    }
}

