/*
 * Decompiled with CFR 0.152.
 */
package rzk.lib.mc.block;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import rzk.lib.mc.block.BlockBase;
import rzk.lib.mc.util.Utils;

public abstract class BlockRedstoneDevice
extends BlockBase {
    public BlockRedstoneDevice(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean isInputSide(BlockState state, Direction side) {
        return false;
    }

    protected boolean isOutputSide(BlockState state, Direction side) {
        return false;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        if (side != null) {
            return this.isInputSide(state, side.func_176734_d()) || this.isOutputSide(state, side.func_176734_d());
        }
        return false;
    }

    protected int getInputPower(World world, BlockPos pos, Direction side) {
        BlockPos blockpos = pos.func_177972_a(side);
        int i = world.func_175651_c(blockpos, side);
        if (i >= 15) {
            return 15;
        }
        BlockState state = world.func_180495_p(blockpos);
        return Math.max(i, state.func_177230_c().equals(Blocks.field_150488_af) ? (Integer)state.func_177229_b((Property)RedstoneWireBlock.field_176351_O) : 0);
    }

    protected boolean isPowered(World world, BlockPos pos, Direction ... sides) {
        if (sides == null || sides.length == 0) {
            return this.isPowered(world, pos, Direction.values());
        }
        for (Direction side : sides) {
            if (this.getInputPower(world, pos, side) <= 0) continue;
            return true;
        }
        return false;
    }

    protected int getOutputPower(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u) != false && this.isOutputSide(state, side) ? 15 : 0;
    }

    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return this.getOutputPower(state, world, pos, side.func_176734_d());
    }

    public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return this.getOutputPower(state, world, pos, side.func_176734_d());
    }

    protected void onInputChanged(BlockState state, World world, BlockPos pos, Direction side) {
    }

    protected void updateNeighborsInFront(BlockState state, World world, BlockPos pos, Direction side) {
        BlockPos blockpos = pos.func_177972_a(side);
        if (ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)pos, (BlockState)world.func_180495_p(pos), EnumSet.of(side), (boolean)false).isCanceled()) {
            return;
        }
        world.func_190524_a(blockpos, (Block)this, pos);
        world.func_175695_a(blockpos, (Block)this, side.func_176734_d());
    }

    public void setPoweredState(BlockState state, World world, BlockPos pos, boolean powered) {
        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(powered)));
        for (Direction side : Direction.Plane.HORIZONTAL) {
            if (!this.isOutputSide(state, side)) continue;
            this.updateNeighborsInFront(state, world, pos, side);
        }
    }

    public void scheduleTickIfNotScheduled(World world, BlockPos pos, int delay) {
        if (!world.func_205220_G_().func_205359_a(pos, (Object)this)) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, delay);
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos neighbor, boolean isMoving) {
        Direction side = Utils.getFromBlockPos(pos, neighbor);
        if (this.isInputSide(state, side)) {
            this.onInputChanged(state, world, pos, side);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208194_u});
    }
}

