/*
 * Decompiled with CFR 0.152.
 */
package rzk.lib.mc.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import rzk.lib.mc.block.BlockRedstoneDevice;
import rzk.lib.mc.tile.ITileRedstoneStates;
import rzk.lib.mc.tile.TileRedstoneDevice;
import rzk.lib.mc.util.Utils;

public abstract class BlockRedstoneDeviceEdgeDetection
extends BlockRedstoneDevice {
    public BlockRedstoneDeviceEdgeDetection(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileRedstoneDevice();
    }

    protected void onInputHigh(BlockState state, World world, BlockPos pos, Direction side) {
    }

    protected void onInputLow(BlockState state, World world, BlockPos pos, Direction side) {
    }

    protected void updateRedstoneState(World world, BlockPos pos, BlockState state, ITileRedstoneStates tile, Direction ... sides) {
        if (sides == null || sides.length == 0) {
            this.updateRedstoneState(world, pos, state, tile, Direction.values());
            return;
        }
        for (Direction side : sides) {
            boolean isPowered = this.isPowered(world, pos, side);
            if (isPowered == tile.getRedstoneState(side)) continue;
            if (isPowered) {
                this.onInputHigh(state, world, pos, side);
            } else {
                this.onInputLow(state, world, pos, side);
            }
            tile.setRedstoneState(side, isPowered);
        }
    }

    @Override
    public void onInputChanged(BlockState state, World world, BlockPos pos, Direction side) {
        if (!world.field_72995_K) {
            Utils.getTileAndDo(world, pos, ITileRedstoneStates.class, tile -> this.updateRedstoneState(world, pos, state, (ITileRedstoneStates)tile, side));
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!world.field_72995_K) {
            Utils.getTileAndDo(world, pos, ITileRedstoneStates.class, tile -> Direction.Plane.HORIZONTAL.forEach(side -> this.updateRedstoneState(world, pos, state, (ITileRedstoneStates)tile, (Direction)side)));
        }
    }
}

