/*
 * Decompiled with CFR 0.152.
 */
package rzk.pcg.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import rzk.lib.mc.block.BlockRedstoneDevice;
import rzk.pcg.PCGates;

public abstract class BlockGateBase
extends BlockRedstoneDevice {
    public static final VoxelShape GATE_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);

    public BlockGateBase() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH));
    }

    protected abstract boolean shouldBePowered(BlockState var1, World var2, BlockPos var3);

    @Override
    public void onInputChanged(BlockState state, World world, BlockPos pos, Direction side) {
        this.scheduleTickIfNotScheduled(world, pos, 2);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        boolean shouldBePowered = this.shouldBePowered(state, (World)world, pos);
        if ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u) != shouldBePowered) {
            this.setPoweredState(state, (World)world, pos, shouldBePowered);
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.scheduleTickIfNotScheduled(world, pos, 2);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f());
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208194_u, BlockStateProperties.field_208157_J});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return GATE_SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u)).booleanValue()) {
            double d0 = (double)pos.func_177958_n() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            double d1 = (double)pos.func_177956_o() + 0.3 + (rand.nextDouble() - 0.5) * 0.2;
            double d2 = (double)pos.func_177952_p() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public BlockItem createItem() {
        return new BlockItem((Block)this, new Item.Properties().func_200916_a(PCGates.ITEM_GROUP_PC_GATES));
    }
}

