/*
 * Decompiled with CFR 0.152.
 */
package rzk.pcg.block;

import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import rzk.pcg.block.BlockGateBase;
import rzk.pcg.block.BlockGateEdgeBase;

public class BlockLatch
extends BlockGateBase {
    private final Type type;

    public BlockLatch(Type type) {
        this.type = type;
    }

    @Override
    public boolean isInputSide(BlockState state, Direction side) {
        Direction facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        return side == facing.func_176735_f() || side == facing.func_176746_e();
    }

    @Override
    public boolean isOutputSide(BlockState state, Direction side) {
        Direction facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        return side == facing || side == facing.func_176734_d();
    }

    @Override
    public boolean shouldBePowered(BlockState state, World world, BlockPos pos) {
        Direction facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        boolean left = this.isPowered(world, pos, facing.func_176735_f());
        boolean right = this.isPowered(world, pos, facing.func_176746_e());
        switch (this.type) {
            case RS: {
                if (right) {
                    return false;
                }
                if (!left) break;
                return true;
            }
            case SR: {
                if (left) {
                    return true;
                }
                if (!right) break;
                return false;
            }
        }
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u);
    }

    public static class Edge
    extends BlockGateEdgeBase {
        private final Type type;

        public Edge(Type type) {
            this.type = type;
        }

        @Override
        public boolean isInputSide(BlockState state, Direction side) {
            Direction facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
            return side == facing.func_176735_f() || side == facing.func_176746_e();
        }

        @Override
        public boolean isOutputSide(BlockState state, Direction side) {
            Direction facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
            return side == facing || side == facing.func_176734_d();
        }

        @Override
        public void onInputHigh(BlockState state, World world, BlockPos pos, Direction side) {
            switch (this.type) {
                case D: {
                    if (side != ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176746_e()) break;
                    this.scheduleTickIfNotScheduled(world, pos, 2);
                    break;
                }
                case TOGGLE: {
                    if (this.isPowered(world, pos, side.func_176734_d())) break;
                    this.scheduleTickIfNotScheduled(world, pos, 2);
                }
            }
        }

        @Override
        public boolean shouldBePowered(BlockState state, World world, BlockPos pos) {
            switch (this.type) {
                case D: {
                    return this.isPowered(world, pos, ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176735_f());
                }
                case TOGGLE: {
                    return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u) == false;
                }
            }
            return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u);
        }
    }

    public static enum Type {
        RS,
        SR,
        D,
        TOGGLE;

    }
}

