/*
 * Decompiled with CFR 0.152.
 */
package rzk.pcg.block;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import rzk.lib.mc.util.Utils;
import rzk.pcg.block.BlockGateBase;
import rzk.pcg.block.BlockGateEdgeBase;

public class BlockSensor
extends BlockGateBase {
    private final Type type;

    public BlockSensor(Type type) {
        this.type = type;
    }

    @Override
    public boolean isOutputSide(BlockState state, Direction side) {
        return side.func_176736_b() != -1;
    }

    @Override
    public boolean shouldBePowered(BlockState state, World world, BlockPos pos) {
        switch (this.type) {
            case DAY: {
                return world.func_72935_r();
            }
            case NIGHT: {
                return world.func_226690_K_();
            }
            case RAIN: {
                return world.func_72896_J();
            }
            case THUNDER: {
                return world.func_72911_I();
            }
        }
        return false;
    }

    @Override
    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        super.func_225534_a_(state, world, pos, rand);
        this.scheduleTickIfNotScheduled((World)world, pos, 20);
    }

    public static class Edge
    extends BlockGateEdgeBase {
        private final Type type;

        public Edge(Type type) {
            this.type = type;
        }

        @Override
        public boolean isInputSide(BlockState state, Direction side) {
            return side == ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d();
        }

        @Override
        public boolean isOutputSide(BlockState state, Direction side) {
            return side == state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        }

        @Override
        public void onInputHigh(BlockState state, World world, BlockPos pos, Direction side) {
            if (this.type == Type.RISING_EDGE) {
                this.setPoweredState(state, world, pos, true);
                this.scheduleTickIfNotScheduled(world, pos, 2);
            }
        }

        @Override
        public void onInputLow(BlockState state, World world, BlockPos pos, Direction side) {
            if (this.type == Type.FALLING_EDGE) {
                this.setPoweredState(state, world, pos, true);
                this.scheduleTickIfNotScheduled(world, pos, 2);
            }
        }

        @Override
        public boolean shouldBePowered(BlockState state, World world, BlockPos pos) {
            return false;
        }
    }

    public static class Chest
    extends BlockGateBase {
        private final Type type;

        public Chest(Type type) {
            this.type = type;
        }

        @Override
        public boolean isOutputSide(BlockState state, Direction side) {
            return side == state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        }

        @Override
        public boolean shouldBePowered(BlockState state, World world, BlockPos pos) {
            BlockPos blockpos = pos.func_177972_a(((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d());
            BlockState blockstate = world.func_180495_p(blockpos);
            if (blockstate.func_185912_n()) {
                int level = blockstate.func_185888_a(world, blockpos);
                switch (this.type) {
                    case CHEST_EMPTY: {
                        return level == 0;
                    }
                    case CHEST_SPACE: {
                        return level > 0 && level < 14;
                    }
                    case CHEST_FULL: {
                        return level >= 14;
                    }
                }
            }
            return false;
        }

        public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
            Direction side;
            if (!world.func_201670_d() && (side = Utils.getFromBlockPos(pos, neighbor)) == ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d() && pos.func_177956_o() == neighbor.func_177956_o() && world instanceof World) {
                this.scheduleTickIfNotScheduled((World)world, pos, 2);
            }
        }
    }

    public static enum Type {
        DAY,
        NIGHT,
        RAIN,
        THUNDER,
        CHEST_EMPTY,
        CHEST_SPACE,
        CHEST_FULL,
        RISING_EDGE,
        FALLING_EDGE;

    }
}

