/*
 * Decompiled with CFR 0.152.
 */
package rzk.pcg.block;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import rzk.lib.mc.util.Utils;
import rzk.pcg.PCGates;
import rzk.pcg.block.BlockGateEdgeBase;
import rzk.pcg.tile.TileTimer;

public class BlockTimer
extends BlockGateEdgeBase {
    @Override
    public boolean shouldBePowered(BlockState state, World world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean isInputSide(BlockState state, Direction side) {
        return side == ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d();
    }

    @Override
    public boolean isOutputSide(BlockState state, Direction side) {
        Direction facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        return side == facing || side == facing.func_176735_f() || side == facing.func_176746_e();
    }

    protected void setEnabled(World world, BlockPos pos, boolean enabled) {
        if (!world.field_72995_K) {
            Utils.getTile(world, pos, TileTimer.class).ifPresent(tile -> tile.setEnabled(enabled));
        }
    }

    @Override
    public void onInputHigh(BlockState state, World world, BlockPos pos, Direction side) {
        this.setEnabled(world, pos, false);
    }

    @Override
    public void onInputLow(BlockState state, World world, BlockPos pos, Direction side) {
        this.setEnabled(world, pos, true);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.setEnabled(world, pos, !this.isPowered(world, pos, ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d()));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        Optional<TileTimer> tile = Utils.getTile(world, pos, TileTimer.class);
        if (world.field_72995_K && tile.isPresent()) {
            PCGates.proxy.openTimerGui(tile.get().getDelay(), pos);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileTimer();
    }

    public static class Delay
    extends BlockTimer {
        private final Type type;

        public Delay(Type type) {
            this.type = type;
        }

        public boolean isOnTimer() {
            return this.type == Type.ON;
        }

        @Override
        public boolean isOutputSide(BlockState state, Direction side) {
            return side == state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        }

        @Override
        public void onInputHigh(BlockState state, World world, BlockPos pos, Direction side) {
            this.setEnabled(world, pos, this.type == Type.ON);
            if (this.type == Type.OFF) {
                this.setPoweredState(state, world, pos, true);
            }
        }

        @Override
        public void onInputLow(BlockState state, World world, BlockPos pos, Direction side) {
            this.setEnabled(world, pos, this.type == Type.OFF);
            if (this.type == Type.ON) {
                this.setPoweredState(state, world, pos, false);
            }
        }

        @Override
        public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
            boolean isPowered = this.isPowered(world, pos, ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d());
            this.setEnabled(world, pos, this.type == Type.ON && isPowered || this.type == Type.OFF && !isPowered);
        }

        public static enum Type {
            ON,
            OFF;

        }
    }
}

