/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.qolq.powershot;

import com.gitlab.qolq.powershot.BreakableBlockStateProperties;
import com.gitlab.qolq.powershot.Powershot;
import com.gitlab.qolq.powershot.StateToPropertyHashMap;
import com.gitlab.qolq.powershot.StateToPropertyHashMapSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMaps;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourceReloadListenerKeys;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_151;
import net.minecraft.class_1893;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3518;
import org.apache.commons.io.FileUtils;

public final class Configuration {
    private static final int POWER_CALC_SCHEMA_VERSION = 2;
    private static final int BREAKABLE_BLOCKS_SCHEMA_VERSION = 2;
    private static final float DEFAULT_BASE_POWER = 1.0f;
    private static final String SCHEMA_VERSION_KEY = "schema_version";
    private static final String BASE_POWER_KEY = "base_power";
    private static final String ENCHANTMENT_MULTIPLIERS_KEY = "enchantment_multipliers";
    private static final String BREAKABLE_BLOCKS_KEY = "entries";
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().registerTypeAdapter(StateToPropertyHashMap.class, (Object)new StateToPropertyHashMapSerializer()).create();
    public float basePower = 1.0f;
    public Object2FloatMap<class_2960> enchantmentToMultiplier = Configuration.getDefaultEnchantmentMultipliers();
    public StateToPropertyHashMap breakableStateToProperties = Configuration.getDefaultBreakableStatesAndProperties();
    private final File powerCalculationConfigFile;
    private final File breakableBlocksConfigFile;

    public Configuration(Path dir) {
        this.powerCalculationConfigFile = dir.resolve("power_calculation.json").toFile();
        this.breakableBlocksConfigFile = dir.resolve("breakable_blocks.json").toFile();
    }

    public void init() {
        this.readPowerCalculationConfig();
        this.readBreakableBlocksConfig();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){
            private final class_2960 id = new class_2960("powershot", "config");
            private final Collection<class_2960> deps = Collections.singleton(ResourceReloadListenerKeys.TAGS);

            public class_2960 getFabricId() {
                return this.id;
            }

            public Collection<class_2960> getFabricDependencies() {
                return this.deps;
            }

            public void method_14491(class_3300 manager) {
                Configuration.this.breakableStateToProperties.reloadTags();
            }
        });
    }

    public void readPowerCalculationConfig() {
        if (this.powerCalculationConfigFile.exists()) {
            try {
                String json = FileUtils.readFileToString((File)this.powerCalculationConfigFile, (Charset)StandardCharsets.UTF_8);
                JsonObject config = (JsonObject)gson.fromJson(json, JsonObject.class);
                if (config.has(SCHEMA_VERSION_KEY)) {
                    int schemaVersion = class_3518.method_15260((JsonObject)config, (String)SCHEMA_VERSION_KEY);
                    if (schemaVersion != 2) {
                        Powershot.log.warn("Power calculation config has a different schema version (Expected: {}, Found: {})", (Object)2, (Object)schemaVersion);
                    }
                    this.basePower = class_3518.method_15277((JsonObject)config, (String)BASE_POWER_KEY, (float)1.0f);
                    this.enchantmentToMultiplier = this.readEnchantmentMultipliers(class_3518.method_15281((JsonObject)config, (String)ENCHANTMENT_MULTIPLIERS_KEY, (JsonObject)new JsonObject()));
                } else {
                    Powershot.log.warn("Power calculation config has no schema version. Assuming it's using the old schema");
                    Object2FloatOpenHashMap map = new Object2FloatOpenHashMap(4);
                    map.put((Object)new class_2960("power"), class_3518.method_15277((JsonObject)config, (String)"power_multiplier", (float)1.0f));
                    map.put((Object)new class_2960("piercing"), class_3518.method_15277((JsonObject)config, (String)"piercing_multiplier", (float)1.0f));
                    map.put((Object)new class_2960("punch"), class_3518.method_15277((JsonObject)config, (String)"punch_multiplier", (float)1.0f));
                    map.put((Object)new class_2960("knockback"), class_3518.method_15277((JsonObject)config, (String)"knockback_multiplier", (float)1.0f));
                    this.basePower = class_3518.method_15277((JsonObject)config, (String)BASE_POWER_KEY, (float)1.0f);
                    this.enchantmentToMultiplier = Object2FloatMaps.unmodifiable((Object2FloatMap)map);
                }
            }
            catch (JsonParseException | IOException e) {
                Powershot.log.warn("Failed to read file " + this.powerCalculationConfigFile, e);
            }
            Powershot.log.debug("Base power: {}", (Object)Float.valueOf(this.basePower));
            Powershot.log.debug("Enchantment multipliers: {}", (Object)this.enchantmentToMultiplier.size());
        } else {
            this.writePowerCalculationConfig();
        }
    }

    private Object2FloatMap<class_2960> readEnchantmentMultipliers(JsonObject jsonMultipliers) {
        Object2FloatOpenHashMap multipliers = new Object2FloatOpenHashMap();
        for (Map.Entry entry : jsonMultipliers.entrySet()) {
            try {
                class_2960 id = new class_2960((String)entry.getKey());
                if (class_2378.field_11160.method_10250(id)) {
                    float multiplier = class_3518.method_15269((JsonElement)((JsonElement)entry.getValue()), (String)id.toString());
                    if (multiplier == 0.0f || !Float.isFinite(multiplier)) continue;
                    multipliers.put((Object)id, multiplier);
                    continue;
                }
                Powershot.log.warn("Invalid enchantment multiplier entry: '{}' is not a registered enchantment", (Object)id);
            }
            catch (JsonParseException | class_151 e) {
                Powershot.log.warn("Error while parsing enchantment multiplier entry", e);
            }
        }
        return Object2FloatMaps.unmodifiable((Object2FloatMap)multipliers);
    }

    public void readBreakableBlocksConfig() {
        if (this.breakableBlocksConfigFile.exists()) {
            try {
                String json = FileUtils.readFileToString((File)this.breakableBlocksConfigFile, (Charset)StandardCharsets.UTF_8);
                JsonElement element = (JsonElement)gson.fromJson(json, JsonElement.class);
                if (element.isJsonObject()) {
                    JsonObject config = element.getAsJsonObject();
                    int schemaVersion = class_3518.method_15260((JsonObject)config, (String)SCHEMA_VERSION_KEY);
                    if (schemaVersion != 2) {
                        Powershot.log.warn("Breakable blocks config has a different schema version (Expected: {}, Found: {})", (Object)2, (Object)schemaVersion);
                    }
                    this.breakableStateToProperties = (StateToPropertyHashMap)gson.fromJson((JsonElement)class_3518.method_15292((JsonObject)config, (String)BREAKABLE_BLOCKS_KEY, (JsonArray)new JsonArray()), StateToPropertyHashMap.class);
                } else {
                    Powershot.log.warn("Breakable blocks config does not contain an object. Assuming it's using the old schema");
                    this.breakableStateToProperties = (StateToPropertyHashMap)gson.fromJson(element, StateToPropertyHashMap.class);
                }
            }
            catch (JsonParseException | IOException e) {
                Powershot.log.warn("Failed to read file " + this.breakableBlocksConfigFile, e);
            }
            Powershot.log.debug("Breakable block states: {}", (Object)this.breakableStateToProperties.statesSize());
            Powershot.log.debug("Breakable block tags: {}", (Object)this.breakableStateToProperties.tagsSize());
        } else {
            this.writeBreakableBlocksConfig();
        }
    }

    public void writePowerCalculationConfig() {
        try {
            JsonObject config = new JsonObject();
            JsonObject multipliers = new JsonObject();
            for (Object2FloatMap.Entry entry : this.enchantmentToMultiplier.object2FloatEntrySet()) {
                float multiplier = entry.getFloatValue();
                if (multiplier == 0.0f || !Float.isFinite(multiplier)) continue;
                multipliers.addProperty(((class_2960)entry.getKey()).toString(), (Number)Float.valueOf(multiplier));
            }
            config.addProperty(SCHEMA_VERSION_KEY, (Number)2);
            config.addProperty(BASE_POWER_KEY, (Number)Float.valueOf(this.basePower));
            config.add(ENCHANTMENT_MULTIPLIERS_KEY, (JsonElement)multipliers);
            FileUtils.write((File)this.powerCalculationConfigFile, (CharSequence)gson.toJson((JsonElement)config), (Charset)StandardCharsets.UTF_8, (boolean)false);
        }
        catch (IOException e) {
            Powershot.log.warn("Failed to write file " + this.powerCalculationConfigFile, (Throwable)e);
        }
    }

    public void writeBreakableBlocksConfig() {
        try {
            JsonObject config = new JsonObject();
            config.addProperty(SCHEMA_VERSION_KEY, (Number)2);
            config.add(BREAKABLE_BLOCKS_KEY, gson.toJsonTree((Object)this.breakableStateToProperties, StateToPropertyHashMap.class));
            FileUtils.write((File)this.breakableBlocksConfigFile, (CharSequence)gson.toJson((JsonElement)config), (Charset)StandardCharsets.UTF_8, (boolean)false);
        }
        catch (IOException e) {
            Powershot.log.warn("Failed to write file " + this.breakableBlocksConfigFile, (Throwable)e);
        }
    }

    public static Object2FloatMap<class_2960> getDefaultEnchantmentMultipliers() {
        Object2FloatOpenHashMap defaults = new Object2FloatOpenHashMap(4);
        defaults.put((Object)class_2378.field_11160.method_10221((Object)class_1893.field_9103), 1.0f);
        defaults.put((Object)class_2378.field_11160.method_10221((Object)class_1893.field_9132), 1.0f);
        defaults.put((Object)class_2378.field_11160.method_10221((Object)class_1893.field_9116), 1.0f);
        defaults.put((Object)class_2378.field_11160.method_10221((Object)class_1893.field_9121), 1.0f);
        return Object2FloatMaps.unmodifiable((Object2FloatMap)defaults);
    }

    public static StateToPropertyHashMap getDefaultBreakableStatesAndProperties() {
        StateToPropertyHashMap.Builder defaults = new StateToPropertyHashMap.Builder();
        defaults.put(class_2246.field_10384, new BreakableBlockStateProperties(5.0f, 5.0f));
        defaults.put(class_2246.field_10225, new BreakableBlockStateProperties(4.0f, 4.0f));
        BreakableBlockStateProperties properties = new BreakableBlockStateProperties(3.15f, 3.15f);
        defaults.put(class_2246.field_10033, properties);
        defaults.put(class_2246.field_10087, properties);
        defaults.put(class_2246.field_10227, properties);
        defaults.put(class_2246.field_10574, properties);
        defaults.put(class_2246.field_10271, properties);
        defaults.put(class_2246.field_10049, properties);
        defaults.put(class_2246.field_10157, properties);
        defaults.put(class_2246.field_10317, properties);
        defaults.put(class_2246.field_10555, properties);
        defaults.put(class_2246.field_9996, properties);
        defaults.put(class_2246.field_10248, properties);
        defaults.put(class_2246.field_10399, properties);
        defaults.put(class_2246.field_10060, properties);
        defaults.put(class_2246.field_10073, properties);
        defaults.put(class_2246.field_10357, properties);
        defaults.put(class_2246.field_10272, properties);
        defaults.put(class_2246.field_9997, properties);
        defaults.put(class_2246.field_10295, properties);
        defaults.put(class_2246.field_10110, properties);
        defaults.put(class_2246.field_10545, properties);
        defaults.put(class_2246.field_10261, properties);
        defaults.put(class_2246.field_10147, properties);
        properties = new BreakableBlockStateProperties(2.0f, 2.0f);
        defaults.put((class_3494.class_5123<class_2248>)class_3481.field_15470, properties);
        defaults.put(class_2246.field_10285, properties);
        defaults.put(class_2246.field_9991, properties);
        defaults.put(class_2246.field_10496, properties);
        defaults.put(class_2246.field_10469, properties);
        defaults.put(class_2246.field_10193, properties);
        defaults.put(class_2246.field_10578, properties);
        defaults.put(class_2246.field_10305, properties);
        defaults.put(class_2246.field_10565, properties);
        defaults.put(class_2246.field_10077, properties);
        defaults.put(class_2246.field_10129, properties);
        defaults.put(class_2246.field_10355, properties);
        defaults.put(class_2246.field_10152, properties);
        defaults.put(class_2246.field_9982, properties);
        defaults.put(class_2246.field_10163, properties);
        defaults.put(class_2246.field_10419, properties);
        defaults.put(class_2246.field_10118, properties);
        defaults.put(class_2246.field_10070, properties);
        defaults.put(class_2246.field_10455, properties);
        defaults.put(class_2246.field_16541, properties);
        defaults.put(class_2246.field_22110, properties);
        defaults.put(class_2246.field_10348, properties);
        defaults.put(class_2246.field_10211, properties);
        properties = BreakableBlockStateProperties.DEFAULT;
        defaults.put(class_2246.field_10336, properties);
        defaults.put(class_2246.field_10099, properties);
        defaults.put(class_2246.field_10523, properties);
        defaults.put(class_2246.field_10301, properties);
        defaults.put(class_2246.field_22092, properties);
        defaults.put(class_2246.field_22093, properties);
        defaults.put(class_2246.field_10302, properties);
        defaults.put(class_2246.field_10476, properties);
        defaults.put(class_2246.field_10588, new BreakableBlockStateProperties(1.0f, 1.0f));
        return defaults.build();
    }
}

