/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.qolq.powershot;

import com.gitlab.qolq.powershot.BreakableBlockStateProperties;
import com.gitlab.qolq.powershot.Configuration;
import com.gitlab.qolq.powershot.Powerable;
import com.gitlab.qolq.powershot.mixin.RayTraceContextAccessor;
import java.nio.file.Path;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Powershot
implements ModInitializer {
    public static final String MOD_ID = "powershot";
    static final Logger log = LogManager.getLogger((String)"powershot");
    private static Configuration config;

    public void onInitialize() {
        Path dir = FabricLoader.getInstance().getConfigDirectory().toPath().resolve(MOD_ID);
        log.debug("Loading configs from {}", (Object)dir);
        config = new Configuration(dir);
        config.init();
    }

    public static float calculatePower(class_1665 arrow, float speed) {
        class_1309 livingShooter;
        class_1799 stack;
        float power = Powershot.config.basePower * speed;
        class_1297 shooter = arrow.method_24921();
        if (shooter instanceof class_1309 && !(stack = (livingShooter = (class_1309)shooter).method_5998(livingShooter.method_6058())).method_7960()) {
            class_2499 enchantments = stack.method_7921();
            for (int i = 0; i < enchantments.size(); ++i) {
                class_2487 enchantment = enchantments.method_10602(i);
                class_2960 id = class_2960.method_12829((String)enchantment.method_10558("id"));
                if (id == null || !Powershot.config.enchantmentToMultiplier.containsKey((Object)id)) continue;
                power += (float)class_3532.method_15340((int)enchantment.method_10550("lvl"), (int)0, (int)255) * Powershot.config.enchantmentToMultiplier.getFloat((Object)id);
            }
        }
        return power;
    }

    public static class_3965 trace(class_1937 world, class_3959 context, class_1665 arrow) {
        if (world.field_9236) {
            return world.method_17742(context);
        }
        Powerable powerable = (Powerable)arrow;
        BiFunction<class_3959, class_2338, class_3965> traceFn = (traceContext, position) -> {
            class_3965 result;
            class_243 start = traceContext.method_17750();
            class_243 end = traceContext.method_17747();
            class_3726 entityContext = ((RayTraceContextAccessor)traceContext).getEntityContext();
            class_2680 state = world.method_8320(position);
            class_265 shape = state.method_26194((class_1922)world, position, entityContext);
            BreakableBlockStateProperties properties = Powershot.config.breakableStateToProperties.get(state);
            if (properties == null) {
                result = world.method_17745(start, end, position, shape, state);
            } else {
                boolean breakable;
                boolean bl = breakable = powerable.getPower() >= properties.powerRequirement;
                if (breakable && shape.method_1110()) {
                    shape = state.method_26172((class_1922)world, position, entityContext);
                }
                result = world.method_17745(start, end, position, shape, state);
                if (breakable && result != null) {
                    world.method_8651(position, true, arrow.method_24921());
                    powerable.setPower(powerable.getPower() - properties.powerReduction);
                    result = null;
                }
            }
            if (result != null) {
                powerable.setPower(0.0f);
            }
            return result;
        };
        Function<class_3959, class_3965> missFn = traceContext -> {
            class_243 start = traceContext.method_17750();
            class_243 end = traceContext.method_17747();
            class_243 dir = start.method_1020(end);
            return class_3965.method_17778((class_243)end, (class_2350)class_2350.method_10142((double)dir.field_1352, (double)dir.field_1351, (double)dir.field_1350), (class_2338)new class_2338(start));
        };
        return (class_3965)class_1922.method_17744((class_3959)context, traceFn, missFn);
    }
}

