/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.qolq.powershot;

import com.gitlab.qolq.powershot.BreakableBlockStateProperties;
import com.gitlab.qolq.powershot.Powershot;
import com.gitlab.qolq.powershot.StateToPropertyHashMap;
import com.gitlab.qolq.powershot.StateToPropertyHashMapSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMaps;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.io.FileUtils;

public final class Configuration {
    private static final int POWER_CALC_SCHEMA_VERSION = 2;
    private static final int BREAKABLE_BLOCKS_SCHEMA_VERSION = 2;
    private static final float DEFAULT_BASE_POWER = 1.0f;
    private static final String SCHEMA_VERSION_KEY = "schema_version";
    private static final String BASE_POWER_KEY = "base_power";
    private static final String ENCHANTMENT_MULTIPLIERS_KEY = "enchantment_multipliers";
    private static final String BREAKABLE_BLOCKS_KEY = "entries";
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().registerTypeAdapter(StateToPropertyHashMap.class, (Object)new StateToPropertyHashMapSerializer()).create();
    public float basePower = 1.0f;
    public Object2FloatMap<ResourceLocation> enchantmentToMultiplier = Configuration.getDefaultEnchantmentMultipliers();
    public StateToPropertyHashMap breakableStateToProperties = Configuration.getDefaultBreakableStatesAndProperties();
    private final File powerCalculationConfigFile;
    private final File breakableBlocksConfigFile;

    public Configuration(Path dir) {
        this.powerCalculationConfigFile = dir.resolve("power_calculation.json").toFile();
        this.breakableBlocksConfigFile = dir.resolve("breakable_blocks.json").toFile();
    }

    public void init() {
        this.readPowerCalculationConfig();
        this.readBreakableBlocksConfig();
        MinecraftForge.EVENT_BUS.addListener(e -> this.breakableStateToProperties.reloadTags());
    }

    public void readPowerCalculationConfig() {
        if (this.powerCalculationConfigFile.exists()) {
            try {
                String json = FileUtils.readFileToString((File)this.powerCalculationConfigFile, (Charset)StandardCharsets.UTF_8);
                JsonObject config = (JsonObject)gson.fromJson(json, JsonObject.class);
                if (config.has(SCHEMA_VERSION_KEY)) {
                    int schemaVersion = JSONUtils.func_151203_m((JsonObject)config, (String)SCHEMA_VERSION_KEY);
                    if (schemaVersion != 2) {
                        Powershot.log.warn("Power calculation config has a different schema version (Expected: {}, Found: {})", (Object)2, (Object)schemaVersion);
                    }
                    this.basePower = JSONUtils.func_151221_a((JsonObject)config, (String)BASE_POWER_KEY, (float)1.0f);
                    this.enchantmentToMultiplier = this.readEnchantmentMultipliers(JSONUtils.func_151218_a((JsonObject)config, (String)ENCHANTMENT_MULTIPLIERS_KEY, (JsonObject)new JsonObject()));
                } else {
                    Powershot.log.warn("Power calculation config has no schema version. Assuming it's using the old schema");
                    Object2FloatOpenHashMap map = new Object2FloatOpenHashMap(4);
                    map.put((Object)new ResourceLocation("power"), JSONUtils.func_151221_a((JsonObject)config, (String)"power_multiplier", (float)1.0f));
                    map.put((Object)new ResourceLocation("piercing"), JSONUtils.func_151221_a((JsonObject)config, (String)"piercing_multiplier", (float)1.0f));
                    map.put((Object)new ResourceLocation("punch"), JSONUtils.func_151221_a((JsonObject)config, (String)"punch_multiplier", (float)1.0f));
                    map.put((Object)new ResourceLocation("knockback"), JSONUtils.func_151221_a((JsonObject)config, (String)"knockback_multiplier", (float)1.0f));
                    this.basePower = JSONUtils.func_151221_a((JsonObject)config, (String)BASE_POWER_KEY, (float)1.0f);
                    this.enchantmentToMultiplier = Object2FloatMaps.unmodifiable((Object2FloatMap)map);
                }
            }
            catch (JsonParseException | IOException e) {
                Powershot.log.warn("Failed to read file " + this.powerCalculationConfigFile, e);
            }
            Powershot.log.debug("Base power: {}", (Object)Float.valueOf(this.basePower));
            Powershot.log.debug("Enchantment multipliers: {}", (Object)this.enchantmentToMultiplier.size());
        } else {
            this.writePowerCalculationConfig();
        }
    }

    private Object2FloatMap<ResourceLocation> readEnchantmentMultipliers(JsonObject jsonMultipliers) {
        Object2FloatOpenHashMap multipliers = new Object2FloatOpenHashMap();
        for (Map.Entry entry : jsonMultipliers.entrySet()) {
            try {
                ResourceLocation id = new ResourceLocation((String)entry.getKey());
                if (ForgeRegistries.ENCHANTMENTS.containsKey(id)) {
                    float multiplier = JSONUtils.func_151220_d((JsonElement)((JsonElement)entry.getValue()), (String)id.toString());
                    if (multiplier == 0.0f || !Float.isFinite(multiplier)) continue;
                    multipliers.put((Object)id, multiplier);
                    continue;
                }
                Powershot.log.warn("Invalid enchantment multiplier entry: '{}' is not a registered enchantment", (Object)id);
            }
            catch (JsonParseException | ResourceLocationException e) {
                Powershot.log.warn("Error while parsing enchantment multiplier entry", e);
            }
        }
        return Object2FloatMaps.unmodifiable((Object2FloatMap)multipliers);
    }

    public void readBreakableBlocksConfig() {
        if (this.breakableBlocksConfigFile.exists()) {
            try {
                String json = FileUtils.readFileToString((File)this.breakableBlocksConfigFile, (Charset)StandardCharsets.UTF_8);
                JsonElement element = (JsonElement)gson.fromJson(json, JsonElement.class);
                if (element.isJsonObject()) {
                    JsonObject config = element.getAsJsonObject();
                    int schemaVersion = JSONUtils.func_151203_m((JsonObject)config, (String)SCHEMA_VERSION_KEY);
                    if (schemaVersion != 2) {
                        Powershot.log.warn("Breakable blocks config has a different schema version (Expected: {}, Found: {})", (Object)2, (Object)schemaVersion);
                    }
                    this.breakableStateToProperties = (StateToPropertyHashMap)gson.fromJson((JsonElement)JSONUtils.func_151213_a((JsonObject)config, (String)BREAKABLE_BLOCKS_KEY, (JsonArray)new JsonArray()), StateToPropertyHashMap.class);
                } else {
                    Powershot.log.warn("Breakable blocks config does not contain an object. Assuming it's using the old schema");
                    this.breakableStateToProperties = (StateToPropertyHashMap)gson.fromJson(element, StateToPropertyHashMap.class);
                }
            }
            catch (JsonParseException | IOException e) {
                Powershot.log.warn("Failed to read file " + this.breakableBlocksConfigFile, e);
            }
            Powershot.log.debug("Breakable block states: {}", (Object)this.breakableStateToProperties.statesSize());
            Powershot.log.debug("Breakable block tags: {}", (Object)this.breakableStateToProperties.tagsSize());
        } else {
            this.writeBreakableBlocksConfig();
        }
    }

    public void writePowerCalculationConfig() {
        try {
            JsonObject config = new JsonObject();
            JsonObject multipliers = new JsonObject();
            for (Object2FloatMap.Entry entry : this.enchantmentToMultiplier.object2FloatEntrySet()) {
                float multiplier = entry.getFloatValue();
                if (multiplier == 0.0f || !Float.isFinite(multiplier)) continue;
                multipliers.addProperty(((ResourceLocation)entry.getKey()).toString(), (Number)Float.valueOf(multiplier));
            }
            config.addProperty(SCHEMA_VERSION_KEY, (Number)2);
            config.addProperty(BASE_POWER_KEY, (Number)Float.valueOf(this.basePower));
            config.add(ENCHANTMENT_MULTIPLIERS_KEY, (JsonElement)multipliers);
            FileUtils.write((File)this.powerCalculationConfigFile, (CharSequence)gson.toJson((JsonElement)config), (Charset)StandardCharsets.UTF_8, (boolean)false);
        }
        catch (IOException e) {
            Powershot.log.warn("Failed to write file " + this.powerCalculationConfigFile, (Throwable)e);
        }
    }

    public void writeBreakableBlocksConfig() {
        try {
            JsonObject config = new JsonObject();
            config.addProperty(SCHEMA_VERSION_KEY, (Number)2);
            config.add(BREAKABLE_BLOCKS_KEY, gson.toJsonTree((Object)this.breakableStateToProperties, StateToPropertyHashMap.class));
            FileUtils.write((File)this.breakableBlocksConfigFile, (CharSequence)gson.toJson((JsonElement)config), (Charset)StandardCharsets.UTF_8, (boolean)false);
        }
        catch (IOException e) {
            Powershot.log.warn("Failed to write file " + this.breakableBlocksConfigFile, (Throwable)e);
        }
    }

    public static Object2FloatMap<ResourceLocation> getDefaultEnchantmentMultipliers() {
        Object2FloatOpenHashMap defaults = new Object2FloatOpenHashMap(4);
        defaults.put((Object)ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)Enchantments.field_185309_u), 1.0f);
        defaults.put((Object)ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)Enchantments.field_222194_I), 1.0f);
        defaults.put((Object)ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)Enchantments.field_185310_v), 1.0f);
        defaults.put((Object)ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)Enchantments.field_180313_o), 1.0f);
        return Object2FloatMaps.unmodifiable((Object2FloatMap)defaults);
    }

    public static StateToPropertyHashMap getDefaultBreakableStatesAndProperties() {
        StateToPropertyHashMap.Builder defaults = new StateToPropertyHashMap.Builder();
        defaults.put(Blocks.field_205164_gk, new BreakableBlockStateProperties(5.0f, 5.0f));
        defaults.put(Blocks.field_150403_cj, new BreakableBlockStateProperties(4.0f, 4.0f));
        BreakableBlockStateProperties properties = new BreakableBlockStateProperties(3.15f, 3.15f);
        defaults.put((ITag.INamedTag<Block>)Tags.Blocks.GLASS, properties);
        defaults.put(Blocks.field_150432_aD, properties);
        defaults.put(Blocks.field_185778_de, properties);
        defaults.put(Blocks.field_150440_ba, properties);
        defaults.put(Blocks.field_150423_aK, properties);
        defaults.put(Blocks.field_196625_cS, properties);
        properties = new BreakableBlockStateProperties(2.0f, 2.0f);
        defaults.put((ITag.INamedTag<Block>)BlockTags.field_200032_i, properties);
        defaults.put((ITag.INamedTag<Block>)Tags.Blocks.GLASS_PANES, properties);
        defaults.put(Blocks.field_185764_cQ, properties);
        defaults.put(Blocks.field_222432_lU, properties);
        defaults.put(Blocks.field_235366_md_, properties);
        defaults.put(Blocks.field_150479_bC, properties);
        defaults.put(Blocks.field_222405_kQ, properties);
        properties = BreakableBlockStateProperties.DEFAULT;
        defaults.put(Blocks.field_150478_aa, properties);
        defaults.put(Blocks.field_196591_bQ, properties);
        defaults.put(Blocks.field_150429_aA, properties);
        defaults.put(Blocks.field_196677_cy, properties);
        defaults.put(Blocks.field_235339_cQ_, properties);
        defaults.put(Blocks.field_235340_cR_, properties);
        defaults.put(Blocks.field_150375_by, properties);
        defaults.put(Blocks.field_204913_jW, properties);
        defaults.put(Blocks.field_196651_dG, new BreakableBlockStateProperties(1.0f, 1.0f));
        return defaults.build();
    }
}

