/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.qolq.powershot;

import com.gitlab.qolq.powershot.BreakableBlockStateProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;

public final class StateToPropertyHashMap {
    private volatile Map<BlockState, BreakableBlockStateProperties> merged;
    final Map<BlockState, BreakableBlockStateProperties> states;
    final Map<ResourceLocation, BreakableBlockStateProperties> tags;

    private StateToPropertyHashMap(Map<BlockState, BreakableBlockStateProperties> states, Map<ResourceLocation, BreakableBlockStateProperties> tags) {
        this.states = Collections.unmodifiableMap(states);
        this.tags = Collections.unmodifiableMap(tags);
    }

    public BreakableBlockStateProperties get(BlockState key) {
        return this.merged.get(key);
    }

    public synchronized void reloadTags() {
        ITagCollection collection = TagCollectionManager.func_242178_a().func_241835_a();
        HashMap<BlockState, BreakableBlockStateProperties> map = new HashMap<BlockState, BreakableBlockStateProperties>();
        for (Map.Entry<ResourceLocation, BreakableBlockStateProperties> entry : this.tags.entrySet()) {
            ITag tag = collection.func_199910_a(entry.getKey());
            if (tag == null) continue;
            for (Block block : tag.func_230236_b_()) {
                for (BlockState state : block.func_176194_O().func_177619_a()) {
                    map.put(state, entry.getValue());
                }
            }
        }
        map.putAll(this.states);
        this.merged = Collections.unmodifiableMap(map);
    }

    public int statesSize() {
        return this.states.size();
    }

    public int tagsSize() {
        return this.tags.size();
    }

    public static final class Builder {
        private final Map<BlockState, BreakableBlockStateProperties> states = new HashMap<BlockState, BreakableBlockStateProperties>();
        private final Map<ResourceLocation, BreakableBlockStateProperties> tags = new LinkedHashMap<ResourceLocation, BreakableBlockStateProperties>();

        public void put(BlockState state, BreakableBlockStateProperties properties) {
            this.states.put(state, properties);
        }

        public void put(Block block, BreakableBlockStateProperties properties) {
            for (BlockState state : block.func_176194_O().func_177619_a()) {
                this.put(state, properties);
            }
        }

        public void put(ResourceLocation tag, BreakableBlockStateProperties properties) {
            this.tags.put(tag, properties);
        }

        public void put(ITag.INamedTag<Block> tag, BreakableBlockStateProperties properties) {
            this.put(tag.func_230234_a_(), properties);
        }

        public StateToPropertyHashMap build() {
            return new StateToPropertyHashMap(this.states, this.tags);
        }
    }
}

