/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.qolq.powershot;

import com.gitlab.qolq.powershot.BreakableBlockStateProperties;
import com.gitlab.qolq.powershot.Powershot;
import com.gitlab.qolq.powershot.StateToPropertyHashMap;
import com.google.common.collect.HashMultimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.registries.ForgeRegistries;

public final class StateToPropertyHashMapSerializer
implements JsonDeserializer<StateToPropertyHashMap>,
JsonSerializer<StateToPropertyHashMap> {
    private static final String BLOCKS_KEY = "blocks";
    private static final String BLOCK_ID_KEY = "id";
    private static final String BLOCK_STATES_KEY = "states";
    private static final String TAGS_KEY = "tags";
    private static final String POWER_REQUIREMENT_KEY = "power_req";
    private static final String POWER_REDUCTION_KEY = "power_red";
    private static final String NORMAL_BLOCK_STATE_ENTRY = "normal";

    public StateToPropertyHashMap deserialize(JsonElement source, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonArray jsonEntries = JSONUtils.func_151207_m((JsonElement)source, (String)"top-level element");
        StateToPropertyHashMap.Builder builder = new StateToPropertyHashMap.Builder();
        for (JsonElement jsonEntry : jsonEntries) {
            try {
                this.deserializeTopLevelEntry(JSONUtils.func_151210_l((JsonElement)jsonEntry, (String)"top-level entry"), builder);
            }
            catch (JsonParseException e) {
                Powershot.log.warn("Error while parsing top-level entry", (Throwable)e);
            }
        }
        return builder.build();
    }

    private void deserializeTopLevelEntry(JsonObject jsonEntry, StateToPropertyHashMap.Builder builder) {
        JsonElement jsonBlocks = jsonEntry.get(BLOCKS_KEY);
        JsonElement jsonTags = jsonEntry.get(TAGS_KEY);
        if (jsonBlocks == null && jsonTags == null) {
            Powershot.log.warn("Invalid top-level entry: no blocks or tags specified -> {}", (Object)jsonEntry);
            return;
        }
        BreakableBlockStateProperties properties = new BreakableBlockStateProperties(JSONUtils.func_151221_a((JsonObject)jsonEntry, (String)POWER_REQUIREMENT_KEY, (float)1.5f), JSONUtils.func_151221_a((JsonObject)jsonEntry, (String)POWER_REDUCTION_KEY, (float)1.5f));
        if (jsonBlocks != null) {
            try {
                for (BlockState state : this.deserializeBlockEntries(jsonBlocks)) {
                    builder.put(state, properties);
                }
            }
            catch (JsonParseException e) {
                Powershot.log.warn("Error while parsing block entries", (Throwable)e);
            }
        }
        if (jsonTags != null) {
            try {
                for (ResourceLocation tag : this.deserializeTagEntries(jsonTags)) {
                    builder.put(tag, properties);
                }
            }
            catch (JsonParseException e) {
                Powershot.log.warn("Error while parsing tag entries", (Throwable)e);
            }
        }
    }

    private ResourceLocation deserializeResourceLocation(JsonElement json, String name) {
        try {
            return new ResourceLocation(JSONUtils.func_151206_a((JsonElement)json, (String)name));
        }
        catch (ResourceLocationException e) {
            throw new JsonParseException((Throwable)e);
        }
    }

    private Set<ResourceLocation> deserializeTagEntries(JsonElement jsonTags) {
        if (jsonTags.isJsonArray()) {
            HashSet<ResourceLocation> tags = new HashSet<ResourceLocation>();
            for (JsonElement jsonTag : jsonTags.getAsJsonArray()) {
                try {
                    tags.add(this.deserializeResourceLocation(jsonTag, "block tag entry"));
                }
                catch (JsonParseException e) {
                    Powershot.log.warn("Error while parsing tag entry", (Throwable)e);
                }
            }
            return tags;
        }
        return Collections.singleton(this.deserializeResourceLocation(jsonTags, "block tag entry"));
    }

    private Set<BlockState> deserializeBlockEntries(JsonElement jsonBlocks) {
        if (jsonBlocks.isJsonObject()) {
            return this.deserializeObjectBlockEntry(jsonBlocks.getAsJsonObject());
        }
        if (jsonBlocks.isJsonArray()) {
            return this.deserializeArrayBlockEntry(jsonBlocks.getAsJsonArray());
        }
        if (jsonBlocks.isJsonPrimitive()) {
            return this.deserializeStringBlockEntry(jsonBlocks.getAsJsonPrimitive());
        }
        Powershot.log.warn("Invalid block entry: was not a string, an object, nor an array -> {}", (Object)jsonBlocks);
        return Collections.emptySet();
    }

    private Set<BlockState> deserializeArrayBlockEntry(JsonArray jsonBlocks) {
        HashSet<BlockState> states = new HashSet<BlockState>();
        for (JsonElement jsonBlock : jsonBlocks) {
            try {
                if (jsonBlock.isJsonObject()) {
                    states.addAll(this.deserializeObjectBlockEntry(jsonBlock.getAsJsonObject()));
                    continue;
                }
                if (jsonBlock.isJsonPrimitive()) {
                    states.addAll(this.deserializeStringBlockEntry(jsonBlock.getAsJsonPrimitive()));
                    continue;
                }
                Powershot.log.warn("Invalid block entry: was neither a string nor an object -> {}", (Object)jsonBlock);
            }
            catch (JsonParseException e) {
                Powershot.log.warn("Error while parsing block entry", (Throwable)e);
            }
        }
        return states;
    }

    private Set<BlockState> deserializeStringBlockEntry(JsonPrimitive jsonBlock) {
        ResourceLocation id = this.deserializeResourceLocation((JsonElement)jsonBlock, "block entry");
        if (ForgeRegistries.BLOCKS.containsKey(id)) {
            return new HashSet<BlockState>((Collection<BlockState>)((Block)ForgeRegistries.BLOCKS.getValue(id)).func_176194_O().func_177619_a());
        }
        Powershot.log.warn("Invalid block entry: '{}' is not a registered block", (Object)id);
        return Collections.emptySet();
    }

    private Set<BlockState> deserializeObjectBlockEntry(JsonObject jsonBlock) {
        JsonElement jsonId = jsonBlock.get(BLOCK_ID_KEY);
        if (jsonId == null) {
            Powershot.log.warn("Invalid block entry: no block id specified -> {}", (Object)jsonBlock);
            return Collections.emptySet();
        }
        ResourceLocation id = this.deserializeResourceLocation(jsonId, "block id entry");
        if (!ForgeRegistries.BLOCKS.containsKey(id)) {
            Powershot.log.warn("Invalid block entry: '{}' is not a registered block", (Object)id);
            return Collections.emptySet();
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
        JsonElement jsonStates = jsonBlock.get(BLOCK_STATES_KEY);
        assert (block != null);
        if (jsonStates == null) {
            return new HashSet<BlockState>((Collection<BlockState>)block.func_176194_O().func_177619_a());
        }
        StateContainer stateContainer = block.func_176194_O();
        HashSet<BlockState> states = new HashSet<BlockState>();
        for (JsonElement jsonState : JSONUtils.func_151207_m((JsonElement)jsonStates, (String)"block states entry")) {
            try {
                String stringState = JSONUtils.func_151206_a((JsonElement)jsonState, (String)"block state entry");
                BlockState state = this.deserializeBlockStateEntry(stringState, (StateContainer<Block, BlockState>)stateContainer, id);
                if (state == null) continue;
                states.add(state);
            }
            catch (JsonParseException e) {
                Powershot.log.warn("Error while parsing '" + id + "' state entry -> " + jsonState, (Throwable)e);
            }
        }
        return states;
    }

    private <T extends Comparable<T>> BlockState deserializeBlockStateEntry(String stringState, StateContainer<Block, BlockState> container, ResourceLocation block) {
        if (NORMAL_BLOCK_STATE_ENTRY.equals(stringState)) {
            return (BlockState)container.func_177621_b();
        }
        String[] stringProperties = stringState.split(",");
        BlockState state = (BlockState)container.func_177621_b();
        for (String stringProperty : stringProperties) {
            String[] propertyAndValueNames = stringProperty.split("=");
            if (propertyAndValueNames.length != 2) {
                Powershot.log.warn("Invalid '{}' state entry: '{}' is not a property name and value pair", (Object)block, (Object)stringProperty);
                return null;
            }
            String propertyName = propertyAndValueNames[0];
            Property property = container.func_185920_a(propertyName);
            if (property == null) {
                Powershot.log.warn("Invalid '{}' state entry: no property named '{}'", (Object)block, (Object)propertyName);
                return null;
            }
            String valueName = propertyAndValueNames[1];
            Comparable value = property.func_185929_b(valueName).orElse(null);
            if (value == null) {
                Powershot.log.warn("Invalid '{}' state entry: property '{}' has no value '{}'", (Object)block, (Object)propertyName, (Object)valueName);
                return null;
            }
            state = (BlockState)state.func_206870_a(property, value);
        }
        return state;
    }

    public JsonElement serialize(StateToPropertyHashMap source, Type type, JsonSerializationContext context) {
        JsonArray jsonEntries = new JsonArray();
        HashMultimap propsToStates = HashMultimap.create();
        HashMultimap propsToTags = HashMultimap.create();
        for (Map.Entry<BlockState, BreakableBlockStateProperties> entry : source.states.entrySet()) {
            propsToStates.put((Object)entry.getValue(), (Object)entry.getKey());
        }
        for (Map.Entry<BlockState, BreakableBlockStateProperties> entry : source.tags.entrySet()) {
            propsToTags.put((Object)entry.getValue(), (Object)entry.getKey());
        }
        HashSet properties = new HashSet();
        properties.addAll(propsToStates.keySet());
        properties.addAll(propsToTags.keySet());
        for (BreakableBlockStateProperties property : properties) {
            JsonArray jsonBlocks = null;
            JsonArray jsonTags = null;
            if (propsToStates.containsKey((Object)property)) {
                jsonBlocks = this.serializeBlockEntry(propsToStates.get((Object)property));
            }
            if (propsToTags.containsKey((Object)property)) {
                jsonTags = this.serializeTagEntry(propsToTags.get((Object)property));
            }
            jsonEntries.add((JsonElement)this.serializeTopLevelEntry(jsonBlocks, jsonTags, property));
        }
        return jsonEntries;
    }

    private JsonObject serializeTopLevelEntry(JsonArray jsonBlocks, JsonArray jsonTags, BreakableBlockStateProperties properties) {
        JsonObject jsonEntry = new JsonObject();
        if (jsonBlocks != null) {
            jsonEntry.add(BLOCKS_KEY, (JsonElement)(jsonBlocks.size() == 1 ? jsonBlocks.get(0) : jsonBlocks));
        }
        if (jsonTags != null) {
            jsonEntry.add(TAGS_KEY, (JsonElement)(jsonTags.size() == 1 ? jsonTags.get(0) : jsonTags));
        }
        if (properties.powerRequirement != 1.5f) {
            jsonEntry.addProperty(POWER_REQUIREMENT_KEY, (Number)Float.valueOf(properties.powerRequirement));
        }
        if (properties.powerReduction != 1.5f) {
            jsonEntry.addProperty(POWER_REDUCTION_KEY, (Number)Float.valueOf(properties.powerReduction));
        }
        return jsonEntry;
    }

    private JsonArray serializeTagEntry(Collection<ResourceLocation> tags) {
        JsonArray jsonTags = new JsonArray();
        for (ResourceLocation tag : tags) {
            jsonTags.add(tag.toString());
        }
        return jsonTags;
    }

    private JsonArray serializeBlockEntry(Collection<BlockState> states) {
        JsonArray jsonBlocks = new JsonArray();
        HashMultimap idToStates = HashMultimap.create();
        for (BlockState blockState : states) {
            idToStates.put((Object)blockState.func_177230_c().getRegistryName(), (Object)blockState);
        }
        for (Map.Entry entry : idToStates.asMap().entrySet()) {
            ResourceLocation id = (ResourceLocation)entry.getKey();
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
            states = (Collection)entry.getValue();
            assert (block != null);
            if (states.containsAll((Collection<?>)block.func_176194_O().func_177619_a())) {
                jsonBlocks.add(id.toString());
                continue;
            }
            JsonArray stringStates = new JsonArray();
            for (BlockState state : states) {
                stringStates.add((JsonElement)this.serializeBlockStateEntry((Map<Property<?>, Comparable<?>>)state.func_206871_b()));
            }
            JsonObject jsonBlock = new JsonObject();
            jsonBlock.addProperty(BLOCK_ID_KEY, id.toString());
            jsonBlock.add(BLOCK_STATES_KEY, (JsonElement)stringStates);
            jsonBlocks.add((JsonElement)jsonBlock);
        }
        return jsonBlocks;
    }

    private <T extends Comparable<T>> JsonPrimitive serializeBlockStateEntry(Map<Property<?>, Comparable<?>> props) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Property<?>, Comparable<?>> entry : props.entrySet()) {
            if (builder.length() != 0) {
                builder.append(",");
            }
            Property<?> property = entry.getKey();
            builder.append(property.func_177701_a()).append("=").append(property.func_177702_a(entry.getValue()));
        }
        if (builder.length() == 0) {
            builder.append(NORMAL_BLOCK_STATE_ENTRY);
        }
        return new JsonPrimitive(builder.toString());
    }
}

