/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.qolq.powershot.mixin;

import com.gitlab.qolq.powershot.IPowerable;
import com.gitlab.qolq.powershot.Powershot;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrowEntity.class})
public abstract class AbstractArrowEntityMixin
extends Entity
implements IPowerable {
    @Unique
    private static final String POWER_KEY = "powershot:power";
    @Unique
    private float power = 0.0f;

    public AbstractArrowEntityMixin(EntityType<?> type, World world) {
        super(type, world);
    }

    @Override
    @Unique
    public float getPower() {
        return this.power;
    }

    @Override
    @Unique
    public void setPower(float power) {
        this.power = power;
    }

    @Inject(method={"shoot"}, at={@At(value="HEAD")})
    private void setPower(double x, double y, double z, float speed, float inaccuracy, CallbackInfo info) {
        if (!this.field_70170_p.field_72995_K) {
            this.setPower(Powershot.calculatePower((AbstractArrowEntity)this, speed));
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/world/World;rayTraceBlocks(Lnet/minecraft/util/math/RayTraceContext;)Lnet/minecraft/util/math/BlockRayTraceResult;"))
    private BlockRayTraceResult trace(World world, RayTraceContext context) {
        return Powershot.trace(world, context, (AbstractArrowEntity)this);
    }

    @Inject(method={"writeAdditional"}, at={@At(value="HEAD")})
    private void writeData(CompoundNBT tag, CallbackInfo info) {
        tag.func_74776_a(POWER_KEY, this.getPower());
    }

    @Inject(method={"readAdditional"}, at={@At(value="HEAD")})
    private void readData(CompoundNBT tag, CallbackInfo info) {
        this.setPower(tag.func_74760_g(POWER_KEY));
    }
}

