/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.wuest.prefab.Config.ServerModConfiguration;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Proxy.CommonProxy;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraftforge.common.ForgeConfigSpec;

public class ModConfiguration {
    public static String tagKey = "PrefabConfig";
    static String maximumHouseSizeName = "Maximum Starting House Size";
    static String enableVersionCheckMessageName = "Enable Version Checking";
    static String enableLoftHouseName = "Enable Loft House";
    static String includeSpawnersInMasherName = "Include Spawners in Monster Masher";
    static String enableStructurePreviewName = "Include Structure Previews";
    static String includeMineshaftChestName = "Include Mineshaft Chest";
    static String addSwordName = "Add Sword";
    static String addAxeName = "Add Axe";
    static String addHoeName = "Add Hoe";
    static String addShovelName = "Add Shovel";
    static String addPickAxeName = "Add Pickaxe";
    static String addArmorName = "Add Armor";
    static String addFoodName = "Add Food";
    static String addCropsName = "Add Crops";
    static String addDirtName = "Add Dirt";
    static String addCobbleName = "Add Cobblestone";
    static String addSaplingsName = "Add Saplings";
    static String addTorchesName = "Add Torches";
    static String startingItemName = "Starting Item";
    static String addBedName = "Add Bed";
    static String addCraftingTableName = "Add Crafting Table";
    static String addFurnaceName = "Add Furnace";
    static String addChestsName = "Add Chests";
    static String addChestContentsName = "Add Chest Contents";
    static String addMineshaftName = "Add Mineshaft";
    static String allowBulldozerToCreateDropsName = "Bulldozer Creates Drops";
    private static String OPTIONS = "general.";
    private static String ChestContentOptions = "general.chest contents.";
    private static String RecipeOptions = "general.recipes.";
    private static String starterHouseOptions = "general.starter house.";
    private static ArrayList<String> validStartingItems = new ArrayList<String>(Arrays.asList("Starting House", "Moderate House", "Structure Part", "Nothing"));
    private static String compressedStoneKey = "Compressed Stone";
    private static String compressedGlowStoneKey = "Compressed Glowstone";
    private static String compressedDirteKey = "Compressed Dirt";
    private static String compressedChestKey = "Compressed Chest";
    private static String pileOfBricksKey = "Pile of Bricks";
    private static String warehouseKey = "Warehouse";
    private static String produceFarmKey = "Produce Farm";
    private static String treeFarmKey = "Tree Farm";
    private static String chickenCoopKey = "Chicken Coop";
    private static String fishFarmKey = "Fish Farm";
    private static String warehouseUpgradeKey = "Warehouse Upgrade";
    private static String advancedWarehouseKey = "Advanced Warehouse";
    private static String monsterMasherKey = "Monster Masher";
    private static String bundleofTimberKey = "Bundle of Timber";
    private static String horseStableKey = "Horse Stable";
    private static String netherGateKey = "Nether Gate";
    private static String advancedChickenCoopKey = "Advanced Chicken Coop";
    private static String advancedHorseStableKey = "Advanced Horse Stable";
    private static String barnKey = "Barn";
    private static String machineryTowerKey = "Machinery Tower";
    private static String defenseBunkerKey = "Defense Bunker";
    private static String mineshaftEntranceKey = "Mineshaft Entrance";
    private static String enderGatewayKey = "Ender Gateway";
    private static String aquaBaseKey = "Aqua Base";
    private static String grassyPlainsKey = "Grassy Plains";
    private static String magicTempleKey = "Magic Temple";
    private static String instantBridgeKey = "Instant Bridge";
    private static String paperLanternKey = "Paper Lantern";
    private static String compressedObsidianKey = "Compressed Obsidian";
    private static String villagerHousesKey = "Villager Houses";
    private static String phasicBlockKey = "Phasic Block";
    private static String smartGlassKey = "Smart Glass";
    private static String greenHouseKey = "Green House";
    private static String startingHouseKey = "Starting House";
    private static String glassStairsKey = "Glass Stairs";
    private static String andesiteStairsKey = "Andesite Stairs";
    private static String dioriteStairsKey = "Diorite Stairs";
    private static String graniteStairsKey = "Granite Stairs";
    private static String glassSlabsKey = "Glass Slabs";
    private static String andesiteSlabsKey = "Andesite Slabs";
    private static String dioriteSlabKey = "Diorite Slabs";
    private static String grantiteSlabKey = "Granite Slabs";
    private static String moderateHouseKey = "Moderate House";
    private static String watchTowerKey = "Watch Tower";
    private static String bulldozerKey = "Bulldozer";
    private static String structurePartKey = "StructurePart";
    private static String jailKey = "Jail";
    private static String saloonKey = "Saloon";
    private static String skiLodgeKey = "Ski Lodge";
    private static String windMillKey = "Windmill";
    private static String townHallKey = "Town Hall";
    private static String heapOfTimberKey = "Heap of Timber";
    private static String tonOfTimberKey = "Ton of Timber";
    static String[] recipeKeys = new String[]{compressedStoneKey, compressedGlowStoneKey, compressedDirteKey, compressedChestKey, pileOfBricksKey, warehouseKey, produceFarmKey, treeFarmKey, chickenCoopKey, fishFarmKey, warehouseUpgradeKey, advancedWarehouseKey, monsterMasherKey, bundleofTimberKey, horseStableKey, netherGateKey, advancedChickenCoopKey, advancedHorseStableKey, barnKey, machineryTowerKey, defenseBunkerKey, mineshaftEntranceKey, enderGatewayKey, magicTempleKey, instantBridgeKey, paperLanternKey, compressedObsidianKey, villagerHousesKey, phasicBlockKey, smartGlassKey, greenHouseKey, startingHouseKey, glassStairsKey, glassSlabsKey, andesiteStairsKey, andesiteSlabsKey, dioriteStairsKey, dioriteSlabKey, graniteStairsKey, grantiteSlabKey, moderateHouseKey, grassyPlainsKey, aquaBaseKey, watchTowerKey, bulldozerKey, structurePartKey, jailKey, saloonKey, skiLodgeKey, windMillKey, townHallKey, heapOfTimberKey, tonOfTimberKey};
    public ServerModConfiguration serverConfiguration;
    private ForgeConfigSpec.IntValue maximumStartingHouseSize;
    private ForgeConfigSpec.BooleanValue enableLoftHouse;
    private ForgeConfigSpec.BooleanValue includeSpawnersInMasher;
    private ForgeConfigSpec.BooleanValue enableStructurePreview;
    private ForgeConfigSpec.BooleanValue allowBulldozerToCreateDrops;
    private ForgeConfigSpec.BooleanValue includeMineshaftChest;
    private ForgeConfigSpec.BooleanValue addSword;
    private ForgeConfigSpec.BooleanValue addAxe;
    private ForgeConfigSpec.BooleanValue addHoe;
    private ForgeConfigSpec.BooleanValue addShovel;
    private ForgeConfigSpec.BooleanValue addPickAxe;
    private ForgeConfigSpec.BooleanValue addArmor;
    private ForgeConfigSpec.BooleanValue addFood;
    private ForgeConfigSpec.BooleanValue addCrops;
    private ForgeConfigSpec.BooleanValue addDirt;
    private ForgeConfigSpec.BooleanValue addCobble;
    private ForgeConfigSpec.BooleanValue addSaplings;
    private ForgeConfigSpec.BooleanValue addTorches;
    private ForgeConfigSpec.BooleanValue addBed;
    private ForgeConfigSpec.BooleanValue addCraftingTable;
    private ForgeConfigSpec.BooleanValue addFurnace;
    private ForgeConfigSpec.BooleanValue addChests;
    private ForgeConfigSpec.BooleanValue addChestContents;
    private ForgeConfigSpec.BooleanValue addMineshaft;
    private ForgeConfigSpec.ConfigValue<String> startingItem;
    private HashMap<String, ForgeConfigSpec.BooleanValue> recipeConfiguration = new HashMap();

    public ModConfiguration(ForgeConfigSpec.Builder builder) {
        this.serverConfiguration = new ServerModConfiguration();
        ModConfiguration.buildOptions(this, builder);
    }

    private static void buildOptions(ModConfiguration config, ForgeConfigSpec.Builder builder) {
        CommonProxy.proxyConfiguration = config;
        builder.comment("General");
        CommonProxy.proxyConfiguration.startingItem = builder.comment("Determines which starting item a player gets on first world join. Valid values for this option are: \"Starting House\", \"Moderate House\", \"Structure Part\", \"Nothing\". Server configuration overrides client.").defineInList(OPTIONS + startingItemName, (Object)"Starting House", validStartingItems);
        CommonProxy.proxyConfiguration.maximumStartingHouseSize = builder.comment("Determines the maximum size the starting house can be generated as. Server configuration overrides client.").defineInRange(OPTIONS + maximumHouseSizeName, 16, 5, 16);
        CommonProxy.proxyConfiguration.enableLoftHouse = builder.comment("Determines if the loft starter house is enabled. This house contains Nether materials in it's construction. Server configuration overrides client.").define(OPTIONS + enableLoftHouseName, false);
        CommonProxy.proxyConfiguration.includeSpawnersInMasher = builder.comment("Determines if the spawners for the Monster Masher building are included. Server configuration overrides client.").define(OPTIONS + includeSpawnersInMasherName, true);
        CommonProxy.proxyConfiguration.enableStructurePreview = builder.comment("Determines if the Preview buttons in structure GUIs and other structure previews functions are enabled. Client side only.").define(OPTIONS + enableStructurePreviewName, true);
        CommonProxy.proxyConfiguration.includeMineshaftChest = builder.comment("Determines if the mineshaft chest is included when building mineshafts for various structures.").define(OPTIONS + includeMineshaftChestName, true);
        CommonProxy.proxyConfiguration.allowBulldozerToCreateDrops = builder.comment("Determines if the bulldozer item can create drops when it clears an area.").define(OPTIONS + allowBulldozerToCreateDropsName, true);
        builder.comment("Chest Options");
        CommonProxy.proxyConfiguration.addSword = builder.comment("Determines if a Stone Sword is added the the chest when the house is created.").define(ChestContentOptions + addSwordName, true);
        CommonProxy.proxyConfiguration.addAxe = builder.comment("Determines if a Stone Axe is added the the chest when the house is created.").define(ChestContentOptions + addAxeName, true);
        CommonProxy.proxyConfiguration.addShovel = builder.comment("Determines if a Stone Shovel is added the the chest when the house is created.").define(ChestContentOptions + addShovelName, true);
        CommonProxy.proxyConfiguration.addHoe = builder.comment("Determines if a Stone Hoe is added the the chest when the house is created.").define(ChestContentOptions + addHoeName, true);
        CommonProxy.proxyConfiguration.addPickAxe = builder.comment("Determines if a Stone Pickaxe is added the the chest when the house is created.").define(ChestContentOptions + addPickAxeName, true);
        CommonProxy.proxyConfiguration.addArmor = builder.comment("Determines if Leather Armor is added the the chest when the house is created.").define(ChestContentOptions + addArmorName, true);
        CommonProxy.proxyConfiguration.addFood = builder.comment("Determines if Bread is added the the chest when the house is created.").define(ChestContentOptions + addFoodName, true);
        CommonProxy.proxyConfiguration.addCrops = builder.comment("Determines if seeds, potatoes and carrots are added the the chest when the house is created.").define(ChestContentOptions + addCropsName, true);
        CommonProxy.proxyConfiguration.addDirt = builder.comment("Determines if a stack of dirt is added the the chest when the house is created.").define(ChestContentOptions + addDirtName, true);
        CommonProxy.proxyConfiguration.addCobble = builder.comment("Determines if a stack of cobble is added the the chest when the house is created.").define(ChestContentOptions + addCobbleName, true);
        CommonProxy.proxyConfiguration.addSaplings = builder.comment("Determines if a set of oak saplings are added the the chest when the house is created.").define(ChestContentOptions + addSaplingsName, true);
        CommonProxy.proxyConfiguration.addTorches = builder.comment("Determines if a set of torches are added the the chest when the house is created.").define(ChestContentOptions + addTorchesName, true);
        builder.comment("Starter House Options");
        CommonProxy.proxyConfiguration.addBed = builder.comment("Determines if the bed is included in the starter house. When playing on a server, the server configuration is used").define(starterHouseOptions + addBedName, true);
        CommonProxy.proxyConfiguration.addCraftingTable = builder.comment("Determines if the crafting table is included in the starter house. When playing on a server, the server configuration is used").define(starterHouseOptions + addCraftingTableName, true);
        CommonProxy.proxyConfiguration.addFurnace = builder.comment("Determines if the furnace is included in the starter house. When playing on a server, the server configuration is used").define(starterHouseOptions + addFurnaceName, true);
        CommonProxy.proxyConfiguration.addChests = builder.comment("Determines if chests are included in the starter house. When playing on a server, the server configuration is used").define(starterHouseOptions + addChestsName, true);
        CommonProxy.proxyConfiguration.addChestContents = builder.comment("Determines if the chest contents is included in the starter house. When playing on a server, the server configuration is used").define(starterHouseOptions + addChestContentsName, true);
        CommonProxy.proxyConfiguration.addMineshaft = builder.comment("Determines if the mineshaft is included in the starter house. When playing on a server, the server configuration is used").define(starterHouseOptions + addMineshaftName, true);
        for (String key : recipeKeys) {
            ForgeConfigSpec.BooleanValue value = builder.comment("Determines if the recipe(s) associated with the " + key + " are enabled.").define(RecipeOptions + key, true);
            CommonProxy.proxyConfiguration.recipeConfiguration.put(key, value);
        }
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        Prefab.LOGGER.debug("Loading config file {}", (Object)path);
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        Prefab.LOGGER.debug("Built TOML config for {}", (Object)path.toString());
        configData.load();
        Prefab.LOGGER.debug("Loaded TOML config file {}", (Object)path.toString());
        spec.setConfig((CommentedConfig)configData);
        ModConfiguration.UpdateServerConfig();
    }

    private static void UpdateServerConfig() {
        CommonProxy.proxyConfiguration.serverConfiguration.startingItem = (String)CommonProxy.proxyConfiguration.startingItem.get();
        CommonProxy.proxyConfiguration.serverConfiguration.maximumStartingHouseSize = (Integer)CommonProxy.proxyConfiguration.maximumStartingHouseSize.get();
        CommonProxy.proxyConfiguration.serverConfiguration.enableLoftHouse = (Boolean)CommonProxy.proxyConfiguration.enableLoftHouse.get();
        CommonProxy.proxyConfiguration.serverConfiguration.includeSpawnersInMasher = (Boolean)CommonProxy.proxyConfiguration.includeSpawnersInMasher.get();
        CommonProxy.proxyConfiguration.serverConfiguration.enableStructurePreview = (Boolean)CommonProxy.proxyConfiguration.enableStructurePreview.get();
        CommonProxy.proxyConfiguration.serverConfiguration.includeMineshaftChest = (Boolean)CommonProxy.proxyConfiguration.includeMineshaftChest.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addSword = (Boolean)CommonProxy.proxyConfiguration.addSword.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addAxe = (Boolean)CommonProxy.proxyConfiguration.addAxe.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addShovel = (Boolean)CommonProxy.proxyConfiguration.addShovel.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addHoe = (Boolean)CommonProxy.proxyConfiguration.addHoe.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addPickAxe = (Boolean)CommonProxy.proxyConfiguration.addPickAxe.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addArmor = (Boolean)CommonProxy.proxyConfiguration.addArmor.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addFood = (Boolean)CommonProxy.proxyConfiguration.addFood.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addCrops = (Boolean)CommonProxy.proxyConfiguration.addCrops.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addDirt = (Boolean)CommonProxy.proxyConfiguration.addDirt.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addCobble = (Boolean)CommonProxy.proxyConfiguration.addCobble.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addSaplings = (Boolean)CommonProxy.proxyConfiguration.addSaplings.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addTorches = (Boolean)CommonProxy.proxyConfiguration.addTorches.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addBed = (Boolean)CommonProxy.proxyConfiguration.addBed.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addCraftingTable = (Boolean)CommonProxy.proxyConfiguration.addCraftingTable.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addFurnace = (Boolean)CommonProxy.proxyConfiguration.addFurnace.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addChests = (Boolean)CommonProxy.proxyConfiguration.addChests.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addChestContents = (Boolean)CommonProxy.proxyConfiguration.addChestContents.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addMineshaft = (Boolean)CommonProxy.proxyConfiguration.addMineshaft.get();
        CommonProxy.proxyConfiguration.serverConfiguration.allowBulldozerToCreateDrops = (Boolean)CommonProxy.proxyConfiguration.allowBulldozerToCreateDrops.get();
        for (String key : recipeKeys) {
            Prefab.LOGGER.debug("Setting recipe configuration for key: " + key);
            CommonProxy.proxyConfiguration.serverConfiguration.recipeConfiguration.put(key, (Boolean)CommonProxy.proxyConfiguration.recipeConfiguration.get(key).get());
        }
    }
}

