/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Base;

import com.wuest.prefab.Proxy.CommonProxy;
import com.wuest.prefab.Triple;
import com.wuest.prefab.Tuple;
import java.util.ArrayList;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class BuildingMethods {
    public static ArrayList<ItemStack> ConsolidateDrops(ServerWorld world, BlockPos pos, BlockState state, ArrayList<ItemStack> originalStacks, ArrayList<Item> itemsToNotAdd) {
        for (ItemStack stack : Block.func_220070_a((BlockState)state, (ServerWorld)world, (BlockPos)pos, null)) {
            if (itemsToNotAdd != null && itemsToNotAdd.contains(stack.func_77973_b())) continue;
            boolean foundStack = false;
            for (ItemStack existingStack : originalStacks) {
                if (!ItemStack.func_179545_c((ItemStack)existingStack, (ItemStack)stack) || existingStack.func_190916_E() + stack.func_190916_E() > stack.func_77976_d()) continue;
                existingStack.func_190920_e(existingStack.func_190916_E() + stack.func_190916_E());
                foundStack = true;
                break;
            }
            if (foundStack) continue;
            originalStacks.add(stack);
        }
        return originalStacks;
    }

    public static ArrayList<ItemStack> CreateWall(ServerWorld world, int height, int length, Direction direction, BlockPos startingPosition, Block replacementBlock, ArrayList<Item> itemsToNotAdd) {
        ArrayList<ItemStack> itemsDropped = new ArrayList<ItemStack>();
        BlockPos wallPos = null;
        for (int i = 0; i < height; ++i) {
            wallPos = startingPosition.func_177981_b(i);
            for (int j = 0; j < length; ++j) {
                BlockState currentBlockPosState = world.func_180495_p(wallPos);
                for (ItemStack stack : Block.func_220070_a((BlockState)currentBlockPosState, (ServerWorld)world, (BlockPos)wallPos, null)) {
                    if (itemsToNotAdd != null && itemsToNotAdd.contains(stack.func_77973_b())) continue;
                    itemsDropped.add(stack);
                }
                BuildingMethods.ReplaceBlock((World)world, wallPos, replacementBlock);
                wallPos = wallPos.func_177972_a(direction);
            }
        }
        return itemsDropped;
    }

    public static ArrayList<ItemStack> SetFloor(ServerWorld world, BlockPos pos, Block block, int width, int depth, ArrayList<ItemStack> originalStack, Direction facing, ArrayList<Item> itemsToNotAdd) {
        for (int i = 0; i < width; ++i) {
            originalStack.addAll(BuildingMethods.CreateWall(world, 1, depth, facing, pos, block, itemsToNotAdd));
            pos = pos.func_177972_a(facing.func_176746_e());
        }
        return originalStack;
    }

    public static void ReplaceBlock(World world, BlockPos pos, Block replacementBlock) {
        BuildingMethods.ReplaceBlock(world, pos, replacementBlock.func_176223_P(), 3);
    }

    public static void ReplaceBlockNoAir(World world, BlockPos pos, Block replacementBlock) {
        BuildingMethods.ReplaceBlockNoAir(world, pos, replacementBlock.func_176223_P(), 3);
    }

    public static void ReplaceBlock(World world, BlockPos pos, BlockState replacementBlockState) {
        BuildingMethods.ReplaceBlock(world, pos, replacementBlockState, 3);
    }

    public static void ReplaceBlock(World world, BlockPos pos, BlockState replacementBlockState, int flags) {
        world.func_217377_a(pos, false);
        world.func_180501_a(pos, replacementBlockState, flags);
    }

    public static void ReplaceBlockNoAir(World world, BlockPos pos, BlockState replacementBlockState, int flags) {
        world.func_180501_a(pos, replacementBlockState, flags);
    }

    public static Triple<Boolean, BlockState, BlockPos> CheckBuildSpaceForAllowedBlockReplacement(ServerWorld world, BlockPos startBlockPos, BlockPos endBlockPos, PlayerEntity player) {
        if (!world.field_72995_K) {
            for (BlockPos currentPos : BlockPos.func_218278_a((BlockPos)startBlockPos, (BlockPos)endBlockPos)) {
                BlockEvent.BreakEvent breakEvent;
                BlockState blockState = world.func_180495_p(currentPos);
                if (world.func_73046_m().func_175579_a(world, currentPos, player)) {
                    return new Triple<Boolean, BlockState, BlockPos>(false, blockState, currentPos);
                }
                if (!blockState.func_177230_c().isAir(blockState, (IBlockReader)world, currentPos) && MinecraftForge.EVENT_BUS.post((Event)(breakEvent = new BlockEvent.BreakEvent((World)world, currentPos, world.func_180495_p(currentPos), player)))) {
                    return new Triple<Boolean, BlockState, BlockPos>(false, blockState, currentPos);
                }
                BlockEvent.EntityPlaceEvent placeEvent = new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)currentPos), Blocks.field_150350_a.func_176223_P(), (Entity)player);
                if (MinecraftForge.EVENT_BUS.post((Event)placeEvent)) {
                    return new Triple<Boolean, BlockState, BlockPos>(false, blockState, currentPos);
                }
                if (!(blockState.func_185887_b((IBlockReader)world, currentPos) < 0.0f)) continue;
                return new Triple<Boolean, BlockState, BlockPos>(false, blockState, currentPos);
            }
        }
        return new Triple<Boolean, Object, Object>(true, null, null);
    }

    public static void PlaceColoredBed(World world, BlockPos bedHeadPos, BlockPos bedFootPos, DyeColor bedColor) {
        BlockState bedHead = null;
        BlockState bedFoot = null;
        switch (bedColor) {
            case BLACK: {
                bedHead = (BlockState)Blocks.field_196551_aB.func_176223_P().func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.field_196551_aB.func_176223_P();
                break;
            }
            case BLUE: {
                bedHead = (BlockState)Blocks.field_196599_ax.func_176223_P().func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.field_196599_ax.func_176223_P();
                break;
            }
            case BROWN: {
                bedHead = (BlockState)Blocks.field_196600_ay.func_176223_P().func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.field_196600_ay.func_176223_P();
                break;
            }
            case CYAN: {
                bedHead = (BlockState)Blocks.field_196597_av.func_176223_P().func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.field_196597_av.func_176223_P();
                break;
            }
            case GRAY: {
                bedHead = (BlockState)Blocks.field_196595_at.func_176223_P().func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.field_196595_at.func_176223_P();
                break;
            }
            case GREEN: {
                bedHead = (BlockState)Blocks.field_196601_az.func_176223_P().func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.field_196601_az.func_176223_P();
                break;
            }
            case LIGHT_BLUE: {
                bedHead = (BlockState)Blocks.field_196590_ap.func_176223_P().func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.field_196590_ap.func_176223_P();
                break;
            }
            case LIGHT_GRAY: {
                bedHead = (BlockState)Blocks.field_196596_au.func_176223_P().func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.field_196596_au.func_176223_P();
                break;
            }
            case LIME: {
                bedHead = (BlockState)Blocks.field_196593_ar.func_176223_P().func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.field_196593_ar.func_176223_P();
                break;
            }
            case MAGENTA: {
                bedHead = (BlockState)Blocks.field_196589_ao.func_176223_P().func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.field_196589_ao.func_176223_P();
                break;
            }
            case ORANGE: {
                bedHead = (BlockState)Blocks.field_196588_an.func_176223_P().func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.field_196588_an.func_176223_P();
                break;
            }
            case PINK: {
                bedHead = (BlockState)Blocks.field_196594_as.func_176223_P().func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.field_196594_as.func_176223_P();
                break;
            }
            case PURPLE: {
                bedHead = (BlockState)Blocks.field_196598_aw.func_176223_P().func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.field_196598_aw.func_176223_P();
                break;
            }
            case RED: {
                bedHead = (BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.field_196550_aA.func_176223_P();
                break;
            }
            case WHITE: {
                bedHead = (BlockState)Blocks.field_196587_am.func_176223_P().func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.field_196587_am.func_176223_P();
                break;
            }
            case YELLOW: {
                bedHead = (BlockState)Blocks.field_196592_aq.func_176223_P().func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.field_196592_aq.func_176223_P();
            }
        }
        Direction direction = Direction.NORTH;
        BlockPos tempPos = bedHeadPos.func_177972_a(Direction.NORTH);
        while (tempPos.func_177958_n() != bedFootPos.func_177958_n() || tempPos.func_177952_p() != bedFootPos.func_177952_p()) {
            direction = direction.func_176746_e();
            tempPos = bedHeadPos.func_177972_a(direction);
        }
        bedHead = (BlockState)bedHead.func_206870_a((Property)BedBlock.field_185512_D, (Comparable)direction.func_176734_d());
        bedFoot = (BlockState)bedFoot.func_206870_a((Property)BedBlock.field_185512_D, (Comparable)direction.func_176734_d());
        BuildingMethods.ReplaceBlock(world, bedHeadPos, bedHead);
        BuildingMethods.ReplaceBlock(world, bedFootPos, bedFoot);
    }

    public static void FillChest(World world, BlockPos itemPosition) {
        TileEntity tileEntity = world.func_175625_s(itemPosition);
        if (tileEntity instanceof LockableLootTileEntity) {
            LockableLootTileEntity chestTile = (LockableLootTileEntity)tileEntity;
            int itemSlot = 0;
            if (CommonProxy.proxyConfiguration.serverConfiguration.addAxe) {
                chestTile.func_70299_a(itemSlot++, new ItemStack((IItemProvider)Items.field_151049_t));
            }
            if (CommonProxy.proxyConfiguration.serverConfiguration.addHoe) {
                chestTile.func_70299_a(itemSlot++, new ItemStack((IItemProvider)Items.field_151018_J));
            }
            if (CommonProxy.proxyConfiguration.serverConfiguration.addPickAxe) {
                chestTile.func_70299_a(itemSlot++, new ItemStack((IItemProvider)Items.field_151050_s));
            }
            if (CommonProxy.proxyConfiguration.serverConfiguration.addShovel) {
                chestTile.func_70299_a(itemSlot++, new ItemStack((IItemProvider)Items.field_151051_r));
            }
            if (CommonProxy.proxyConfiguration.serverConfiguration.addSword) {
                ResourceLocation name;
                Item sword = Items.field_151052_q;
                if (ModList.get().isLoaded("repurpose") && ForgeRegistries.ITEMS.containsKey(name = new ResourceLocation("repurpose", "item_swift_blade_stone"))) {
                    sword = (Item)ForgeRegistries.ITEMS.getValue(name);
                }
                chestTile.func_70299_a(itemSlot++, new ItemStack((IItemProvider)sword));
            }
            if (CommonProxy.proxyConfiguration.serverConfiguration.addArmor) {
                chestTile.func_70299_a(itemSlot++, new ItemStack((IItemProvider)Items.field_151021_T));
                chestTile.func_70299_a(itemSlot++, new ItemStack((IItemProvider)Items.field_151027_R));
                chestTile.func_70299_a(itemSlot++, new ItemStack((IItemProvider)Items.field_151024_Q));
                chestTile.func_70299_a(itemSlot++, new ItemStack((IItemProvider)Items.field_151026_S));
            }
            if (CommonProxy.proxyConfiguration.serverConfiguration.addFood) {
                chestTile.func_70299_a(itemSlot++, new ItemStack((IItemProvider)Items.field_151025_P, 20));
            }
            if (CommonProxy.proxyConfiguration.serverConfiguration.addCrops) {
                chestTile.func_70299_a(itemSlot++, new ItemStack((IItemProvider)Items.field_151174_bG, 3));
                chestTile.func_70299_a(itemSlot++, new ItemStack((IItemProvider)Items.field_151172_bF, 3));
                chestTile.func_70299_a(itemSlot++, new ItemStack((IItemProvider)Items.field_151014_N, 3));
            }
            if (CommonProxy.proxyConfiguration.serverConfiguration.addCobble) {
                chestTile.func_70299_a(itemSlot++, new ItemStack((IItemProvider)Item.func_150898_a((Block)Blocks.field_150347_e), 64));
            }
            if (CommonProxy.proxyConfiguration.serverConfiguration.addDirt) {
                chestTile.func_70299_a(itemSlot++, new ItemStack((IItemProvider)Item.func_150898_a((Block)Blocks.field_150346_d), 64));
            }
            if (CommonProxy.proxyConfiguration.serverConfiguration.addSaplings) {
                chestTile.func_70299_a(itemSlot++, new ItemStack((IItemProvider)Item.func_150898_a((Block)Blocks.field_196674_t), 3));
            }
            if (CommonProxy.proxyConfiguration.serverConfiguration.addTorches) {
                chestTile.func_70299_a(itemSlot++, new ItemStack((IItemProvider)Item.func_150898_a((Block)Blocks.field_150478_aa), 20));
            }
        }
    }

    public static void FillFurnaces(World world, ArrayList<BlockPos> furnacePositions) {
        if (furnacePositions != null && furnacePositions.size() > 0) {
            for (BlockPos furnacePos : furnacePositions) {
                TileEntity tileEntity = world.func_175625_s(furnacePos);
                if (!(tileEntity instanceof FurnaceTileEntity)) continue;
                FurnaceTileEntity furnaceTile = (FurnaceTileEntity)tileEntity;
                furnaceTile.func_70299_a(1, new ItemStack((IItemProvider)Items.field_151044_h, 20));
            }
        }
    }

    public static void PlaceMineShaft(ServerWorld world, BlockPos pos, Direction facing, boolean onlyGatherOres) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ArrayList<Item> blocksToNotAdd = new ArrayList<Item>();
        if (onlyGatherOres) {
            blocksToNotAdd.add(Item.func_150898_a((Block)Blocks.field_150354_m));
            blocksToNotAdd.add(Item.func_150898_a((Block)Blocks.field_150322_A));
            blocksToNotAdd.add(Item.func_150898_a((Block)Blocks.field_150347_e));
            blocksToNotAdd.add(Item.func_150898_a((Block)Blocks.field_150348_b));
            blocksToNotAdd.add(Item.func_150898_a((Block)Blocks.field_150346_d));
            blocksToNotAdd.add(Item.func_150898_a((Block)Blocks.field_196650_c));
            blocksToNotAdd.add(Item.func_150898_a((Block)Blocks.field_196656_g));
            blocksToNotAdd.add(Item.func_150898_a((Block)Blocks.field_196654_e));
            blocksToNotAdd.add(Item.func_150898_a((Block)Blocks.field_196611_F));
            blocksToNotAdd.add(Item.func_150898_a((Block)Blocks.field_180395_cM));
            blocksToNotAdd.add(Item.func_150898_a((Block)Blocks.field_150341_Y));
            blocksToNotAdd.add(Item.func_150898_a((Block)Blocks.field_196698_dj));
        }
        Tuple<ArrayList<ItemStack>, ArrayList<BlockPos>> ladderShaftResults = BuildingMethods.CreateLadderShaft(world, pos, stacks, facing, blocksToNotAdd);
        stacks = ladderShaftResults.getFirst();
        ArrayList<BlockPos> torchPositions = ladderShaftResults.getSecond();
        pos = pos.func_177979_c(pos.func_177956_o() - 10);
        ArrayList<ItemStack> tempStacks = new ArrayList<ItemStack>();
        BlockPos ceilingLevel = pos.func_177981_b(4);
        tempStacks = BuildingMethods.SetFloor(world, ceilingLevel.func_177967_a(facing, 2).func_177967_a(facing.func_176746_e(), 2).func_177972_a(facing.func_176734_d()), Blocks.field_150348_b, 4, 4, tempStacks, facing.func_176734_d(), blocksToNotAdd);
        BuildingMethods.ReplaceBlock((World)world, ceilingLevel, (BlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a((Property)LadderBlock.field_176382_a, (Comparable)facing));
        BlockState torchState = Blocks.field_150478_aa.func_176223_P();
        for (BlockPos torchPos : torchPositions) {
            BlockState surroundingState = world.func_180495_p(torchPos);
            Block surroundingBlock = surroundingState.func_177230_c();
            tempStacks = BuildingMethods.ConsolidateDrops(world, torchPos, surroundingState, tempStacks, blocksToNotAdd);
            BuildingMethods.ReplaceBlock((World)world, torchPos, torchState);
        }
        tempStacks.addAll(BuildingMethods.SetFloor(world, pos.func_177972_a(facing).func_177972_a(facing.func_176746_e()), Blocks.field_150348_b, 3, 4, tempStacks, facing.func_176734_d(), blocksToNotAdd));
        for (int i = 0; i < tempStacks.size(); ++i) {
            ItemStack stack = tempStacks.get(i);
            if (stack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150468_ap)) continue;
            tempStacks.remove(i);
            --i;
        }
        pos = pos.func_177984_a();
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 3, facing.func_176746_e(), pos.func_177967_a(facing.func_176734_d(), 2).func_177972_a(facing.func_176735_f()), Blocks.field_150350_a, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 3, facing.func_176746_e(), pos.func_177967_a(facing.func_176734_d(), 3).func_177972_a(facing.func_176735_f()), Blocks.field_150348_b, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 4, facing, pos.func_177967_a(facing.func_176734_d(), 2).func_177972_a(facing.func_176746_e()), Blocks.field_150350_a, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 4, facing, pos.func_177967_a(facing.func_176734_d(), 2).func_177967_a(facing.func_176746_e(), 2), Blocks.field_150348_b, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 3, facing.func_176735_f(), pos.func_177972_a(facing).func_177972_a(facing.func_176746_e()), Blocks.field_150350_a, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 3, facing.func_176735_f(), pos.func_177967_a(facing, 2).func_177972_a(facing.func_176746_e()), Blocks.field_150348_b, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 4, facing.func_176734_d(), pos.func_177972_a(facing).func_177972_a(facing.func_176735_f()), Blocks.field_150350_a, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 4, facing.func_176734_d(), pos.func_177967_a(facing, 1).func_177967_a(facing.func_176735_f(), 2), Blocks.field_150348_b, blocksToNotAdd));
        for (ItemStack tempStack : tempStacks) {
            boolean foundStack = false;
            for (ItemStack existingStack : stacks) {
                if (!ItemStack.func_179545_c((ItemStack)existingStack, (ItemStack)tempStack) || existingStack.func_190916_E() + tempStack.func_190916_E() > tempStack.func_77976_d()) continue;
                existingStack.func_190920_e(existingStack.func_190916_E() + tempStack.func_190916_E());
                foundStack = true;
                break;
            }
            if (foundStack) continue;
            stacks.add(tempStack);
        }
        BlockState blockState = Blocks.field_150478_aa.func_176223_P();
        BuildingMethods.ReplaceBlock((World)world, pos.func_177972_a(facing.func_176735_f()), blockState);
        if (CommonProxy.proxyConfiguration.serverConfiguration.includeMineshaftChest) {
            BlockState chestState = (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)facing);
            BuildingMethods.ReplaceBlock((World)world, pos.func_177972_a(facing.func_176746_e()), chestState);
            if (stacks.size() > 27) {
                BuildingMethods.ReplaceBlock((World)world, pos.func_177972_a(facing.func_176746_e()).func_177972_a(facing.func_176734_d()), chestState);
            }
            TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(facing.func_176746_e()));
            TileEntity tileEntity2 = world.func_175625_s(pos.func_177972_a(facing.func_176746_e()).func_177972_a(facing.func_176734_d()));
            if (tileEntity instanceof ChestTileEntity) {
                ChestTileEntity chestTile = (ChestTileEntity)tileEntity;
                ChestTileEntity chestTile2 = (ChestTileEntity)tileEntity2;
                int i = 0;
                boolean fillSecond = false;
                for (ItemStack stack : stacks) {
                    if (i == 27 && !fillSecond) {
                        fillSecond = true;
                        i = 0;
                        chestTile = chestTile2;
                    }
                    if (i >= 27 && fillSecond) break;
                    chestTile.func_70299_a(i, stack);
                    ++i;
                }
            }
        }
    }

    private static Tuple<ArrayList<ItemStack>, ArrayList<BlockPos>> CreateLadderShaft(ServerWorld world, BlockPos pos, ArrayList<ItemStack> originalStacks, Direction houseFacing, ArrayList<Item> blocksToNotAdd) {
        int torchCounter = 0;
        Direction westWall = houseFacing.func_176735_f();
        BlockState ladderState = (BlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a((Property)LadderBlock.field_176382_a, (Comparable)houseFacing);
        BuildingMethods.ReplaceBlock((World)world, pos, Blocks.field_150350_a);
        ArrayList<BlockPos> torchPositions = new ArrayList<BlockPos>();
        while (pos.func_177956_o() > 8) {
            BlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            ++torchCounter;
            for (int i = 0; i < 4; ++i) {
                Direction facing = houseFacing;
                switch (i) {
                    case 1: {
                        facing = houseFacing.func_176746_e();
                        break;
                    }
                    case 2: {
                        facing = houseFacing.func_176734_d();
                        break;
                    }
                    case 3: {
                        facing = houseFacing.func_176735_f();
                        break;
                    }
                    default: {
                        facing = houseFacing;
                    }
                }
                if (facing == westWall && torchCounter == 6 && pos.func_177956_o() > 14) {
                    for (int j = 0; j <= 2; ++j) {
                        BlockPos tempPos = null;
                        BlockState surroundingState = null;
                        Block surroundingBlock = null;
                        if (j == 0) {
                            tempPos = pos.func_177967_a(facing, 2);
                            surroundingState = world.func_180495_p(tempPos);
                            surroundingBlock = surroundingState.func_177230_c();
                        } else if (j == 1) {
                            tempPos = pos.func_177972_a(facing).func_177972_a(facing.func_176746_e());
                            surroundingState = world.func_180495_p(tempPos);
                            surroundingBlock = surroundingState.func_177230_c();
                        } else {
                            tempPos = pos.func_177972_a(facing).func_177972_a(facing.func_176735_f());
                            surroundingState = world.func_180495_p(tempPos);
                            surroundingBlock = surroundingState.func_177230_c();
                        }
                        if (surroundingBlock == Blocks.field_150348_b || surroundingBlock == Blocks.field_196656_g || surroundingBlock == Blocks.field_196654_e || surroundingBlock == Blocks.field_196650_c) continue;
                        originalStacks = BuildingMethods.ConsolidateDrops(world, tempPos, surroundingState, originalStacks, blocksToNotAdd);
                        BuildingMethods.ReplaceBlock((World)world, tempPos, Blocks.field_150348_b);
                    }
                    torchPositions.add(pos.func_177972_a(facing));
                    torchCounter = 0;
                    continue;
                }
                BlockPos tempPos = pos.func_177972_a(facing);
                BlockState surroundingState = world.func_180495_p(tempPos);
                Block surroundingBlock = surroundingState.func_177230_c();
                if (surroundingState.func_215686_e((IBlockReader)world, tempPos) && !(surroundingBlock instanceof FlowingFluidBlock)) continue;
                originalStacks = BuildingMethods.ConsolidateDrops(world, tempPos, surroundingState, originalStacks, blocksToNotAdd);
                BuildingMethods.ReplaceBlock((World)world, tempPos, Blocks.field_150348_b);
            }
            originalStacks = BuildingMethods.ConsolidateDrops(world, pos, state, originalStacks, blocksToNotAdd);
            if (pos.func_177956_o() >= 10) {
                BuildingMethods.ReplaceBlock((World)world, pos, ladderState);
            }
            pos = pos.func_177977_b();
        }
        return new Tuple<ArrayList<ItemStack>, ArrayList<BlockPos>>(originalStacks, torchPositions);
    }
}

