/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Base;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Structures.Base.BuildBlock;
import com.wuest.prefab.Structures.Base.BuildClear;
import com.wuest.prefab.Structures.Base.BuildEntity;
import com.wuest.prefab.Structures.Base.BuildProperty;
import com.wuest.prefab.Structures.Base.BuildTileEntity;
import com.wuest.prefab.Structures.Base.BuildingMethods;
import com.wuest.prefab.Structures.Base.PositionOffset;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import com.wuest.prefab.Structures.Events.StructureEventHandler;
import com.wuest.prefab.Triple;
import com.wuest.prefab.ZipUtil;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.AbstractBannerBlock;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.AbstractPressurePlateBlock;
import net.minecraft.block.AbstractSignBlock;
import net.minecraft.block.AirBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.LeverBlock;
import net.minecraft.block.MushroomBlock;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Structure {
    public ArrayList<BlockPos> allBlockPositions = new ArrayList();
    public ArrayList<BlockPos> clearedBlockPos = new ArrayList();
    public ArrayList<BuildBlock> priorityOneBlocks = new ArrayList();
    public ArrayList<BuildBlock> priorityTwoBlocks = new ArrayList();
    public ArrayList<BuildBlock> priorityThreeBlocks = new ArrayList();
    public ArrayList<BuildBlock> airBlocks = new ArrayList();
    public StructureConfiguration configuration;
    public ServerWorld world;
    public BlockPos originalPos;
    public Direction assumedNorth;
    public boolean hasAirBlocks = false;
    public boolean entitiesRemoved = false;
    @Expose
    public ArrayList<BuildTileEntity> tileEntities = new ArrayList();
    @Expose
    public ArrayList<BuildEntity> entities = new ArrayList();
    @Expose
    private String name;
    @Expose
    private BuildClear clearSpace;
    @Expose
    private ArrayList<BuildBlock> blocks;

    public Structure() {
        this.Initialize();
    }

    public static <T extends Structure> T CreateInstance(String resourceLocation, Class<? extends Structure> child) {
        Structure structure = null;
        Gson file = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        structure = (Structure)file.fromJson(ZipUtil.decompressResource(resourceLocation), child);
        return (T)structure;
    }

    public static void CreateStructureFile(Structure structure, String fileLocation) {
        try {
            Gson converter = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
            StringWriter stringWriter = new StringWriter();
            converter.toJson((Object)structure, (Appendable)stringWriter);
            ZipUtil.zipStringToFile(stringWriter.toString(), fileLocation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void ScanStructure(World world, BlockPos originalPos, BlockPos cornerPos1, BlockPos cornerPos2, String fileLocation, BuildClear clearedSpace, Direction playerFacing, boolean includeAir, boolean excludeWater) {
        Structure scannedStructure = new Structure();
        scannedStructure.setClearSpace(clearedSpace);
        for (BlockPos currentPos : BlockPos.func_218278_a((BlockPos)cornerPos1, (BlockPos)cornerPos2)) {
            if (world.func_175623_d(currentPos) && !includeAir) continue;
            BlockState currentState = world.func_180495_p(currentPos);
            Block currentBlock = currentState.func_177230_c();
            if (currentState.func_185904_a() == Material.field_151586_h && excludeWater) continue;
            BuildBlock buildBlock = Structure.createBuildBlockFromBlockState(currentState, currentBlock, currentPos, originalPos);
            if (currentBlock instanceof DoorBlock) {
                DoubleBlockHalf blockHalf = (DoubleBlockHalf)currentState.func_177229_b((Property)DoorBlock.field_176523_O);
                if (blockHalf != DoubleBlockHalf.LOWER) continue;
                BlockState upperHalfState = world.func_180495_p(currentPos.func_177984_a());
                if (upperHalfState.func_177230_c() instanceof DoorBlock) {
                    Block upperBlock = upperHalfState.func_177230_c();
                    BuildBlock upperHalf = Structure.createBuildBlockFromBlockState(upperHalfState, upperBlock, currentPos.func_177984_a(), originalPos);
                    buildBlock.setSubBlock(upperHalf);
                }
            } else if (currentBlock instanceof BedBlock) {
                BedPart bedPart = (BedPart)currentState.func_177229_b((Property)BedBlock.field_176472_a);
                if (bedPart != BedPart.HEAD) continue;
                BlockState bedFoot = null;
                boolean foundFoot = false;
                Direction facing = Direction.NORTH;
                while (!foundFoot) {
                    bedFoot = world.func_180495_p(currentPos.func_177972_a(facing));
                    if (bedFoot.func_177230_c() instanceof BedBlock && bedFoot.func_177229_b((Property)BedBlock.field_176472_a) == BedPart.FOOT) {
                        foundFoot = true;
                        break;
                    }
                    if ((facing = facing.func_176746_e()) != Direction.NORTH) continue;
                }
                if (foundFoot) {
                    Block footBedBlock = bedFoot.func_177230_c();
                    BuildBlock bed = Structure.createBuildBlockFromBlockState(bedFoot, footBedBlock, currentPos.func_177972_a(facing), originalPos);
                    buildBlock.setSubBlock(bed);
                }
            }
            scannedStructure.getBlocks().add(buildBlock);
            TileEntity tileEntity = world.func_175625_s(currentPos);
            if (tileEntity == null || tileEntity instanceof ChestTileEntity && ((ChestTileEntity)tileEntity).func_191420_l() || tileEntity instanceof FurnaceTileEntity && ((FurnaceTileEntity)tileEntity).func_191420_l()) continue;
            ResourceLocation resourceLocation = ForgeRegistries.TILE_ENTITIES.getKey((IForgeRegistryEntry)tileEntity.func_200662_C());
            CompoundNBT tagCompound = new CompoundNBT();
            tileEntity.func_189515_b(tagCompound);
            BuildTileEntity buildTileEntity = new BuildTileEntity();
            assert (resourceLocation != null);
            buildTileEntity.setEntityDomain(resourceLocation.func_110624_b());
            buildTileEntity.setEntityName(resourceLocation.func_110623_a());
            buildTileEntity.setStartingPosition(Structure.getStartingPositionFromOriginalAndCurrentPosition(currentPos, originalPos));
            buildTileEntity.setEntityNBTData(tagCompound);
            scannedStructure.tileEntities.add(buildTileEntity);
        }
        int x_radiusRangeBegin = Math.min(cornerPos1.func_177958_n(), cornerPos2.func_177958_n());
        int x_radiusRangeEnd = Math.max(cornerPos1.func_177958_n(), cornerPos2.func_177958_n());
        int y_radiusRangeBegin = Math.min(cornerPos1.func_177956_o(), cornerPos2.func_177956_o());
        int y_radiusRangeEnd = Math.max(cornerPos1.func_177956_o(), cornerPos2.func_177956_o());
        int z_radiusRangeBegin = Math.min(cornerPos1.func_177952_p(), cornerPos2.func_177952_p());
        int z_radiusRangeEnd = Math.max(cornerPos1.func_177952_p(), cornerPos2.func_177952_p());
        AxisAlignedBB axis = new AxisAlignedBB(cornerPos1, cornerPos2);
        for (Entity entity : world.func_72839_b(null, axis)) {
            BlockPos entityPos = entity.func_233580_cy_();
            if (entityPos.func_177958_n() < x_radiusRangeBegin || entityPos.func_177958_n() > x_radiusRangeEnd || entityPos.func_177952_p() < z_radiusRangeBegin || entityPos.func_177952_p() > z_radiusRangeEnd || entityPos.func_177956_o() < y_radiusRangeBegin || entityPos.func_177956_o() > y_radiusRangeEnd) continue;
            BuildEntity buildEntity = new BuildEntity();
            buildEntity.setEntityResourceString(ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)entity.func_200600_R()));
            buildEntity.setStartingPosition(Structure.getStartingPositionFromOriginalAndCurrentPosition(entityPos, originalPos));
            buildEntity.entityXAxisOffset = (double)entityPos.func_177958_n() - entity.func_226277_ct_();
            buildEntity.entityYAxisOffset = (double)entityPos.func_177956_o() - entity.func_226278_cu_();
            buildEntity.entityZAxisOffset = (double)entityPos.func_177952_p() - entity.func_226281_cx_();
            if (entity instanceof ItemFrameEntity) {
                buildEntity.entityYAxisOffset *= -1.0;
            }
            if (entity instanceof HangingEntity) {
                buildEntity.entityFacing = entity.func_174811_aO();
            }
            CompoundNBT entityTagCompound = new CompoundNBT();
            entity.func_184198_c(entityTagCompound);
            buildEntity.setEntityNBTData(entityTagCompound);
            scannedStructure.entities.add(buildEntity);
        }
        Structure.CreateStructureFile(scannedStructure, fileLocation);
    }

    public static BuildBlock createBuildBlockFromBlockState(BlockState currentState, Block currentBlock, BlockPos currentPos, BlockPos originalPos) {
        BuildBlock buildBlock = new BuildBlock();
        buildBlock.setBlockDomain(currentBlock.getRegistryName().func_110624_b());
        buildBlock.setBlockName(currentBlock.getRegistryName().func_110623_a());
        buildBlock.setStartingPosition(Structure.getStartingPositionFromOriginalAndCurrentPosition(currentPos, originalPos));
        buildBlock.blockPos = currentPos;
        Collection properties = currentState.func_235904_r_();
        for (Property entry : properties) {
            BuildProperty property = new BuildProperty();
            property.setName(entry.func_177701_a());
            Comparable value = currentState.func_177229_b(entry);
            if (currentBlock instanceof RotatedPillarBlock) {
                property.setValue(((Direction.Axis)value).func_176610_l());
            } else if (currentBlock instanceof CarpetBlock && property.getName().equals("color")) {
                DyeColor dyeColor = (DyeColor)value;
                property.setValue(dyeColor.func_176610_l());
            } else if (value instanceof IStringSerializable) {
                IStringSerializable stringSerializable = (IStringSerializable)value;
                property.setValue(stringSerializable.func_176610_l());
            } else {
                property.setValue(value.toString());
            }
            buildBlock.getProperties().add(property);
        }
        return buildBlock;
    }

    public static PositionOffset getStartingPositionFromOriginalAndCurrentPosition(BlockPos currentPos, BlockPos originalPos) {
        PositionOffset positionOffSet = new PositionOffset();
        if (currentPos.func_177958_n() > originalPos.func_177958_n()) {
            positionOffSet.setEastOffset(currentPos.func_177958_n() - originalPos.func_177958_n());
        } else {
            positionOffSet.setWestOffset(originalPos.func_177958_n() - currentPos.func_177958_n());
        }
        if (currentPos.func_177952_p() > originalPos.func_177952_p()) {
            positionOffSet.setSouthOffset(currentPos.func_177952_p() - originalPos.func_177952_p());
        } else {
            positionOffSet.setNorthOffset(originalPos.func_177952_p() - currentPos.func_177952_p());
        }
        positionOffSet.setHeightOffset(currentPos.func_177956_o() - originalPos.func_177956_o());
        return positionOffSet;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public BuildClear getClearSpace() {
        return this.clearSpace;
    }

    public void setClearSpace(BuildClear value) {
        this.clearSpace = value;
    }

    public ArrayList<BuildBlock> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(ArrayList<BuildBlock> value) {
        this.blocks = value;
    }

    public void Initialize() {
        this.name = "";
        this.clearSpace = new BuildClear();
        this.blocks = new ArrayList();
    }

    public boolean BuildStructure(StructureConfiguration configuration, ServerWorld world, BlockPos originalPos, Direction assumedNorth, PlayerEntity player) {
        BlockPos endBlockPos;
        BlockPos startBlockPos = this.clearSpace.getStartingPosition().getRelativePosition(originalPos, this.clearSpace.getShape().getDirection(), configuration.houseFacing);
        Triple<Boolean, BlockState, BlockPos> checkResult = BuildingMethods.CheckBuildSpaceForAllowedBlockReplacement(world, startBlockPos, endBlockPos = startBlockPos.func_177967_a(configuration.houseFacing.func_176735_f(), this.clearSpace.getShape().getWidth() - 1).func_177967_a(configuration.houseFacing.func_176734_d(), this.clearSpace.getShape().getWidth() - 1).func_177967_a(Direction.UP, this.clearSpace.getShape().getHeight()), player);
        if (!checkResult.getFirst().booleanValue()) {
            TranslationTextComponent message = new TranslationTextComponent("prefab.gui.structure.nobuild", new Object[]{checkResult.getSecond().func_177230_c().getRegistryName().toString(), checkResult.getThird().func_177958_n(), checkResult.getThird().func_177956_o(), checkResult.getThird().func_177952_p()});
            message.func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN));
            player.func_145747_a((ITextComponent)message, player.func_110124_au());
            return false;
        }
        if (!this.BeforeBuilding(configuration, (World)world, originalPos, assumedNorth, player)) {
            this.ClearSpace(configuration, (World)world, originalPos, assumedNorth);
            boolean blockPlacedWithCobbleStoneInstead = false;
            for (BuildBlock block : this.getBlocks()) {
                Block foundBlock = (Block)ForgeRegistries.BLOCKS.getValue(block.getResourceLocation());
                if (foundBlock != null) {
                    boolean priorityThreeBlock;
                    BlockState blockState = foundBlock.func_176223_P();
                    BuildBlock subBlock = null;
                    if (this.WaterReplacedWithCobbleStone(configuration, block, (World)world, originalPos, assumedNorth, foundBlock, blockState, player).booleanValue() || this.CustomBlockProcessingHandled(configuration, block, (World)world, originalPos, assumedNorth, foundBlock, blockState, player).booleanValue()) continue;
                    if ((block = BuildBlock.SetBlockState(configuration, (World)world, originalPos, assumedNorth, block, foundBlock, blockState, this)).getSubBlock() != null) {
                        foundBlock = (Block)ForgeRegistries.BLOCKS.getValue(block.getSubBlock().getResourceLocation());
                        blockState = foundBlock.func_176223_P();
                        subBlock = BuildBlock.SetBlockState(configuration, (World)world, originalPos, assumedNorth, block.getSubBlock(), foundBlock, blockState, this);
                    }
                    if (subBlock != null) {
                        block.setSubBlock(subBlock);
                    }
                    boolean bl = priorityThreeBlock = foundBlock instanceof TorchBlock || foundBlock instanceof AbstractSignBlock || foundBlock instanceof LeverBlock || foundBlock instanceof AbstractButtonBlock || foundBlock instanceof BedBlock || foundBlock instanceof CarpetBlock || foundBlock instanceof FlowerPotBlock || foundBlock instanceof SugarCaneBlock || foundBlock instanceof AbstractPressurePlateBlock || foundBlock instanceof DoorBlock || foundBlock instanceof LadderBlock || foundBlock instanceof VineBlock || foundBlock instanceof RedstoneWireBlock || foundBlock instanceof RedstoneDiodeBlock || foundBlock instanceof AbstractBannerBlock || foundBlock instanceof LanternBlock || foundBlock instanceof MushroomBlock;
                    if (!block.getHasFacing()) {
                        if (subBlock != null) {
                            block.setSubBlock(subBlock);
                        }
                        if (priorityThreeBlock) {
                            this.priorityThreeBlocks.add(block);
                            continue;
                        }
                        if (foundBlock instanceof AirBlock) {
                            this.airBlocks.add(block);
                            continue;
                        }
                        if (foundBlock instanceof ITileEntityProvider) {
                            this.priorityTwoBlocks.add(block);
                            continue;
                        }
                        this.priorityOneBlocks.add(block);
                        continue;
                    }
                    if (priorityThreeBlock) {
                        this.priorityThreeBlocks.add(block);
                        continue;
                    }
                    this.priorityTwoBlocks.add(block);
                    continue;
                }
                String blockTypeNotFound = block.getResourceLocation().toString();
                block = BuildBlock.SetBlockState(configuration, (World)world, originalPos, assumedNorth, block, Blocks.field_150347_e, Blocks.field_150347_e.func_176223_P(), this);
                this.priorityOneBlocks.add(block);
                if (blockPlacedWithCobbleStoneInstead) continue;
                blockPlacedWithCobbleStoneInstead = true;
                Prefab.LOGGER.warn("A Block was in the structure, but it is not registred. This block was replaced with vanilla cobblestone instead. Block type not found: [" + blockTypeNotFound + "]");
            }
            this.configuration = configuration;
            this.world = world;
            this.assumedNorth = assumedNorth;
            this.originalPos = originalPos;
            if (StructureEventHandler.structuresToBuild.containsKey(player)) {
                StructureEventHandler.structuresToBuild.get(player).add(this);
            } else {
                ArrayList<Structure> structures = new ArrayList<Structure>();
                structures.add(this);
                StructureEventHandler.structuresToBuild.put(player, structures);
            }
        }
        return true;
    }

    public void BeforeClearSpaceBlockReplaced(BlockPos pos) {
    }

    public void BeforeHangingEntityRemoved(HangingEntity hangingEntity) {
    }

    public BlockState getStainedGlassBlock(DyeColor color) {
        switch (color) {
            case BLACK: {
                return Blocks.field_196824_gy.func_176223_P();
            }
            case BLUE: {
                return Blocks.field_196820_gu.func_176223_P();
            }
            case BROWN: {
                return Blocks.field_196821_gv.func_176223_P();
            }
            case GRAY: {
                return Blocks.field_196815_gq.func_176223_P();
            }
            case GREEN: {
                return Blocks.field_196822_gw.func_176223_P();
            }
            case LIGHT_BLUE: {
                return Blocks.field_196810_gm.func_176223_P();
            }
            case LIGHT_GRAY: {
                return Blocks.field_196816_gr.func_176223_P();
            }
            case LIME: {
                return Blocks.field_196812_go.func_176223_P();
            }
            case MAGENTA: {
                return Blocks.field_196809_gl.func_176223_P();
            }
            case ORANGE: {
                return Blocks.field_196808_gk.func_176223_P();
            }
            case PINK: {
                return Blocks.field_196813_gp.func_176223_P();
            }
            case PURPLE: {
                return Blocks.field_196819_gt.func_176223_P();
            }
            case RED: {
                return Blocks.field_196823_gx.func_176223_P();
            }
            case WHITE: {
                return Blocks.field_196807_gj.func_176223_P();
            }
            case YELLOW: {
                return Blocks.field_196811_gn.func_176223_P();
            }
        }
        return Blocks.field_196818_gs.func_176223_P();
    }

    public BlockState getStainedGlassPaneBlock(DyeColor color) {
        switch (color) {
            case BLACK: {
                return Blocks.field_196776_gO.func_176223_P();
            }
            case BLUE: {
                return Blocks.field_196771_gK.func_176223_P();
            }
            case BROWN: {
                return Blocks.field_196773_gL.func_176223_P();
            }
            case GRAY: {
                return Blocks.field_196765_gG.func_176223_P();
            }
            case GREEN: {
                return Blocks.field_196774_gM.func_176223_P();
            }
            case LIGHT_BLUE: {
                return Blocks.field_196760_gC.func_176223_P();
            }
            case LIGHT_GRAY: {
                return Blocks.field_196767_gH.func_176223_P();
            }
            case LIME: {
                return Blocks.field_196763_gE.func_176223_P();
            }
            case MAGENTA: {
                return Blocks.field_196759_gB.func_176223_P();
            }
            case ORANGE: {
                return Blocks.field_196758_gA.func_176223_P();
            }
            case PINK: {
                return Blocks.field_196764_gF.func_176223_P();
            }
            case PURPLE: {
                return Blocks.field_196769_gJ.func_176223_P();
            }
            case RED: {
                return Blocks.field_196775_gN.func_176223_P();
            }
            case WHITE: {
                return Blocks.field_196825_gz.func_176223_P();
            }
            case YELLOW: {
                return Blocks.field_196761_gD.func_176223_P();
            }
        }
        return Blocks.field_196768_gI.func_176223_P();
    }

    protected boolean BeforeBuilding(StructureConfiguration configuration, World world, BlockPos originalPos, Direction assumedNorth, PlayerEntity player) {
        return false;
    }

    public void AfterBuilding(StructureConfiguration configuration, ServerWorld world, BlockPos originalPos, Direction assumedNorth, PlayerEntity player) {
    }

    protected void ClearSpace(StructureConfiguration configuration, World world, BlockPos originalPos, Direction assumedNorth) {
        if (this.clearSpace.getShape().getWidth() > 0 && this.clearSpace.getShape().getLength() > 0) {
            BlockPos startBlockPos = this.clearSpace.getStartingPosition().getRelativePosition(originalPos, this.clearSpace.getShape().getDirection(), configuration.houseFacing);
            BlockPos endBlockPos = startBlockPos.func_177967_a(configuration.houseFacing.func_176734_d().func_176746_e(), this.clearSpace.getShape().getWidth() - 1).func_177967_a(configuration.houseFacing.func_176734_d(), this.clearSpace.getShape().getLength() - 1).func_177967_a(Direction.UP, this.clearSpace.getShape().getHeight());
            this.clearedBlockPos = new ArrayList();
            for (BlockPos pos : BlockPos.func_218278_a((BlockPos)startBlockPos, (BlockPos)endBlockPos)) {
                if (!this.BlockShouldBeClearedDuringConstruction(configuration, world, originalPos, assumedNorth, pos).booleanValue()) continue;
                this.clearedBlockPos.add(new BlockPos((Vector3i)pos));
                this.allBlockPositions.add(new BlockPos((Vector3i)pos));
            }
        } else {
            this.clearedBlockPos = new ArrayList();
        }
    }

    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, World world, BlockPos originalPos, Direction assumedNorth, Block foundBlock, BlockState blockState, PlayerEntity player) {
        return false;
    }

    protected Boolean BlockShouldBeClearedDuringConstruction(StructureConfiguration configuration, World world, BlockPos originalPos, Direction assumedNorth, BlockPos blockPos) {
        return true;
    }

    protected Boolean WaterReplacedWithCobbleStone(StructureConfiguration configuration, BuildBlock block, World world, BlockPos originalPos, Direction assumedNorth, Block foundBlock, BlockState blockState, PlayerEntity player) {
        if (foundBlock instanceof FlowingFluidBlock && blockState.func_185904_a() == Material.field_151586_h && World.field_234918_g_.compareTo(world.func_234923_W_()) != 0) {
            block.setBlockDomain(Blocks.field_150347_e.getRegistryName().func_110624_b());
            block.setBlockName(Blocks.field_150347_e.getRegistryName().func_110623_a());
            block.setBlockState(Blocks.field_150347_e.func_176223_P());
            this.priorityThreeBlocks.add(block);
            return true;
        }
        return false;
    }
}

