/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Config.Enums;

import com.wuest.prefab.Structures.Base.BuildShape;
import com.wuest.prefab.Structures.Base.PositionOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public abstract class BaseOption {
    private String translationString;
    private String assetLocation;
    private ResourceLocation pictureLocation;
    private int imageWidth;
    private int imageHeight;
    private BuildShape clearShape;
    private PositionOffset clearPositionOffset;
    private static HashMap<String, ArrayList<BaseOption>> classOptions = new HashMap();

    protected BaseOption(String translationString, String assetLocation, String pictureLocation, int imageWidth, int imageHeight) {
        this.translationString = translationString;
        this.assetLocation = assetLocation;
        this.pictureLocation = new ResourceLocation("prefab", pictureLocation);
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.clearShape = new BuildShape();
        this.clearPositionOffset = new PositionOffset();
        BaseOption.addOption(this);
    }

    public String getTranslationString() {
        return this.translationString;
    }

    public String getAssetLocation() {
        return this.assetLocation;
    }

    public ResourceLocation getPictureLocation() {
        return this.pictureLocation;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public BuildShape getClearShape() {
        return this.clearShape;
    }

    public PositionOffset getClearPositionOffset() {
        return this.clearPositionOffset;
    }

    public ArrayList<BaseOption> getSpecificOptions() {
        String className = this.getClass().getName();
        for (Map.Entry<String, ArrayList<BaseOption>> mapping : classOptions.entrySet()) {
            if (!mapping.getKey().equals(className)) continue;
            return mapping.getValue();
        }
        return null;
    }

    public BaseOption getFirstOption() {
        ArrayList<BaseOption> availableOptions = this.getSpecificOptions();
        if (availableOptions.size() > 0) {
            return availableOptions.get(0);
        }
        return null;
    }

    public static BaseOption getOptionByTranslationString(String translationString) {
        for (Map.Entry<String, ArrayList<BaseOption>> mapping : classOptions.entrySet()) {
            for (BaseOption storedOption : mapping.getValue()) {
                if (!storedOption.getTranslationString().equals(translationString)) continue;
                return storedOption;
            }
        }
        return null;
    }

    public static void addOption(BaseOption option) {
        String className = option.getClass().getName();
        ArrayList<Object> options = null;
        if (!classOptions.containsKey(className)) {
            options = new ArrayList();
            classOptions.put(className, options);
        } else {
            options = classOptions.get(className);
        }
        options.add(option);
    }
}

