/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.wuest.prefab.Proxy.CommonProxy;
import com.wuest.prefab.Structures.Base.BuildBlock;
import com.wuest.prefab.Structures.Base.Structure;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import com.wuest.prefab.Structures.Render.ShaderHelper;
import com.wuest.prefab.Tuple;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;

public class StructureRenderHandler {
    public static StructureConfiguration currentConfiguration;
    public static Structure currentStructure;
    public static Direction assumedNorth;
    public static boolean rendering;
    public static boolean showedMessage;
    private static int dimension;
    private static int overlay;

    public static void setStructure(Structure structure, Direction assumedNorth, StructureConfiguration configuration) {
        currentStructure = structure;
        StructureRenderHandler.assumedNorth = assumedNorth;
        currentConfiguration = configuration;
        showedMessage = false;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            dimension = mc.field_71441_e.func_230315_m_().func_241513_m_();
        }
    }

    public static void renderPlayerLook(PlayerEntity player, RayTraceResult src, MatrixStack matrixStack) {
        if (currentStructure != null && dimension == player.field_70170_p.func_230315_m_().func_241513_m_() && currentConfiguration != null && CommonProxy.proxyConfiguration.serverConfiguration.enableStructurePreview) {
            TranslationTextComponent message;
            rendering = true;
            boolean didAny = false;
            IRenderTypeBuffer.Impl entityVertexConsumer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            ArrayList<Tuple<BlockState, BlockPos>> entityModels = new ArrayList<Tuple<BlockState, BlockPos>>();
            for (BuildBlock buildBlock : currentStructure.getBlocks()) {
                Block foundBlock = (Block)Registry.field_212618_g.func_82594_a(buildBlock.getResourceLocation());
                if (foundBlock == null) continue;
                BlockState blockState = foundBlock.func_176223_P();
                BuildBlock buildBlock2 = BuildBlock.SetBlockState(currentConfiguration, player.field_70170_p, StructureRenderHandler.currentConfiguration.pos, assumedNorth, buildBlock, foundBlock, blockState, currentStructure);
                BlockPos pos = buildBlock2.getStartingPosition().getRelativePosition(StructureRenderHandler.currentConfiguration.pos, currentStructure.getClearSpace().getShape().getDirection(), StructureRenderHandler.currentConfiguration.houseFacing);
                BlockRenderType blockRenderType = blockState.func_185901_i();
                if (blockRenderType == BlockRenderType.ENTITYBLOCK_ANIMATED) {
                    if (!ShaderHelper.hasIncompatibleMods) continue;
                    entityModels.add(new Tuple<BlockState, BlockPos>(buildBlock2.getBlockState(), pos));
                    continue;
                }
                if (!StructureRenderHandler.renderComponentInWorld(player.field_70170_p, buildBlock2, (IRenderTypeBuffer)entityVertexConsumer, matrixStack, pos, blockRenderType)) continue;
                didAny = true;
            }
            ShaderHelper.useShader(ShaderHelper.alphaShader, shader -> {
                int alpha = GlStateManager.func_227680_b_((int)shader, (CharSequence)"alpha");
                ShaderHelper.FLOAT_BUF.position(0);
                ShaderHelper.FLOAT_BUF.put(0, 0.4f);
                GlStateManager.func_227681_b_((int)alpha, (FloatBuffer)ShaderHelper.FLOAT_BUF);
            });
            entityVertexConsumer.func_228462_a_(Atlases.func_239280_i_());
            ShaderHelper.releaseShader();
            for (Tuple tuple : entityModels) {
                BlockPos blockPos = (BlockPos)tuple.getSecond();
                StructureRenderHandler.renderBlock(matrixStack, new Vector3d((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()), (BlockState)tuple.getFirst(), (IRenderTypeBuffer)entityVertexConsumer, BlockRenderType.ENTITYBLOCK_ANIMATED);
            }
            if (!didAny) {
                StructureRenderHandler.setStructure(null, Direction.NORTH, null);
                message = new TranslationTextComponent("prefab.gui.preview.complete");
                message.func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN));
                player.func_145747_a((ITextComponent)message, player.func_110124_au());
            } else if (!showedMessage) {
                message = new TranslationTextComponent("prefab.gui.preview.notice");
                message.func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN));
                player.func_145747_a((ITextComponent)message, player.func_110124_au());
                showedMessage = true;
            }
        }
    }

    private static boolean renderComponentInWorld(World world, BuildBlock buildBlock, IRenderTypeBuffer entityVertexConsumer, MatrixStack matrixStack, BlockPos pos, BlockRenderType blockRenderType) {
        BlockState targetBlock = world.func_180495_p(pos);
        if (targetBlock.func_185904_a() != Material.field_151579_a && targetBlock.func_185904_a() != Material.field_151586_h) {
            return false;
        }
        StructureRenderHandler.doRenderComponent(buildBlock, pos, entityVertexConsumer, matrixStack, blockRenderType);
        if (buildBlock.getSubBlock() != null) {
            Block foundBlock = (Block)Registry.field_212618_g.func_82594_a(buildBlock.getSubBlock().getResourceLocation());
            BlockState blockState = foundBlock.func_176223_P();
            BuildBlock subBlock = BuildBlock.SetBlockState(currentConfiguration, world, StructureRenderHandler.currentConfiguration.pos, assumedNorth, buildBlock.getSubBlock(), foundBlock, blockState, currentStructure);
            BlockPos subBlockPos = subBlock.getStartingPosition().getRelativePosition(StructureRenderHandler.currentConfiguration.pos, currentStructure.getClearSpace().getShape().getDirection(), StructureRenderHandler.currentConfiguration.houseFacing);
            BlockRenderType subBlockRenderType = subBlock.getBlockState().func_185901_i();
            return StructureRenderHandler.renderComponentInWorld(world, subBlock, entityVertexConsumer, matrixStack, subBlockPos, subBlockRenderType);
        }
        return true;
    }

    private static void doRenderComponent(BuildBlock buildBlock, BlockPos pos, IRenderTypeBuffer entityVertexConsumer, MatrixStack matrixStack, BlockRenderType blockRenderType) {
        BlockState state = buildBlock.getBlockState();
        StructureRenderHandler.renderBlock(matrixStack, new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), state, entityVertexConsumer, blockRenderType);
    }

    private static void renderBlock(MatrixStack matrixStack, Vector3d pos, BlockState state, IRenderTypeBuffer entityVertexConsumer, BlockRenderType blockRenderType) {
        Minecraft minecraft = Minecraft.func_71410_x();
        Vector3d projectedView = minecraft.func_175598_ae().field_217783_c.func_216785_c();
        double renderPosX = projectedView.func_82615_a();
        double renderPosY = projectedView.func_82617_b();
        double renderPosZ = projectedView.func_82616_c();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-renderPosX, -renderPosY, -renderPosZ);
        BlockRendererDispatcher renderer = minecraft.func_175602_ab();
        matrixStack.func_227861_a_(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        IModelData model = renderer.func_184389_a(state).getModelData((IBlockDisplayReader)world, new BlockPos(pos), state, ModelDataManager.getModelData((World)world, (BlockPos)new BlockPos(pos)));
        IBakedModel bakedModel = renderer.func_184389_a(state);
        if (blockRenderType == BlockRenderType.MODEL) {
            int color = minecraft.func_184125_al().func_228054_a_(state, null, null, 0);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            renderer.func_175019_b().func_228804_a_(matrixStack.func_227866_c_(), entityVertexConsumer.getBuffer(Atlases.func_239280_i_()), state, bakedModel, r, g, b, 0xF000F0, OverlayTexture.field_229196_a_);
        } else if (blockRenderType == BlockRenderType.ENTITYBLOCK_ANIMATED) {
            renderer.renderBlock(state, matrixStack, entityVertexConsumer, 0xF000F0, overlay, model);
        }
        matrixStack.func_227865_b_();
    }

    private static void renderModel(MatrixStack matrixStack, Vector3d pos, BlockState state, IRenderTypeBuffer entityVertexConsumer) {
    }

    static {
        rendering = false;
        showedMessage = false;
        overlay = OverlayTexture.func_229201_a_((int)5, (int)10);
    }
}

