/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.reflect;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.optifine.Log;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorClass;
import net.optifine.reflect.ReflectorField;
import net.optifine.util.StrUtils;

public class ReflectorForge {
    public static Object EVENT_RESULT_ALLOW = Reflector.getFieldValue(Reflector.Event_Result_ALLOW);
    public static Object EVENT_RESULT_DENY = Reflector.getFieldValue(Reflector.Event_Result_DENY);
    public static Object EVENT_RESULT_DEFAULT = Reflector.getFieldValue(Reflector.Event_Result_DEFAULT);
    public static final boolean FORGE_BLOCKSTATE_HAS_TILE_ENTITY = Reflector.IForgeBlockState_hasTileEntity.exists();
    public static final boolean FORGE_ENTITY_CAN_UPDATE = Reflector.IForgeEntity_canUpdate.exists();

    public static void putLaunchBlackboard(String key, Object value) {
        Map blackboard = (Map)Reflector.getFieldValue(Reflector.Launch_blackboard);
        if (blackboard == null) {
            return;
        }
        blackboard.put(key, value);
    }

    public static InputStream getOptiFineResourceStream(String path) {
        if (!Reflector.OptiFineResourceLocator.exists()) {
            return null;
        }
        path = StrUtils.removePrefix(path, "/");
        InputStream in = (InputStream)Reflector.call(Reflector.OptiFineResourceLocator_getOptiFineResourceStream, path);
        return in;
    }

    public static ReflectorClass getReflectorClassOptiFineResourceLocator() {
        String className = "optifine.OptiFineResourceLocator";
        Object ofrlClass = System.getProperties().get(className + ".class");
        if (ofrlClass instanceof Class) {
            Class cls = (Class)ofrlClass;
            return new ReflectorClass(cls);
        }
        return new ReflectorClass(className);
    }

    public static boolean blockHasTileEntity(cee state) {
        if (FORGE_BLOCKSTATE_HAS_TILE_ENTITY) {
            return Reflector.callBoolean(state, Reflector.IForgeBlockState_hasTileEntity, new Object[0]);
        }
        return state.b().q();
    }

    public static boolean isItemDamaged(bly stack) {
        if (!Reflector.IForgeItem_showDurabilityBar.exists()) {
            return stack.f();
        }
        return Reflector.callBoolean(stack.b(), Reflector.IForgeItem_showDurabilityBar, stack);
    }

    public static int getLightValue(cee stateIn, bqx worldIn, fx posIn) {
        if (Reflector.IForgeBlockState_getLightValue2.exists()) {
            return Reflector.callInt(stateIn, Reflector.IForgeBlockState_getLightValue2, worldIn, posIn);
        }
        return stateIn.f();
    }

    public static cxu getMapData(bly stack, bru world) {
        if (Reflector.ForgeHooksClient.exists()) {
            bme cfr_ignored_0 = (bme)stack.b();
            return bme.b((bly)stack, (bru)world);
        }
        return bme.b((bly)stack, (bru)world);
    }

    public static String[] getForgeModIds() {
        if (!Reflector.Loader.exists()) {
            return new String[0];
        }
        Object loader = Reflector.call(Reflector.Loader_instance, new Object[0]);
        List listActiveMods = (List)Reflector.call(loader, Reflector.Loader_getActiveModList, new Object[0]);
        if (listActiveMods == null) {
            return new String[0];
        }
        ArrayList<String> listModIds = new ArrayList<String>();
        for (Object modContainer : listActiveMods) {
            String modId;
            if (!Reflector.ModContainer.isInstance(modContainer) || (modId = Reflector.callString(modContainer, Reflector.ModContainer_getModId, new Object[0])) == null) continue;
            listModIds.add(modId);
        }
        String[] modIds = listModIds.toArray(new String[listModIds.size()]);
        return modIds;
    }

    public static boolean isAir(cee blockState, bqz world, fx pos) {
        if (Reflector.IForgeBlockState_isAir2.exists()) {
            return Reflector.callBoolean(blockState, Reflector.IForgeBlockState_isAir2, world, pos);
        }
        return blockState.g();
    }

    public static boolean canDisableShield(bly itemstack, bly itemstack1, bft entityplayer, aqk entityLiving) {
        if (Reflector.IForgeItemStack_canDisableShield.exists()) {
            return Reflector.callBoolean(itemstack, Reflector.IForgeItemStack_canDisableShield, itemstack1, entityplayer, entityLiving);
        }
        return itemstack.b() instanceof bka;
    }

    public static boolean isShield(bly itemstack, bft entityplayer) {
        if (Reflector.IForgeItemStack_isShield.exists()) {
            return Reflector.callBoolean(itemstack, Reflector.IForgeItemStack_isShield, new Object[0]);
        }
        return itemstack.b() == bma.qn;
    }

    public static dlg makeButtonMods(dov guiMainMenu, int yIn, int rowHeightIn) {
        if (!Reflector.ModListScreen_Constructor.exists()) {
            return null;
        }
        dlg btn = new dlg(guiMainMenu.k / 2 - 100, yIn + rowHeightIn * 2, 98, 20, (nr)new of("fml.menu.mods"), button -> {
            doq guiMods = (doq)Reflector.ModListScreen_Constructor.newInstance(guiMainMenu);
            djw.B().a(guiMods);
        });
        return btn;
    }

    public static void setForgeLightPipelineEnabled(boolean value) {
        if (Reflector.ForgeConfig_Client_forgeLightPipelineEnabled.exists()) {
            ReflectorForge.setConfigClientBoolean(Reflector.ForgeConfig_Client_forgeLightPipelineEnabled, value);
        }
    }

    public static boolean getConfigClientBoolean(ReflectorField configField, boolean def) {
        if (!configField.exists()) {
            return def;
        }
        Object client = Reflector.ForgeConfig_CLIENT.getValue();
        if (client == null) {
            return def;
        }
        Object configValue = Reflector.getFieldValue(client, configField);
        if (configValue == null) {
            return def;
        }
        boolean value = Reflector.callBoolean(configValue, Reflector.ForgeConfigSpec_ConfigValue_get, new Object[0]);
        return value;
    }

    private static void setConfigClientBoolean(ReflectorField clientField, boolean value) {
        if (!clientField.exists()) {
            return;
        }
        Object client = Reflector.ForgeConfig_CLIENT.getValue();
        if (client == null) {
            return;
        }
        Object configValue = Reflector.getFieldValue(client, clientField);
        if (configValue == null) {
            return;
        }
        Supplier<Boolean> bs = new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return value;
            }
        };
        Reflector.setFieldValue(configValue, Reflector.ForgeConfigSpec_ConfigValue_defaultSupplier, bs);
        Object spec = Reflector.getFieldValue(configValue, Reflector.ForgeConfigSpec_ConfigValue_spec);
        if (spec != null) {
            Reflector.setFieldValue(spec, Reflector.ForgeConfigSpec_childConfig, null);
        }
        Log.dbg("Set ForgeConfig.CLIENT." + clientField.getTargetField().getName() + "=" + value);
    }

    public static boolean canUpdate(apx entity) {
        if (FORGE_ENTITY_CAN_UPDATE) {
            return Reflector.callBoolean(entity, Reflector.IForgeEntity_canUpdate, new Object[0]);
        }
        return true;
    }

    public static boolean isDamageable(blu item, bly stack) {
        if (Reflector.IForgeItem_isDamageable1.exists()) {
            return Reflector.callBoolean(item, Reflector.IForgeItem_isDamageable1, stack);
        }
        return item.k();
    }
}

