/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import harmonised.pmmo.skills.XP;
import harmonised.pmmo.util.DP;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class CommandLevelAtXp
extends CommandBase {
    public String func_71517_b() {
        return "levelatxp";
    }

    public int func_82362_a() {
        return 0;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        EntityPlayerMP player;
        try {
            player = CommandBase.func_71521_c((ICommandSender)sender);
        }
        catch (PlayerNotFoundException e) {
            return Collections.emptyList();
        }
        NBTTagCompound persistTag = XP.getPersistTag((EntityPlayer)player);
        NBTTagCompound skillsTag = XP.getSkillsTag(persistTag);
        ArrayList<String> completions = new ArrayList<String>();
        for (String skill : skillsTag.func_150296_c()) {
            completions.add(Float.toString(skillsTag.func_74760_g(skill)));
        }
        return completions;
    }

    public List<String> func_71514_a() {
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add("level");
        aliases.add("levelat");
        return aliases;
    }

    public String func_71518_a(ICommandSender sender) {
        return null;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = CommandBase.func_71521_c((ICommandSender)sender);
        if (args.length > 0) {
            float xp;
            try {
                xp = Float.parseFloat(args[0].replace(',', '.'));
            }
            catch (NumberFormatException e) {
                player.func_146105_b((ITextComponent)new TextComponentString("\"" + args[0] + "\" is not a valid number!"), false);
                return;
            }
            player.func_146105_b((ITextComponent)new TextComponentString(DP.dp(Float.valueOf(xp)) + "xp is level " + DP.dp(Float.valueOf(XP.levelAtXpDecimal(xp)))), false);
        } else {
            player.func_146105_b((ITextComponent)new TextComponentString("You must specify a start level, optionally also a goal level!"), false);
        }
    }
}

