/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.network;

import harmonised.pmmo.gui.XPOverlayGUI;
import harmonised.pmmo.network.MessageBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class MessageXp
extends MessageBase<MessageXp> {
    private float xp;
    private String skill;
    private float gainedXp;
    private boolean skip;

    public MessageXp(float xp, String skill, float gainedXp, boolean skip) {
        this.xp = xp;
        this.gainedXp = gainedXp;
        this.skill = skill;
        this.skip = skip;
    }

    public MessageXp() {
    }

    public void fromBytes(ByteBuf buf) {
        this.xp = buf.readFloat();
        this.gainedXp = buf.readFloat();
        this.skill = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.skip = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeFloat(this.xp);
        buf.writeFloat(this.gainedXp);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.skill);
        buf.writeBoolean(this.skip);
    }

    @Override
    public void handleClientSide(MessageXp message, EntityPlayer onlinePlayer) {
        if (message.skill.equals("CLEAR")) {
            XPOverlayGUI.clearXP();
        } else {
            XPOverlayGUI.makeXpDrop(message.xp, message.skill, 10000, message.gainedXp, message.skip);
        }
    }

    @Override
    public void handleServerSide(MessageXp message, EntityPlayer player) {
    }
}

