/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.skills;

import harmonised.pmmo.skills.XP;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;

public class AttributeHandler {
    private static final UUID reachModifierID = UUID.fromString("b20d3436-0d39-4868-96ab-d0a4856e68c6");
    private static final UUID speedModifierID = UUID.fromString("d6103cbc-b90b-4c4b-b3c0-92701fb357b3");
    private static final UUID HPModifierID = UUID.fromString("c95a6e8c-a1c3-4177-9118-1e2cf49b7fcb");
    private static final UUID DamageModifierID = UUID.fromString("992b11f1-7b3f-48d9-8ebd-1acfc3257b17");

    public static double getReach(EntityPlayer player) {
        IAttributeInstance reachAttribute = player.func_110148_a(EntityPlayer.REACH_DISTANCE);
        if (reachAttribute.func_111127_a(reachModifierID) == null) {
            return reachAttribute.func_111125_b();
        }
        return reachAttribute.func_111125_b() + reachAttribute.func_111127_a(reachModifierID).func_111164_d();
    }

    public static void updateReach(EntityPlayer player) {
        IAttributeInstance reachAttribute = player.func_110148_a(EntityPlayer.REACH_DISTANCE);
        float buildLevel = XP.levelAtXp(player.getEntityData().func_74775_l("PlayerPersisted").func_74775_l("skills").func_74760_g("building"));
        if (buildLevel == 1.0f) {
            return;
        }
        double reach = -0.91 + (double)(buildLevel / 25.0f);
        if (reachAttribute.func_111127_a(reachModifierID) == null || reachAttribute.func_111127_a(reachModifierID).func_111164_d() != reach) {
            AttributeModifier reachModifier = new AttributeModifier(reachModifierID, "Reach bonus thanks to Build Level", reach, 0);
            reachAttribute.func_188479_b(reachModifierID);
            reachAttribute.func_111121_a(reachModifier);
        }
    }

    public static void updateSpeed(EntityPlayer player) {
        IAttributeInstance speedAttribute = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        float agilityLevel = XP.levelAtXp(player.getEntityData().func_74775_l("PlayerPersisted").func_74775_l("skills").func_74760_g("agility"));
        double speedBoost = agilityLevel / 2000.0f;
        if (speedBoost > 0.1) {
            speedBoost = 0.1;
        }
        if (speedAttribute.func_111127_a(speedModifierID) == null || speedAttribute.func_111127_a(speedModifierID).func_111164_d() != speedBoost) {
            AttributeModifier speedModifier = new AttributeModifier(speedModifierID, "Speed bonus thanks to Agility Level", speedBoost, 0);
            speedAttribute.func_188479_b(speedModifierID);
            speedAttribute.func_111121_a(speedModifier);
        }
    }

    public static void resetSpeed(EntityPlayer player) {
        IAttributeInstance speedAttribute = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        speedAttribute.func_188479_b(speedModifierID);
    }

    public static void updateHP(EntityPlayer player) {
        IAttributeInstance HPAttribute = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        float enduranceLevel = XP.levelAtXp(player.getEntityData().func_74775_l("PlayerPersisted").func_74775_l("skills").func_74760_g("endurance"));
        int maxHP = (int)Math.floor(enduranceLevel / 10.0f) * 2;
        AttributeModifier HPModifier = new AttributeModifier(HPModifierID, "Max HP Bonus thanks to Endurance Level", (double)maxHP, 0);
        HPAttribute.func_188479_b(HPModifierID);
        HPAttribute.func_111121_a(HPModifier);
    }

    public static void updateDamage(EntityPlayer player) {
        IAttributeInstance DamageAttribute = player.func_110148_a(SharedMonsterAttributes.field_111264_e);
        float combatLevel = XP.levelAtXp(player.getEntityData().func_74775_l("PlayerPersisted").func_74775_l("skills").func_74760_g("combat"));
        int damageBoost = (int)Math.floor(combatLevel / 20.0f);
        AttributeModifier damageModifier = new AttributeModifier(DamageModifierID, "Damage Boost thanks to Combat Level", (double)damageBoost, 0);
        DamageAttribute.func_188479_b(DamageModifierID);
        DamageAttribute.func_111121_a(damageModifier);
    }
}

