/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.skills;

import harmonised.pmmo.gui.XPOverlayGUI;
import harmonised.pmmo.network.MessageXp;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.AttributeHandler;
import harmonised.pmmo.skills.PlacedBlocks;
import harmonised.pmmo.util.DP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBeetroot;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.BlockStem;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class XP {
    private static Map<ResourceLocation, Float> xpValues = new HashMap<ResourceLocation, Float>();
    private static Map<ResourceLocation, Float> oreDoubleValues = new HashMap<ResourceLocation, Float>();
    private static Map<ResourceLocation, Float> plantDoubleValues = new HashMap<ResourceLocation, Float>();
    private static Map<ResourceLocation, Float> salvageBaseValue = new HashMap<ResourceLocation, Float>();
    private static Map<ResourceLocation, Float> salvageValuePerLevel = new HashMap<ResourceLocation, Float>();
    private static Map<ResourceLocation, Float> repairXp = new HashMap<ResourceLocation, Float>();
    private static Map<ResourceLocation, Float> salvageXp = new HashMap<ResourceLocation, Float>();
    private static Map<ResourceLocation, Boolean> noDropOres = new HashMap<ResourceLocation, Boolean>();
    private static Map<ResourceLocation, ItemStack> oreItems = new HashMap<ResourceLocation, ItemStack>();
    private static Map<ResourceLocation, ItemStack> toolItems = new HashMap<ResourceLocation, ItemStack>();
    private static Map<ResourceLocation, Integer> toolItemAmount = new HashMap<ResourceLocation, Integer>();
    private static Map<Material, String> materialHarvestTool = new HashMap<Material, String>();
    private static Map<String, Integer> skillColors = new HashMap<String, Integer>();
    public static Map<String, TextFormatting> skillTextFormat = new HashMap<String, TextFormatting>();
    private static Map<String, Long> lastAward = new HashMap<String, Long>();
    private static Map<String, BlockPos> lastPosPlaced = new HashMap<String, BlockPos>();
    public static List<String> validSkills = new ArrayList<String>();
    public static float globalMultiplier = 1.0f;
    public static float maxXp = XP.xpAtLevel(999.0f);
    public static Set<String> lapisDonators = new HashSet<String>();
    public static Set<String> dandelionDonators = new HashSet<String>();
    public static Set<String> ironDonators = new HashSet<String>();

    public static void initValues() {
        validSkills.add("mining");
        validSkills.add("building");
        validSkills.add("excavation");
        validSkills.add("woodcutting");
        validSkills.add("farming");
        validSkills.add("agility");
        validSkills.add("endurance");
        validSkills.add("combat");
        validSkills.add("archery");
        validSkills.add("repairing");
        validSkills.add("flying");
        validSkills.add("swimming");
        validSkills.add("fishing");
        validSkills.add("crafting");
        xpValues.put(Blocks.field_150350_a.getRegistryName(), Float.valueOf(0.0f));
        xpValues.put(Blocks.field_150330_I.getRegistryName(), Float.valueOf(5.0f));
        xpValues.put(Blocks.field_150392_bi.getRegistryName(), Float.valueOf(15.0f));
        xpValues.put(Blocks.field_150327_N.getRegistryName(), Float.valueOf(15.0f));
        xpValues.put(Blocks.field_150328_O.getRegistryName(), Float.valueOf(17.5f));
        xpValues.put(Blocks.field_150398_cm.getRegistryName(), Float.valueOf(25.0f));
        xpValues.put(Blocks.field_150329_H.getRegistryName(), Float.valueOf(6.0f));
        xpValues.put(Blocks.field_150464_aj.getRegistryName(), Float.valueOf(25.0f));
        xpValues.put(Blocks.field_150469_bN.getRegistryName(), Float.valueOf(7.5f));
        xpValues.put(Blocks.field_150459_bM.getRegistryName(), Float.valueOf(7.5f));
        xpValues.put(Blocks.field_150375_by.getRegistryName(), Float.valueOf(30.0f));
        xpValues.put(Blocks.field_185773_cZ.getRegistryName(), Float.valueOf(35.0f));
        xpValues.put(Blocks.field_150388_bm.getRegistryName(), Float.valueOf(10.0f));
        xpValues.put(Blocks.field_150345_g.getRegistryName(), Float.valueOf(10.0f));
        xpValues.put(Blocks.field_150362_t.getRegistryName(), Float.valueOf(0.8f));
        xpValues.put(Blocks.field_150361_u.getRegistryName(), Float.valueOf(0.8f));
        xpValues.put(Blocks.field_150423_aK.getRegistryName(), Float.valueOf(35.0f));
        xpValues.put(Blocks.field_150440_ba.getRegistryName(), Float.valueOf(7.0f));
        xpValues.put(Blocks.field_150420_aW.getRegistryName(), Float.valueOf(5.0f));
        xpValues.put(Blocks.field_150338_P.getRegistryName(), Float.valueOf(15.0f));
        xpValues.put(Blocks.field_150419_aX.getRegistryName(), Float.valueOf(5.0f));
        xpValues.put(Blocks.field_150337_Q.getRegistryName(), Float.valueOf(15.0f));
        xpValues.put(Blocks.field_150436_aH.getRegistryName(), Float.valueOf(10.0f));
        xpValues.put(Blocks.field_150434_aF.getRegistryName(), Float.valueOf(20.0f));
        xpValues.put(Blocks.field_185765_cR.getRegistryName(), Float.valueOf(2.5f));
        xpValues.put(Blocks.field_185766_cS.getRegistryName(), Float.valueOf(35.0f));
        xpValues.put(Blocks.field_150395_bd.getRegistryName(), Float.valueOf(3.5f));
        xpValues.put(Blocks.field_150321_G.getRegistryName(), Float.valueOf(5.0f));
        xpValues.put(Blocks.field_150364_r.getRegistryName(), Float.valueOf(28.0f));
        xpValues.put(Blocks.field_150363_s.getRegistryName(), Float.valueOf(18.0f));
        xpValues.put(Blocks.field_150344_f.getRegistryName(), Float.valueOf(5.0f));
        xpValues.put(Blocks.field_150342_X.getRegistryName(), Float.valueOf(100.0f));
        xpValues.put(Blocks.field_150346_d.getRegistryName(), Float.valueOf(1.5f));
        xpValues.put(Blocks.field_150349_c.getRegistryName(), Float.valueOf(2.5f));
        xpValues.put(Blocks.field_150354_m.getRegistryName(), Float.valueOf(1.0f));
        xpValues.put(Blocks.field_150351_n.getRegistryName(), Float.valueOf(2.0f));
        xpValues.put(Blocks.field_150391_bh.getRegistryName(), Float.valueOf(15.0f));
        xpValues.put(Blocks.field_180399_cE.getRegistryName(), Float.valueOf(50.0f));
        xpValues.put(Blocks.field_150418_aU.getRegistryName(), Float.valueOf(200.0f));
        xpValues.put(Blocks.field_150365_q.getRegistryName(), Float.valueOf(2.0f));
        xpValues.put(Blocks.field_150366_p.getRegistryName(), Float.valueOf(12.0f));
        xpValues.put(Blocks.field_150450_ax.getRegistryName(), Float.valueOf(1.5f));
        xpValues.put(Blocks.field_150439_ay.getRegistryName(), Float.valueOf(1.5f));
        xpValues.put(Blocks.field_150352_o.getRegistryName(), Float.valueOf(22.0f));
        xpValues.put(Blocks.field_150369_x.getRegistryName(), Float.valueOf(5.0f));
        xpValues.put(Blocks.field_150449_bY.getRegistryName(), Float.valueOf(1.5f));
        xpValues.put(Blocks.field_150482_ag.getRegistryName(), Float.valueOf(35.0f));
        xpValues.put(Blocks.field_150412_bA.getRegistryName(), Float.valueOf(60.0f));
        xpValues.put(Items.field_151115_aP.getRegistryName(), Float.valueOf(50.0f));
        xpValues.put(Items.field_151141_av.getRegistryName(), Float.valueOf(250.0f));
        xpValues.put(Items.field_151057_cb.getRegistryName(), Float.valueOf(350.0f));
        skillColors.put("mining", 65535);
        skillColors.put("building", 65535);
        skillColors.put("excavation", 15112448);
        skillColors.put("woodcutting", 16753434);
        skillColors.put("farming", 58880);
        skillColors.put("agility", 0x66CC66);
        skillColors.put("endurance", 0xCC0000);
        skillColors.put("combat", 0xFF3300);
        skillColors.put("archery", 0xFFFF00);
        skillColors.put("repairing", 0xF0F0F0);
        skillColors.put("flying", 0xCCCCFF);
        skillColors.put("swimming", 0x3366FF);
        skillColors.put("fishing", 52479);
        skillColors.put("crafting", 0xFF9900);
        skillTextFormat.put("mining", TextFormatting.AQUA);
        skillTextFormat.put("building", TextFormatting.AQUA);
        skillTextFormat.put("excavation", TextFormatting.GOLD);
        skillTextFormat.put("woodcutting", TextFormatting.GOLD);
        skillTextFormat.put("farming", TextFormatting.GREEN);
        skillTextFormat.put("agility", TextFormatting.GREEN);
        skillTextFormat.put("endurance", TextFormatting.DARK_RED);
        skillTextFormat.put("combat", TextFormatting.RED);
        skillTextFormat.put("archery", TextFormatting.YELLOW);
        skillTextFormat.put("repairing", TextFormatting.GRAY);
        skillTextFormat.put("flying", TextFormatting.GRAY);
        skillTextFormat.put("swimming", TextFormatting.AQUA);
        skillTextFormat.put("fishing", TextFormatting.AQUA);
        skillTextFormat.put("crafting", TextFormatting.GOLD);
        ironDonators.add("didis54");
        oreDoubleValues.put(Blocks.field_150365_q.getRegistryName(), Float.valueOf(1.0f));
        oreDoubleValues.put(Items.field_151044_h.getRegistryName(), Float.valueOf(1.0f));
        oreDoubleValues.put(Blocks.field_150366_p.getRegistryName(), Float.valueOf(0.75f));
        oreDoubleValues.put(Items.field_151042_j.getRegistryName(), Float.valueOf(0.75f));
        oreDoubleValues.put(Blocks.field_150450_ax.getRegistryName(), Float.valueOf(2.0f));
        oreDoubleValues.put(Blocks.field_150439_ay.getRegistryName(), Float.valueOf(2.0f));
        oreDoubleValues.put(Items.field_151137_ax.getRegistryName(), Float.valueOf(2.0f));
        oreDoubleValues.put(Blocks.field_150352_o.getRegistryName(), Float.valueOf(0.5f));
        oreDoubleValues.put(Items.field_151043_k.getRegistryName(), Float.valueOf(0.5f));
        oreDoubleValues.put(Blocks.field_150365_q.getRegistryName(), Float.valueOf(0.5f));
        oreDoubleValues.put(Blocks.field_150369_x.getRegistryName(), Float.valueOf(1.5f));
        oreDoubleValues.put(Items.field_151100_aR.getRegistryName(), Float.valueOf(1.5f));
        oreDoubleValues.put(Blocks.field_150449_bY.getRegistryName(), Float.valueOf(0.55f));
        oreDoubleValues.put(Items.field_151128_bU.getRegistryName(), Float.valueOf(0.55f));
        oreDoubleValues.put(Blocks.field_150482_ag.getRegistryName(), Float.valueOf(0.33f));
        oreDoubleValues.put(Items.field_151045_i.getRegistryName(), Float.valueOf(0.33f));
        oreDoubleValues.put(Blocks.field_150412_bA.getRegistryName(), Float.valueOf(0.75f));
        oreDoubleValues.put(Items.field_151166_bC.getRegistryName(), Float.valueOf(0.75f));
        plantDoubleValues.put(Items.field_151015_O.getRegistryName(), Float.valueOf(0.75f));
        plantDoubleValues.put(Items.field_151014_N.getRegistryName(), Float.valueOf(0.75f));
        plantDoubleValues.put(Items.field_151172_bF.getRegistryName(), Float.valueOf(1.5f));
        plantDoubleValues.put(Items.field_151170_bI.getRegistryName(), Float.valueOf(1.5f));
        plantDoubleValues.put(Items.field_151174_bG.getRegistryName(), Float.valueOf(1.5f));
        plantDoubleValues.put(Items.field_185164_cV.getRegistryName(), Float.valueOf(1.0f));
        plantDoubleValues.put(Items.field_185163_cU.getRegistryName(), Float.valueOf(1.0f));
        plantDoubleValues.put(Items.field_151120_aE.getRegistryName(), Float.valueOf(0.33f));
        plantDoubleValues.put(Blocks.field_150434_aF.getRegistryName(), Float.valueOf(0.45f));
        plantDoubleValues.put(Items.field_151075_bm.getRegistryName(), Float.valueOf(0.75f));
        plantDoubleValues.put(Blocks.field_150423_aK.getRegistryName(), Float.valueOf(0.6f));
        plantDoubleValues.put(Items.field_151080_bb.getRegistryName(), Float.valueOf(0.6f));
        plantDoubleValues.put(Blocks.field_150440_ba.getRegistryName(), Float.valueOf(0.75f));
        plantDoubleValues.put(Items.field_151127_ba.getRegistryName(), Float.valueOf(0.75f));
        plantDoubleValues.put(Items.field_151081_bc.getRegistryName(), Float.valueOf(0.75f));
        plantDoubleValues.put(Items.field_151100_aR.getRegistryName(), Float.valueOf(1.5f));
        noDropOres.put(Blocks.field_150366_p.getRegistryName(), true);
        noDropOres.put(Blocks.field_150352_o.getRegistryName(), true);
        oreItems.put(Blocks.field_150366_p.getRegistryName(), new ItemStack(Blocks.field_150366_p, 0));
        oreItems.put(Blocks.field_150352_o.getRegistryName(), new ItemStack(Blocks.field_150352_o, 0));
        oreItems.put(Blocks.field_150450_ax.getRegistryName(), new ItemStack(Items.field_151137_ax, 0));
        oreItems.put(Blocks.field_150439_ay.getRegistryName(), new ItemStack(Items.field_151137_ax, 0));
        oreItems.put(Blocks.field_150369_x.getRegistryName(), new ItemStack(Items.field_151100_aR, 4));
        oreItems.put(Blocks.field_150449_bY.getRegistryName(), new ItemStack(Items.field_151128_bU, 0));
        oreItems.put(Blocks.field_150482_ag.getRegistryName(), new ItemStack(Items.field_151045_i, 0));
        oreItems.put(Blocks.field_150412_bA.getRegistryName(), new ItemStack(Items.field_151166_bC, 0));
        materialHarvestTool.put(Material.field_151574_g, "pickaxe");
        materialHarvestTool.put(Material.field_151592_s, "pickaxe");
        materialHarvestTool.put(Material.field_151588_w, "pickaxe");
        materialHarvestTool.put(Material.field_151573_f, "pickaxe");
        materialHarvestTool.put(Material.field_151598_x, "pickaxe");
        materialHarvestTool.put(Material.field_76233_E, "pickaxe");
        materialHarvestTool.put(Material.field_151591_t, "pickaxe");
        materialHarvestTool.put(Material.field_151576_e, "pickaxe");
        materialHarvestTool.put(Material.field_151575_d, "axe");
        materialHarvestTool.put(Material.field_151584_j, "axe");
        materialHarvestTool.put(Material.field_151571_B, "shovel");
        materialHarvestTool.put(Material.field_151577_b, "shovel");
        materialHarvestTool.put(Material.field_151578_c, "shovel");
        materialHarvestTool.put(Material.field_151595_p, "shovel");
        materialHarvestTool.put(Material.field_151596_z, "shovel");
        materialHarvestTool.put(Material.field_151597_y, "shovel");
        materialHarvestTool.put(Material.field_151585_k, "hoe");
        materialHarvestTool.put(Material.field_151582_l, "hoe");
        materialHarvestTool.put(Material.field_151570_A, "hoe");
        toolItems.put(Items.field_151161_ac.getRegistryName(), new ItemStack(Items.field_151045_i));
        toolItems.put(Items.field_151163_ad.getRegistryName(), new ItemStack(Items.field_151045_i));
        toolItems.put(Items.field_151173_ae.getRegistryName(), new ItemStack(Items.field_151045_i));
        toolItems.put(Items.field_151175_af.getRegistryName(), new ItemStack(Items.field_151045_i));
        toolItems.put(Items.field_151056_x.getRegistryName(), new ItemStack(Items.field_151045_i));
        toolItems.put(Items.field_151012_L.getRegistryName(), new ItemStack(Items.field_151045_i));
        toolItems.put(Items.field_151046_w.getRegistryName(), new ItemStack(Items.field_151045_i));
        toolItems.put(Items.field_151047_v.getRegistryName(), new ItemStack(Items.field_151045_i));
        toolItems.put(Items.field_151048_u.getRegistryName(), new ItemStack(Items.field_151045_i));
        toolItems.put(Items.field_151169_ag.getRegistryName(), new ItemStack(Items.field_151043_k));
        toolItems.put(Items.field_151171_ah.getRegistryName(), new ItemStack(Items.field_151043_k));
        toolItems.put(Items.field_151149_ai.getRegistryName(), new ItemStack(Items.field_151043_k));
        toolItems.put(Items.field_151151_aj.getRegistryName(), new ItemStack(Items.field_151043_k));
        toolItems.put(Items.field_151006_E.getRegistryName(), new ItemStack(Items.field_151043_k));
        toolItems.put(Items.field_151013_M.getRegistryName(), new ItemStack(Items.field_151043_k));
        toolItems.put(Items.field_151005_D.getRegistryName(), new ItemStack(Items.field_151043_k));
        toolItems.put(Items.field_151011_C.getRegistryName(), new ItemStack(Items.field_151043_k));
        toolItems.put(Items.field_151010_B.getRegistryName(), new ItemStack(Items.field_151043_k));
        toolItems.put(Items.field_151028_Y.getRegistryName(), new ItemStack(Items.field_151042_j));
        toolItems.put(Items.field_151030_Z.getRegistryName(), new ItemStack(Items.field_151042_j));
        toolItems.put(Items.field_151165_aa.getRegistryName(), new ItemStack(Items.field_151042_j));
        toolItems.put(Items.field_151167_ab.getRegistryName(), new ItemStack(Items.field_151042_j));
        toolItems.put(Items.field_151036_c.getRegistryName(), new ItemStack(Items.field_151042_j));
        toolItems.put(Items.field_151019_K.getRegistryName(), new ItemStack(Items.field_151042_j));
        toolItems.put(Items.field_151035_b.getRegistryName(), new ItemStack(Items.field_151042_j));
        toolItems.put(Items.field_151037_a.getRegistryName(), new ItemStack(Items.field_151042_j));
        toolItems.put(Items.field_151040_l.getRegistryName(), new ItemStack(Items.field_151042_j));
        toolItems.put(Items.field_151024_Q.getRegistryName(), new ItemStack(Items.field_151116_aA));
        toolItems.put(Items.field_151027_R.getRegistryName(), new ItemStack(Items.field_151116_aA));
        toolItems.put(Items.field_151026_S.getRegistryName(), new ItemStack(Items.field_151116_aA));
        toolItems.put(Items.field_151021_T.getRegistryName(), new ItemStack(Items.field_151116_aA));
        toolItems.put(Items.field_151049_t.getRegistryName(), new ItemStack(Blocks.field_150347_e));
        toolItems.put(Items.field_151018_J.getRegistryName(), new ItemStack(Blocks.field_150347_e));
        toolItems.put(Items.field_151050_s.getRegistryName(), new ItemStack(Blocks.field_150347_e));
        toolItems.put(Items.field_151051_r.getRegistryName(), new ItemStack(Blocks.field_150347_e));
        toolItems.put(Items.field_151052_q.getRegistryName(), new ItemStack(Blocks.field_150347_e));
        toolItems.put(Items.field_151053_p.getRegistryName(), new ItemStack(Blocks.field_150344_f));
        toolItems.put(Items.field_151017_I.getRegistryName(), new ItemStack(Blocks.field_150344_f));
        toolItems.put(Items.field_151039_o.getRegistryName(), new ItemStack(Blocks.field_150344_f));
        toolItems.put(Items.field_151038_n.getRegistryName(), new ItemStack(Blocks.field_150344_f));
        toolItems.put(Items.field_151041_m.getRegistryName(), new ItemStack(Blocks.field_150344_f));
        toolItems.put(Items.field_151097_aZ.getRegistryName(), new ItemStack(Items.field_151042_j));
        toolItems.put(Items.field_151031_f.getRegistryName(), new ItemStack(Items.field_151007_F));
        toolItems.put(Items.field_151112_aM.getRegistryName(), new ItemStack(Items.field_151007_F));
        toolItems.put(Items.field_185160_cR.getRegistryName(), new ItemStack(Items.field_151116_aA));
        toolItemAmount.put(Items.field_151161_ac.getRegistryName(), 5);
        toolItemAmount.put(Items.field_151163_ad.getRegistryName(), 8);
        toolItemAmount.put(Items.field_151173_ae.getRegistryName(), 7);
        toolItemAmount.put(Items.field_151175_af.getRegistryName(), 4);
        toolItemAmount.put(Items.field_151056_x.getRegistryName(), 3);
        toolItemAmount.put(Items.field_151012_L.getRegistryName(), 2);
        toolItemAmount.put(Items.field_151046_w.getRegistryName(), 3);
        toolItemAmount.put(Items.field_151047_v.getRegistryName(), 1);
        toolItemAmount.put(Items.field_151048_u.getRegistryName(), 2);
        toolItemAmount.put(Items.field_151169_ag.getRegistryName(), 5);
        toolItemAmount.put(Items.field_151171_ah.getRegistryName(), 8);
        toolItemAmount.put(Items.field_151149_ai.getRegistryName(), 7);
        toolItemAmount.put(Items.field_151151_aj.getRegistryName(), 4);
        toolItemAmount.put(Items.field_151006_E.getRegistryName(), 3);
        toolItemAmount.put(Items.field_151013_M.getRegistryName(), 2);
        toolItemAmount.put(Items.field_151005_D.getRegistryName(), 3);
        toolItemAmount.put(Items.field_151011_C.getRegistryName(), 1);
        toolItemAmount.put(Items.field_151010_B.getRegistryName(), 2);
        toolItemAmount.put(Items.field_151028_Y.getRegistryName(), 5);
        toolItemAmount.put(Items.field_151030_Z.getRegistryName(), 8);
        toolItemAmount.put(Items.field_151165_aa.getRegistryName(), 7);
        toolItemAmount.put(Items.field_151167_ab.getRegistryName(), 4);
        toolItemAmount.put(Items.field_151036_c.getRegistryName(), 3);
        toolItemAmount.put(Items.field_151019_K.getRegistryName(), 2);
        toolItemAmount.put(Items.field_151035_b.getRegistryName(), 3);
        toolItemAmount.put(Items.field_151037_a.getRegistryName(), 1);
        toolItemAmount.put(Items.field_151040_l.getRegistryName(), 2);
        toolItemAmount.put(Items.field_151024_Q.getRegistryName(), 5);
        toolItemAmount.put(Items.field_151027_R.getRegistryName(), 8);
        toolItemAmount.put(Items.field_151026_S.getRegistryName(), 7);
        toolItemAmount.put(Items.field_151021_T.getRegistryName(), 4);
        toolItemAmount.put(Items.field_151049_t.getRegistryName(), 3);
        toolItemAmount.put(Items.field_151018_J.getRegistryName(), 2);
        toolItemAmount.put(Items.field_151050_s.getRegistryName(), 3);
        toolItemAmount.put(Items.field_151051_r.getRegistryName(), 1);
        toolItemAmount.put(Items.field_151052_q.getRegistryName(), 2);
        toolItemAmount.put(Items.field_151053_p.getRegistryName(), 3);
        toolItemAmount.put(Items.field_151017_I.getRegistryName(), 2);
        toolItemAmount.put(Items.field_151039_o.getRegistryName(), 3);
        toolItemAmount.put(Items.field_151038_n.getRegistryName(), 1);
        toolItemAmount.put(Items.field_151041_m.getRegistryName(), 2);
        toolItemAmount.put(Items.field_151097_aZ.getRegistryName(), 2);
        toolItemAmount.put(Items.field_151031_f.getRegistryName(), 3);
        toolItemAmount.put(Items.field_151112_aM.getRegistryName(), 2);
        toolItemAmount.put(Items.field_185160_cR.getRegistryName(), 7);
        salvageBaseValue.put(Blocks.field_150347_e.getRegistryName(), Float.valueOf(50.0f));
        salvageBaseValue.put(Blocks.field_150344_f.getRegistryName(), Float.valueOf(70.0f));
        salvageBaseValue.put(Items.field_151007_F.getRegistryName(), Float.valueOf(65.0f));
        salvageBaseValue.put(Items.field_151042_j.getRegistryName(), Float.valueOf(20.0f));
        salvageBaseValue.put(Items.field_151043_k.getRegistryName(), Float.valueOf(35.0f));
        salvageBaseValue.put(Items.field_151045_i.getRegistryName(), Float.valueOf(0.0f));
        salvageBaseValue.put(Items.field_151116_aA.getRegistryName(), Float.valueOf(60.0f));
        salvageValuePerLevel.put(Blocks.field_150347_e.getRegistryName(), Float.valueOf(2.0f));
        salvageValuePerLevel.put(Blocks.field_150344_f.getRegistryName(), Float.valueOf(0.8f));
        salvageValuePerLevel.put(Items.field_151007_F.getRegistryName(), Float.valueOf(1.0f));
        salvageValuePerLevel.put(Items.field_151042_j.getRegistryName(), Float.valueOf(0.8f));
        salvageValuePerLevel.put(Items.field_151043_k.getRegistryName(), Float.valueOf(1.6f));
        salvageValuePerLevel.put(Items.field_151045_i.getRegistryName(), Float.valueOf(0.666f));
        salvageValuePerLevel.put(Items.field_151116_aA.getRegistryName(), Float.valueOf(1.0f));
        repairXp.put(Items.field_151042_j.getRegistryName(), Float.valueOf(35.0f));
        repairXp.put(Items.field_151043_k.getRegistryName(), Float.valueOf(666.0f));
        repairXp.put(Items.field_151045_i.getRegistryName(), Float.valueOf(75.0f));
        repairXp.put(Items.field_151007_F.getRegistryName(), Float.valueOf(20.0f));
        repairXp.put(Items.field_151116_aA.getRegistryName(), Float.valueOf(40.0f));
        salvageXp.put(Items.field_151042_j.getRegistryName(), Float.valueOf(20.0f));
        salvageXp.put(Items.field_151043_k.getRegistryName(), Float.valueOf(25.0f));
        salvageXp.put(Items.field_151045_i.getRegistryName(), Float.valueOf(50.0f));
        salvageXp.put(Items.field_151007_F.getRegistryName(), Float.valueOf(2.0f));
        salvageXp.put(Items.field_151116_aA.getRegistryName(), Float.valueOf(5.0f));
    }

    private static String getSkill(String tool) {
        if (tool == null) {
            return "none";
        }
        switch (tool) {
            case "pickaxe": {
                return "mining";
            }
            case "shovel": {
                return "excavation";
            }
            case "axe": {
                return "woodcutting";
            }
            case "hoe": {
                return "farming";
            }
        }
        return "none";
    }

    private static float getXp(ResourceLocation registryName) {
        if (xpValues.get(registryName) != null) {
            return xpValues.get(registryName).floatValue();
        }
        return 0.0f;
    }

    private static float getOreDoubleChance(ResourceLocation registryName) {
        if (oreDoubleValues.get(registryName) != null) {
            return oreDoubleValues.get(registryName).floatValue();
        }
        return 0.0f;
    }

    private static float getPlantDoubleChance(ResourceLocation registryName) {
        if (plantDoubleValues.get(registryName) != null) {
            return plantDoubleValues.get(registryName).floatValue();
        }
        return 0.0f;
    }

    private static boolean getNoDropOre(ResourceLocation registryName) {
        return noDropOres.get(registryName) != null;
    }

    public static Integer getSkillColor(String skill) {
        if (skillColors.get(skill) != null) {
            return skillColors.get(skill);
        }
        return 0xFFFFFF;
    }

    private static String correctHarvestTool(Material material) {
        if (materialHarvestTool.get(material) != null) {
            return materialHarvestTool.get(material);
        }
        return "none";
    }

    private static ItemStack getToolItem(ResourceLocation name) {
        if (toolItems.get(name) != null) {
            return toolItems.get(name);
        }
        return null;
    }

    private static Integer getToolItemAmount(ResourceLocation name) {
        if (toolItemAmount.get(name) != null) {
            return toolItemAmount.get(name);
        }
        return 0;
    }

    private static float getSalvageBaseValue(ResourceLocation registryName) {
        if (salvageBaseValue.get(registryName) != null) {
            return salvageBaseValue.get(registryName).floatValue();
        }
        return 0.0f;
    }

    private static float getSalvageValuePerLevel(ResourceLocation registryName) {
        if (salvageValuePerLevel.get(registryName) != null) {
            return salvageValuePerLevel.get(registryName).floatValue();
        }
        return 0.0f;
    }

    private static float getRepairXp(ResourceLocation registryName) {
        if (repairXp.get(registryName) != null) {
            return repairXp.get(registryName).floatValue();
        }
        return 0.0f;
    }

    private static float getSalvageXp(ResourceLocation registryName) {
        if (salvageXp.get(registryName) != null) {
            return salvageXp.get(registryName).floatValue();
        }
        return 0.0f;
    }

    public static void handlePlaced(BlockEvent.PlaceEvent event) {
        EntityPlayer player = event.getPlayer();
        if (!player.func_184812_l_()) {
            float blockHardness;
            Block block = event.getPlacedBlock().func_177230_c();
            NBTTagCompound persistTag = XP.getPersistTag(player);
            NBTTagCompound skillsTag = XP.getSkillsTag(persistTag);
            try {
                blockHardness = block.func_176195_g(block.func_176223_P(), event.getWorld(), event.getPos());
                if (blockHardness > 50.0f) {
                    blockHardness = 50.0f;
                }
            }
            catch (Exception e) {
                blockHardness = 1.0f;
            }
            String playerName = player.func_70005_c_();
            BlockPos blockPos = event.getPos();
            if (!lastPosPlaced.containsKey(playerName) || !lastPosPlaced.get(playerName).equals((Object)blockPos)) {
                if (block.equals(Blocks.field_150458_ak)) {
                    XP.awardXp(player, "farming", "tilting dirt", blockHardness, false);
                } else {
                    XP.awardXp(player, "building", block.func_149732_F(), blockHardness, false);
                }
            }
            if (lastPosPlaced.containsKey(playerName)) {
                lastPosPlaced.replace(player.func_70005_c_(), event.getPos());
            } else {
                lastPosPlaced.put(playerName, blockPos);
            }
            if (XP.getXp(block.getRegistryName()) != 0.0f) {
                PlacedBlocks.orePlaced(event.getWorld(), event.getPos());
            }
        }
    }

    public static void handleHarvested(BlockEvent.HarvestDropsEvent event) {
        EntityPlayer player;
        if (event.getHarvester() instanceof EntityPlayer && !event.getWorld().field_72995_K && !(player = event.getHarvester()).func_184812_l_()) {
            float blockHardness;
            NBTTagCompound persistTag = XP.getPersistTag(player);
            NBTTagCompound skillsTag = XP.getSkillsTag(persistTag);
            Block block = event.getState().func_177230_c();
            if (block == Blocks.field_150436_aH || block == Blocks.field_150434_aF) {
                return;
            }
            ResourceLocation blockRegistry = block.getRegistryName();
            Material material = block.func_149688_o(block.func_176223_P());
            boolean wasPlaced = PlacedBlocks.isPlayerPlaced(event.getWorld(), event.getPos());
            try {
                blockHardness = block.func_176195_g(block.func_176223_P(), event.getWorld(), event.getPos());
                if (blockHardness > 50.0f) {
                    blockHardness = 50.0f;
                }
            }
            catch (Exception e) {
                blockHardness = 1.0f;
            }
            float award = blockHardness;
            List drops = event.getDrops();
            if (material.equals(Material.field_151585_k) && drops.size() > 0) {
                int matches;
                int maxAge;
                int age;
                Item theDropItem;
                ItemStack theDrop;
                block35: {
                    theDrop = new ItemStack(((ItemStack)drops.get(0)).func_77973_b(), 1, ((ItemStack)drops.get(0)).func_77960_j());
                    theDropItem = ((ItemStack)drops.get(0)).func_77973_b();
                    if (block instanceof BlockFlower) {
                        if (!wasPlaced) {
                            award += XP.getXp(block.getRegistryName()) * (float)drops.size();
                        }
                        if (award > 0.0f) {
                            XP.awardXp(player, "farming", "harvesting " + theDrop.func_82833_r(), award, false);
                        }
                        return;
                    }
                    IBlockState state = event.getState();
                    age = -1;
                    maxAge = -1;
                    matches = 0;
                    try {
                        if (block instanceof BlockBeetroot) {
                            age = (Integer)state.func_177229_b((IProperty)BlockBeetroot.field_185531_a);
                            maxAge = 3;
                            break block35;
                        }
                        if (block instanceof BlockCrops) {
                            age = (Integer)state.func_177229_b((IProperty)BlockCrops.field_176488_a);
                            maxAge = 7;
                            break block35;
                        }
                        if (block instanceof BlockNetherWart) {
                            age = (Integer)state.func_177229_b((IProperty)BlockNetherWart.field_176486_a);
                            maxAge = 3;
                            break block35;
                        }
                        if (block instanceof BlockCocoa) {
                            age = (Integer)state.func_177229_b((IProperty)BlockCocoa.field_176501_a);
                            maxAge = 2;
                            break block35;
                        }
                        if (block instanceof BlockStem) {
                            age = (Integer)state.func_177229_b((IProperty)BlockStem.field_176484_a);
                            maxAge = 7;
                            break block35;
                        }
                        return;
                    }
                    catch (IllegalArgumentException err) {
                        return;
                    }
                }
                if (age == maxAge && age >= 0) {
                    int currLevel = XP.levelAtXp(skillsTag.func_74760_g("farming"));
                    float extraChance = XP.getPlantDoubleChance(theDropItem.getRegistryName()) * (float)currLevel;
                    int guaranteedDrop = 0;
                    int extraDrop = 0;
                    if (extraChance / 100.0f > 1.0f) {
                        guaranteedDrop = (int)Math.floor(extraChance / 100.0f);
                        extraChance = (float)((double)(extraChance / 100.0f) - Math.floor(extraChance / 100.0f)) * 100.0f;
                    }
                    if (Math.ceil(Math.random() * 1000.0) <= (double)(extraChance * 10.0f)) {
                        extraDrop = 1;
                    }
                    for (int i = 0; i < guaranteedDrop + extraDrop; ++i) {
                        drops.add(theDrop);
                    }
                    for (ItemStack drop : drops) {
                        if (!drop.func_77973_b().equals(theDropItem)) continue;
                        ++matches;
                    }
                    if (guaranteedDrop + extraDrop > 0) {
                        player.func_146105_b(new TextComponentString(Integer.toString(guaranteedDrop + extraDrop) + " Extra " + theDrop.func_82833_r() + " Dropped!").func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)), true);
                    }
                    XP.awardXp(player, "farming", "harvesting " + (matches - guaranteedDrop - extraDrop) + " + " + (guaranteedDrop + extraDrop) + " " + theDrop.func_82833_r(), award += XP.getXp(block.getRegistryName()) * (float)matches, false);
                }
            } else if (XP.getOreDoubleChance(block.getRegistryName()) != 0.0f) {
                Map enchants = EnchantmentHelper.func_82781_a((ItemStack)player.func_184614_ca());
                boolean isSilk = enchants.get(Enchantments.field_185306_r) != null;
                boolean noDropOre = XP.getNoDropOre(block.getRegistryName());
                if (!wasPlaced && !isSilk) {
                    award += XP.getXp(block.getRegistryName()) * (float)drops.size();
                }
                if (noDropOre && !wasPlaced || !noDropOre && !isSilk) {
                    int currLevel = XP.levelAtXp(skillsTag.func_74760_g("mining"));
                    float extraChance = XP.getOreDoubleChance(block.getRegistryName()) * (float)currLevel;
                    int guaranteedDrop = 0;
                    int extraDrop = 0;
                    if (extraChance / 100.0f > 1.0f) {
                        guaranteedDrop = (int)Math.floor(extraChance / 100.0f);
                        extraChance = (float)((double)(extraChance / 100.0f) - Math.floor(extraChance / 100.0f)) * 100.0f;
                    }
                    if (Math.ceil(Math.random() * 1000.0) <= (double)(extraChance * 10.0f)) {
                        extraDrop = 1;
                    }
                    if (!noDropOre && wasPlaced) {
                        award += XP.getXp(block.getRegistryName()) * (float)drops.size();
                    }
                    String awardMessage = "mining " + block.func_149732_F();
                    if (guaranteedDrop + extraDrop > 0) {
                        award += XP.getXp(block.getRegistryName()) * (float)(guaranteedDrop + extraDrop);
                        ItemStack theDrop = new ItemStack(((ItemStack)drops.get(0)).func_77973_b(), guaranteedDrop + extraDrop, ((ItemStack)drops.get(0)).func_77960_j());
                        drops.add(theDrop);
                        awardMessage = "mining " + block.func_149732_F() + " and " + (guaranteedDrop + extraDrop) + " extra " + ((ItemStack)drops.get(0)).func_82833_r() + " drop";
                        player.func_146105_b(new TextComponentString(Integer.toString(guaranteedDrop + extraDrop) + " Extra " + theDrop.func_82833_r() + " Dropped!").func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)), true);
                    }
                    XP.awardXp(player, "mining", awardMessage, award, false);
                } else {
                    XP.awardXp(player, "mining", "breaking " + block.func_149732_F(), award, false);
                }
            } else {
                String skill;
                String harvestTool;
                if (!wasPlaced) {
                    award += XP.getXp(block.getRegistryName()) * (float)drops.size();
                }
                if ((harvestTool = block.getHarvestTool(block.func_176223_P())) == null || !XP.correctHarvestTool(material).equals("none")) {
                    harvestTool = XP.correctHarvestTool(material);
                }
                if ((skill = XP.getSkill(harvestTool)) != "none") {
                    XP.awardXp(player, skill, "removing " + block.func_149732_F(), award, false);
                }
            }
        }
        PlacedBlocks.removeOre(event.getWorld(), event.getPos());
    }

    public static void handleBroken(BlockEvent.BreakEvent event) {
        EntityPlayer player;
        if (event.getPlayer() instanceof EntityPlayer && !(player = event.getPlayer()).func_184812_l_()) {
            NBTTagCompound persistTag = XP.getPersistTag(player);
            NBTTagCompound skillsTag = XP.getSkillsTag(persistTag);
            Block currBlock = event.getState().func_177230_c();
            boolean wasPlaced = PlacedBlocks.isPlayerPlaced(event.getWorld(), event.getPos());
            BlockReed reeds = Blocks.field_150436_aH;
            BlockCactus cactus = Blocks.field_150434_aF;
            if (currBlock.equals(reeds) || currBlock.equals(cactus)) {
                float hardness;
                int currLevel = XP.levelAtXp(skillsTag.func_74760_g("farming"));
                World world = event.getWorld();
                Block baseBlock = event.getState().func_177230_c();
                BlockPos baseBlockPos = event.getPos();
                try {
                    hardness = baseBlock.func_176195_g(baseBlock.func_176223_P(), event.getWorld(), event.getPos());
                    if (hardness > 50.0f) {
                        hardness = 50.0f;
                    }
                }
                catch (Exception e) {
                    hardness = 1.0f;
                }
                float award = 0.0f;
                float rewardable = 0.0f;
                float extraChance = XP.getPlantDoubleChance(baseBlock.getRegistryName()) * (float)currLevel;
                int guaranteedDrop = 0;
                int extraDrop = 0;
                if (extraChance / 100.0f > 1.0f) {
                    guaranteedDrop = (int)Math.floor(extraChance / 100.0f);
                    extraChance = (float)((double)(extraChance / 100.0f) - Math.floor(extraChance / 100.0f)) * 100.0f;
                }
                if (!wasPlaced) {
                    rewardable += 1.0f;
                }
                int height = 1;
                BlockPos currBlockPos = new BlockPos(baseBlockPos.func_177958_n(), baseBlockPos.func_177956_o() + height, baseBlockPos.func_177952_p());
                currBlock = world.func_180495_p(currBlockPos).func_177230_c();
                while (currBlock.equals(baseBlock)) {
                    wasPlaced = PlacedBlocks.isPlayerPlaced(world, currBlockPos);
                    if (!wasPlaced) {
                        rewardable += 1.0f;
                        if (Math.ceil(Math.random() * 1000.0) <= (double)(extraChance * 10.0f)) {
                            ++extraDrop;
                        }
                    }
                    currBlockPos = new BlockPos(baseBlockPos.func_177958_n(), baseBlockPos.func_177956_o() + ++height, baseBlockPos.func_177952_p());
                    currBlock = world.func_180495_p(currBlockPos).func_177230_c();
                }
                if (guaranteedDrop + extraDrop > 0) {
                    int dropsLeft;
                    for (dropsLeft = guaranteedDrop + extraDrop; dropsLeft > 64; dropsLeft -= 64) {
                        if (baseBlock == Blocks.field_150434_aF) {
                            Block.func_180635_a((World)event.getWorld(), (BlockPos)event.getPos(), (ItemStack)new ItemStack((Block)Blocks.field_150434_aF, dropsLeft));
                            continue;
                        }
                        Block.func_180635_a((World)event.getWorld(), (BlockPos)event.getPos(), (ItemStack)new ItemStack(Items.field_151120_aE, dropsLeft));
                    }
                    if (baseBlock == Blocks.field_150434_aF) {
                        Block.func_180635_a((World)event.getWorld(), (BlockPos)event.getPos(), (ItemStack)new ItemStack((Block)Blocks.field_150434_aF, dropsLeft));
                        player.func_146105_b(new TextComponentString(guaranteedDrop * height + extraDrop + " Extra Cactus Dropped!").func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)), true);
                    } else {
                        Block.func_180635_a((World)event.getWorld(), (BlockPos)event.getPos(), (ItemStack)new ItemStack(Items.field_151120_aE, dropsLeft));
                        player.func_146105_b(new TextComponentString(guaranteedDrop * height + extraDrop + " Extra Sugar Cane Dropped!").func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)), true);
                    }
                }
                XP.awardXp(player, "farming", "removing " + height + " + " + (guaranteedDrop + extraDrop) + " " + baseBlock.func_149732_F(), award += XP.getXp(baseBlock.getRegistryName()) * (rewardable + (float)guaranteedDrop + (float)extraDrop) + hardness * (rewardable + (float)guaranteedDrop + (float)extraDrop), false);
            }
        }
    }

    public static void handleDamage(LivingDamageEvent event) {
        EntityPlayer player;
        float damage;
        float startDmg = damage = event.getAmount();
        EntityLivingBase target = event.getEntityLiving();
        if (target instanceof EntityPlayer) {
            player = (EntityPlayer)target;
            NBTTagCompound persistTag = XP.getPersistTag(player);
            NBTTagCompound skillsTag = XP.getSkillsTag(persistTag);
            float agilityXp = 0.0f;
            float enduranceXp = 0.0f;
            boolean hideEndurance = false;
            int enduranceLevel = XP.levelAtXp(skillsTag.func_74760_g("endurance"));
            float endured = 0.0f;
            float endurePercent = (float)enduranceLevel * 0.25f;
            if (endurePercent > 50.0f) {
                endurePercent = 50.0f;
            }
            if ((endured = damage * (endurePercent / 100.0f)) < 0.0f) {
                endured = 0.0f;
            }
            enduranceXp = (damage -= endured) * 5.0f + endured * 10.0f;
            if (event.getSource().func_76355_l().equals("fall")) {
                float award = startDmg;
                int agilityLevel = XP.levelAtXp(skillsTag.func_74760_g("agility"));
                int saved = 0;
                float chance = (float)agilityLevel * 0.5f;
                if (chance > 64.0f) {
                    chance = 64.0f;
                }
                int i = 0;
                while ((float)i < damage) {
                    if (Math.ceil(Math.random() * 100.0) <= (double)chance) {
                        ++saved;
                    }
                    ++i;
                }
                damage -= (float)saved;
                if (saved != 0 && player.func_110143_aJ() > damage) {
                    player.func_146105_b((ITextComponent)new TextComponentString("Saved " + saved + " damage!"), true);
                }
                agilityXp = award = (float)(saved * 30);
            }
            event.setAmount(damage);
            if (player.func_110143_aJ() > damage) {
                if (agilityXp > 0.0f) {
                    hideEndurance = true;
                }
                if (event.getSource().func_76346_g() != null) {
                    XP.awardXp(player, "endurance", event.getSource().func_76346_g().func_70005_c_(), enduranceXp, hideEndurance);
                } else {
                    XP.awardXp(player, "endurance", event.getSource().func_76355_l(), enduranceXp, hideEndurance);
                }
                if (agilityXp > 0.0f) {
                    XP.awardXp(player, "agility", "surviving " + startDmg + " fall damage", agilityXp, false);
                }
            }
        }
        if (target instanceof EntityLivingBase && event.getSource().func_76346_g() instanceof EntityPlayer && !(player = (EntityPlayer)event.getSource().func_76346_g()).func_184812_l_()) {
            float amount = 0.0f;
            float playerHealth = player.func_110143_aJ();
            float targetHealth = target.func_110143_aJ();
            float targetMaxHealth = target.func_110138_aP();
            float lowHpBonus = 1.0f;
            if (damage > targetHealth) {
                damage = targetHealth;
            }
            amount += damage * 3.0f;
            if (startDmg >= targetHealth) {
                amount /= 2.0f;
            }
            if (startDmg >= targetMaxHealth) {
                amount = (float)((double)amount / 1.5);
            }
            if (target instanceof EntityAnimal) {
                amount /= 2.0f;
            } else if (playerHealth <= 10.0f) {
                lowHpBonus += (11.0f - playerHealth) / 5.0f;
                if (playerHealth <= 2.0f) {
                    lowHpBonus += 1.0f;
                }
            }
            damage = event.getAmount();
            if (event.getSource().field_76373_n.equals("arrow")) {
                double distance = event.getEntity().func_70011_f((double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p());
                distance = distance > 16.0 ? (distance -= 16.0) : 0.0;
                amount += (float)(Math.pow(distance, 1.25) * (double)(damage / target.func_110138_aP()) * (startDmg >= targetMaxHealth ? 1.5 : 1.0));
                XP.awardXp(player, "archery", player.func_184614_ca().func_82833_r(), amount *= lowHpBonus, false);
            } else {
                XP.awardXp(player, "combat", player.func_184614_ca().func_82833_r(), amount *= lowHpBonus, false);
            }
        }
    }

    public static void handleLivingJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            NBTTagCompound persistTag = XP.getPersistTag(player);
            NBTTagCompound skillsTag = XP.getSkillsTag(persistTag);
            double jumpBoost = 0.0;
            double agilityLevel = player.field_70170_p.field_72995_K ? (XPOverlayGUI.skills.get("agility") == null ? 1.0 : (double)XP.levelAtXp(XPOverlayGUI.skills.get((Object)"agility").xp)) : (double)XP.levelAtXp(skillsTag.func_74760_g("agility"));
            if (player.func_70093_af()) {
                jumpBoost = -0.011 + agilityLevel * 0.004242424242424243;
            }
            if (player.func_70051_ag()) {
                jumpBoost = -0.013 + agilityLevel * 0.0028000000000000004;
            }
            if (jumpBoost > 0.33) {
                jumpBoost = 0.33;
            }
            if (player.field_70170_p.field_72995_K) {
                if (jumpBoost > 0.0) {
                    event.getEntityLiving().field_70181_x += jumpBoost;
                }
            } else if (!player.func_70090_H()) {
                XP.awardXp(player, "agility", "jumping", (float)(jumpBoost * 10.0 + 1.0), true);
            }
        }
    }

    public static void handlePlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.player;
        AttributeHandler.updateReach(player);
        AttributeHandler.updateHP(player);
        AttributeHandler.updateDamage(player);
    }

    public static void handlePlayerConnected(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        NBTTagCompound persistTag = XP.getPersistTag(player);
        NBTTagCompound skillsTag = XP.getSkillsTag(persistTag);
        Set keySet = skillsTag.func_150296_c();
        if (lapisDonators.contains(player.getDisplayNameString())) {
            player.func_184102_h().func_184103_al().func_181057_v().forEach(thePlayer -> thePlayer.func_146105_b(new TextComponentString("Welcome, PMMO Lapis Tier Patreon " + player.getDisplayNameString() + "!").func_150255_a(new Style().func_150238_a(TextFormatting.BLUE)), false));
        } else if (dandelionDonators.contains(player.getDisplayNameString())) {
            player.func_146105_b(new TextComponentString("Welcome, PMMO Dandelion Tier Patreon " + player.getDisplayNameString() + "!").func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)), false);
        } else if (ironDonators.contains(player.getDisplayNameString())) {
            player.func_146105_b(new TextComponentString("Welcome, PMMO Iron Tier Patreon " + player.getDisplayNameString() + "!").func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)), false);
        }
        NetworkHandler.sendToPlayer(new MessageXp(0.0f, "CLEAR", 0.0f, true), (EntityPlayerMP)player);
        for (String tag : keySet) {
            NetworkHandler.sendToPlayer(new MessageXp(skillsTag.func_74760_g(tag), tag, 0.0f, true), (EntityPlayerMP)player);
        }
    }

    public static void handleRightClickItem(PlayerInteractEvent.RightClickItem event) {
    }

    public static void handleRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().field_72995_K) {
            EntityPlayer player = event.getEntityPlayer();
            NBTTagCompound persistTag = XP.getPersistTag(player);
            NBTTagCompound skillsTag = XP.getSkillsTag(persistTag);
            ItemStack itemStack = event.getItemStack();
            Item item = itemStack.func_77973_b();
            String itemDisplayName = itemStack.func_82833_r();
            Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
            Block anvil = Blocks.field_150467_bQ;
            Block ironBlock = Blocks.field_150339_S;
            Block goldBlock = Blocks.field_150340_R;
            Block diamondBlock = Blocks.field_150484_ah;
            if (player.func_70093_af()) {
                if (block.equals(ironBlock) || block.equals(anvil)) {
                    if (event.getHand() == EnumHand.MAIN_HAND) {
                        int currLevel;
                        float baseChance = 0.0f;
                        float extraChance = 0.0f;
                        if (XP.getPlantDoubleChance(item.getRegistryName()) != 0.0f && itemStack.func_77960_j() != 4) {
                            currLevel = XP.levelAtXp(skillsTag.func_74760_g("farming"));
                            baseChance = XP.getPlantDoubleChance(item.getRegistryName());
                            extraChance = baseChance * (float)currLevel;
                        } else if (XP.getOreDoubleChance(item.getRegistryName()) != 0.0f && itemStack.func_77960_j() != 3) {
                            currLevel = XP.levelAtXp(skillsTag.func_74760_g("mining"));
                            baseChance = XP.getOreDoubleChance(item.getRegistryName());
                            extraChance = baseChance * (float)currLevel;
                        }
                        if (item == Items.field_151100_aR && itemStack.func_77960_j() != 3 && itemStack.func_77960_j() != 4) {
                            return;
                        }
                        if (extraChance != 0.0f) {
                            player.func_146105_b((ITextComponent)new TextComponentString(itemStack.func_82833_r() + " " + DP.dp(Float.valueOf(extraChance)) + "% extra chance, " + DP.dp(Float.valueOf(baseChance)) + "% per level"), false);
                        }
                    } else {
                        return;
                    }
                }
                if ((block.equals(goldBlock) || block.equals(anvil)) && item.func_77645_m()) {
                    if (XP.getToolItem(item.getRegistryName()) != null) {
                        float enchantChance;
                        float valuePerLevel;
                        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
                        ItemStack salvageItemStack = XP.getToolItem(item.getRegistryName());
                        Item salvageItem = salvageItemStack.func_77973_b();
                        int currLevel = XP.levelAtXp(skillsTag.func_74760_g("repairing"));
                        float baseValue = XP.getSalvageBaseValue(salvageItem.getRegistryName());
                        float chance = baseValue + (valuePerLevel = XP.getSalvageValuePerLevel(salvageItem.getRegistryName())) * (float)currLevel;
                        if (chance > 80.0f) {
                            chance = 80.0f;
                        }
                        if ((enchantChance = (float)currLevel * 0.9f) > 90.0f) {
                            enchantChance = 90.0f;
                        }
                        int itemPotential = XP.getToolItemAmount(item.getRegistryName());
                        float startDmg = itemStack.func_77952_i();
                        float maxDmg = itemStack.func_77958_k();
                        float award = 0.0f;
                        float displayDurabilityPercent = (1.0f - startDmg / maxDmg) * 100.0f;
                        float durabilityPercent = 1.0f - startDmg / maxDmg;
                        int potentialReturnAmount = (int)Math.floor((float)itemPotential * durabilityPercent);
                        if (event.getHand() == EnumHand.OFF_HAND) {
                            if (!player.func_184812_l_()) {
                                int returnAmount = 0;
                                for (int i = 0; i < potentialReturnAmount; ++i) {
                                    if (!(Math.ceil(Math.random() * 100.0) <= (double)chance)) continue;
                                    ++returnAmount;
                                }
                                award += XP.getSalvageXp(salvageItem.getRegistryName()) * (float)returnAmount;
                                itemStack.func_77972_a(item.func_77612_l() * 10, (EntityLivingBase)player);
                                String replyMsg = "Salvaged " + returnAmount + "/" + itemPotential + " " + new ItemStack(salvageItem).func_82833_r();
                                replyMsg = replyMsg + (returnAmount > 1 && !salvageItem.equals(Items.field_151007_F) && !salvageItem.equals(Items.field_151116_aA) && !(salvageItem instanceof ItemBlock) ? "s" : "") + "!";
                                BlockPos spawnPos = event.getPos();
                                if (returnAmount > 0) {
                                    event.getWorld().func_72838_d((Entity)new EntityItem(event.getWorld(), (double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 1.0, (double)spawnPos.func_177952_p() + 0.5, new ItemStack(salvageItem, returnAmount)));
                                }
                                if (award > 0.0f) {
                                    XP.awardXp(player, "repairing", "salvaging " + returnAmount + "/" + itemPotential + " " + new ItemStack(salvageItem).func_82833_r() + " from salvaging " + itemDisplayName, award, false);
                                }
                                player.func_146105_b((ITextComponent)new TextComponentString(replyMsg), true);
                                if (enchants.size() > 0) {
                                    ItemStack salvagedBook = new ItemStack(Items.field_192397_db);
                                    Set enchantKeys = enchants.keySet();
                                    for (Enchantment enchant : enchantKeys) {
                                        int enchantLevel = 0;
                                        for (int i = 1; i <= (Integer)enchants.get(enchant); ++i) {
                                            if (Math.floor(Math.random() * 100.0) < (double)enchantChance) {
                                                enchantLevel = i;
                                                continue;
                                            }
                                            i = (Integer)enchants.get(enchant) + 1;
                                        }
                                        if (enchantLevel <= 0) continue;
                                        salvagedBook.func_77966_a(enchant, enchantLevel);
                                    }
                                    if (salvagedBook.func_77948_v()) {
                                        event.getWorld().func_72838_d((Entity)new EntityItem(event.getWorld(), (double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 1.0, (double)spawnPos.func_177952_p() + 0.5, salvagedBook));
                                        player.func_146105_b((ITextComponent)new TextComponentString("You managed to save some enchants!"), true);
                                    }
                                }
                            } else {
                                player.func_146105_b((ITextComponent)new TextComponentString("Only available in Survival Mode!"), true);
                            }
                        } else {
                            player.func_146105_b((ITextComponent)new TextComponentString("Off-Hand to Disassemble!"), true);
                            player.func_146105_b((ITextComponent)new TextComponentString("_________________________________"), false);
                            player.func_146105_b((ITextComponent)new TextComponentString(itemDisplayName + " " + DP.dp(Float.valueOf(displayDurabilityPercent)) + "%"), false);
                            player.func_146105_b((ITextComponent)new TextComponentString(DP.dp(Float.valueOf(chance)) + "% per material, " + potentialReturnAmount + " max items returned"), false);
                            player.func_146105_b((ITextComponent)new TextComponentString(DP.dp(Float.valueOf(enchantChance)) + "% enchant return, " + itemStack.func_82838_A() + " repair cost"), false);
                        }
                    } else {
                        player.func_146105_b((ITextComponent)new TextComponentString("UNACCOUNTED FOR DAMAGEABLE ITEM! Please Report!"), false);
                    }
                }
                if (block.equals(diamondBlock) && event.getHand() == EnumHand.MAIN_HAND) {
                    int agilityLevel = XP.levelAtXp(skillsTag.func_74760_g("agility"));
                    int enduranceLevel = XP.levelAtXp(skillsTag.func_74760_g("endurance"));
                    int combatLevel = XP.levelAtXp(skillsTag.func_74760_g("combat"));
                    int swimLevel = XP.levelAtXp(skillsTag.func_74760_g("swimming"));
                    double reach = AttributeHandler.getReach(player);
                    double agilityChance = (float)agilityLevel * 0.64f;
                    double damageReduction = (float)enduranceLevel * 0.25f;
                    double extraDamage = Math.floor(combatLevel / 20);
                    float speedPercent = (float)agilityLevel / 2000.0f;
                    if (agilityChance > 64.0) {
                        agilityChance = 64.0;
                    }
                    if (damageReduction > 50.0) {
                        damageReduction = 50.0;
                    }
                    if (speedPercent > 0.1f) {
                        speedPercent = 0.1f;
                    }
                    speedPercent = speedPercent / 0.1f * 100.0f;
                    player.func_146105_b((ITextComponent)new TextComponentString("_________________________________"), false);
                    player.func_146105_b((ITextComponent)new TextComponentString(DP.dp(reach) + " player reach"), false);
                    player.func_146105_b((ITextComponent)new TextComponentString(DP.dp(agilityChance) + "% fall damage save chance"), false);
                    player.func_146105_b((ITextComponent)new TextComponentString(DP.dp(damageReduction) + "% damage reduction"), false);
                    player.func_146105_b((ITextComponent)new TextComponentString(DP.dp(extraDamage) + " extra damage"), false);
                    player.func_146105_b((ITextComponent)new TextComponentString(DP.dp(Float.valueOf(speedPercent)) + "% sprint speed boost"), false);
                    if (swimLevel >= 25) {
                        player.func_146105_b((ITextComponent)new TextComponentString("Underwater night vision is unlocked!"), false);
                    } else {
                        player.func_146105_b((ITextComponent)new TextComponentString("Underwater night vision is locked until level 25 Swimming"), false);
                    }
                }
            }
        }
    }

    public static void handleAnvilRepair(AnvilRepairEvent event) {
        try {
            EntityPlayer player = event.getEntityPlayer();
            if (!player.field_70170_p.field_72995_K && event.getItemInput().func_77973_b().func_77645_m()) {
                float repaired;
                NBTTagCompound persistTag = XP.getPersistTag(player);
                NBTTagCompound skillsTag = XP.getSkillsTag(persistTag);
                int currLevel = XP.levelAtXp(skillsTag.func_74760_g("repairing"));
                float bonusRepair = 0.0025f * (float)currLevel / (1.0f + 0.01f * (float)currLevel);
                int maxCost = (int)Math.floor(50 - currLevel / 4);
                if (maxCost < 20) {
                    maxCost = 20;
                }
                event.setBreakChance(event.getBreakChance() / (1.0f + 0.01f * (float)currLevel));
                ItemStack lItem = event.getItemInput();
                ItemStack oItem = event.getItemResult();
                if (oItem.func_82838_A() > maxCost) {
                    oItem.func_82841_c(maxCost);
                }
                if ((repaired = (float)(oItem.func_77952_i() - lItem.func_77952_i())) < 0.0f) {
                    repaired = -repaired;
                }
                oItem.func_77964_b((int)Math.floor((float)oItem.func_77952_i() - repaired * bonusRepair));
                float award = (float)(((double)repaired + (double)(repaired * bonusRepair) * 2.5) / 100.0 * (1.0 + (double)lItem.func_82838_A() * 0.025));
                award *= XP.getRepairXp(XP.getToolItem(lItem.func_77973_b().getRegistryName()).func_77973_b().getRegistryName());
                if (award > 0.0f) {
                    player.func_146105_b((ITextComponent)new TextComponentString("repaired " + (int)repaired + " + " + (int)(repaired * bonusRepair) + " extra!"), true);
                    XP.awardXp(player, "repairing", "repairing " + oItem.func_82833_r() + " by: " + repaired, award, false);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void handleCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            XP.awardXp(event.player, "crafting", "crafting " + event.crafting.func_82833_r(), 10.0f, false);
        }
    }

    public static NBTTagCompound getPersistTag(EntityPlayer player) {
        NBTTagCompound playerNBT = player.getEntityData();
        NBTTagCompound persistTag = null;
        if (!playerNBT.func_74764_b("PlayerPersisted")) {
            persistTag = new NBTTagCompound();
            playerNBT.func_74782_a("PlayerPersisted", (NBTBase)persistTag);
        } else {
            persistTag = playerNBT.func_74775_l("PlayerPersisted");
        }
        return persistTag;
    }

    public static NBTTagCompound getSkillsTag(NBTTagCompound persistTag) {
        NBTTagCompound skillsTag = null;
        if (!persistTag.func_74764_b("skills")) {
            skillsTag = new NBTTagCompound();
            persistTag.func_74782_a("skills", (NBTBase)skillsTag);
        } else {
            skillsTag = persistTag.func_74775_l("skills");
        }
        return skillsTag;
    }

    public static void awardXp(EntityPlayer player, String skill, String sourceName, float amount, boolean skip) {
        int startLevel;
        if (player instanceof FakePlayer) {
            return;
        }
        if (amount <= 0.0f || player.field_70170_p.field_72995_K) {
            return;
        }
        if (!validSkills.contains(skill)) {
            System.out.println("INVALID SKILL");
            return;
        }
        if (skill.equals("combat") || skill.equals("archery") || skill.equals("endurance")) {
            switch (player.field_70170_p.func_175659_aa()) {
                case PEACEFUL: {
                    amount *= 0.33333334f;
                    break;
                }
                case EASY: {
                    amount *= 0.6666667f;
                    break;
                }
                case NORMAL: {
                    break;
                }
                case HARD: {
                    amount *= 1.3333334f;
                    break;
                }
            }
        }
        amount *= globalMultiplier;
        String playerName = player.func_70005_c_();
        float startXp = 0.0f;
        NBTTagCompound persistTag = XP.getPersistTag(player);
        NBTTagCompound skillsTag = XP.getSkillsTag(persistTag);
        if (!skillsTag.func_74764_b(skill)) {
            skillsTag.func_74776_a(skill, amount);
            startLevel = 1;
        } else {
            startLevel = XP.levelAtXp(skillsTag.func_74760_g(skill));
            startXp = skillsTag.func_74760_g(skill);
            if (startXp >= 2.0E9f) {
                return;
            }
            if (startXp + amount >= 2.0E9f) {
                player.func_146105_b(new TextComponentString(skill + " cap of 2b xp reached, you fucking psycho!").func_150255_a(new Style().func_150238_a(TextFormatting.LIGHT_PURPLE)), false);
                System.out.println(player.func_70005_c_() + " " + skill + " 2b cap reached");
                amount = 2.0E9f - startXp;
            }
            skillsTag.func_74776_a(skill, startXp + amount);
        }
        int currLevel = XP.levelAtXp(skillsTag.func_74760_g(skill));
        if (startLevel != currLevel) {
            switch (skill) {
                case "building": {
                    AttributeHandler.updateReach(player);
                    break;
                }
                case "endurance": {
                    AttributeHandler.updateHP(player);
                    break;
                }
                case "combat": {
                    AttributeHandler.updateDamage(player);
                    break;
                }
            }
            if (Loader.isModLoaded((String)"compatskills") && !player.field_70170_p.field_72995_K) {
                if (skill.equals("mining") || skill.equals("building") || skill.equals("farming") || skill.equals("agility")) {
                    player.func_184102_h().field_71321_q.func_71556_a((ICommandSender)player, "/reskillable incrementskill " + playerName + " reskillable." + skill + " 1");
                } else {
                    player.func_184102_h().field_71321_q.func_71556_a((ICommandSender)player, "/reskillable incrementskill " + playerName + " compatskills." + skill + " 1");
                }
            }
            System.out.println(player.func_70005_c_() + " " + currLevel + " " + skill + " level up!");
        }
        if (player instanceof EntityPlayerMP) {
            NetworkHandler.sendToPlayer(new MessageXp(startXp, skill, amount, skip), (EntityPlayerMP)player);
        }
        persistTag.func_74778_a("lastSkill", skill);
        System.out.println(playerName + " +" + amount + "xp in " + skill + " for " + sourceName + " total xp: " + skillsTag.func_74760_g(skill));
        if (startXp + amount >= maxXp && startXp <= maxXp) {
            player.func_146105_b(new TextComponentString(skill + " max level reached, you psycho!").func_150255_a(new Style().func_150238_a(TextFormatting.LIGHT_PURPLE)), false);
            System.out.println(player.func_70005_c_() + " " + skill + " max level reached");
        }
    }

    public static void setXp(EntityPlayer player, String skill, float newXp) {
        NBTTagCompound persistTag = XP.getPersistTag(player);
        NBTTagCompound skillsTag = XP.getSkillsTag(persistTag);
        skillsTag.func_74776_a(skill, newXp);
        switch (skill) {
            case "building": {
                AttributeHandler.updateReach(player);
                break;
            }
            case "endurance": {
                AttributeHandler.updateHP(player);
                break;
            }
            case "combat": {
                AttributeHandler.updateDamage(player);
                break;
            }
        }
        NetworkHandler.sendToPlayer(new MessageXp(newXp, skill, 0.0f, false), (EntityPlayerMP)player);
    }

    public static void handlePlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (!player.field_70170_p.field_72995_K) {
            long gap;
            String name = player.func_70005_c_();
            if (player.func_70051_ag()) {
                AttributeHandler.updateSpeed(player);
            } else {
                AttributeHandler.resetSpeed(player);
            }
            if (!lastAward.containsKey(name)) {
                lastAward.put(name, System.currentTimeMillis());
            }
            if (!player.func_184812_l_() && player.func_70089_S() && (gap = System.currentTimeMillis() - lastAward.get(name)) > 1000L) {
                NBTTagCompound persistTag = XP.getPersistTag(player);
                NBTTagCompound skillsTag = XP.getSkillsTag(persistTag);
                int swimLevel = XP.levelAtXp(skillsTag.func_74760_g("swimming"));
                int flyLevel = XP.levelAtXp(skillsTag.func_74760_g("flying"));
                int agilityLevel = XP.levelAtXp(skillsTag.func_74760_g("agility"));
                if (agilityLevel > 200) {
                    agilityLevel = 200;
                }
                float swimAward = (3.0f + (float)swimLevel / 10.0f) * (float)(gap / 1000L);
                float flyAward = (1.0f + (float)flyLevel / 30.77f) * (float)(gap / 1000L);
                float runAward = (1.0f + (float)agilityLevel / 30.77f) * (float)(gap / 1000L);
                lastAward.replace(name, System.currentTimeMillis());
                BlockStaticLiquid waterBlock = Blocks.field_150355_j;
                BlockPos playerPos = player.func_180425_c();
                boolean waterBelow = true;
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        if (player.func_130014_f_().func_180495_p(playerPos.func_177977_b().func_177965_g(i).func_177964_d(j)).func_177230_c().equals(waterBlock)) continue;
                        waterBelow = false;
                    }
                }
                boolean waterAbove = player.func_130014_f_().func_180495_p(playerPos.func_177984_a()).func_177230_c().equals(waterBlock);
                if (swimLevel >= 25 && player.func_70090_H() && waterAbove) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 250, 0, true, false));
                }
                if (player.func_70051_ag()) {
                    if (player.func_70090_H() && (waterAbove || waterBelow)) {
                        XP.awardXp(player, "swimming", "swimming fast", swimAward * 1.25f, true);
                    } else {
                        XP.awardXp(player, "agility", "running", runAward, true);
                    }
                }
                if (player.func_70090_H() && (waterAbove || waterBelow)) {
                    if (!player.func_70051_ag()) {
                        XP.awardXp(player, "swimming", "swimming", swimAward, true);
                    }
                } else if (player.func_184613_cA()) {
                    XP.awardXp(player, "flying", "flying", flyAward, true);
                }
                if (player.func_184187_bx() instanceof EntityBoat && player.func_191953_am()) {
                    XP.awardXp(player, "swimming", "swimming in a boat", swimAward / 5.0f, true);
                }
            }
        }
    }

    public static void handleFished(ItemFishedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        NonNullList items = event.getDrops();
        float award = XP.getXp(((ItemStack)items.get(0)).func_77973_b().getRegistryName());
        if (award == 0.0f) {
            award = 10.0f;
        }
        XP.awardXp(player, "fishing", "catching " + items, award, false);
    }

    public static void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        NBTTagCompound skills = XP.getSkillsTag(XP.getPersistTag(player));
        int mining = 1;
        int woodcutting = 1;
        int excavation = 1;
        if (player.field_70170_p.field_72995_K) {
            if (XPOverlayGUI.skills.get("mining") != null) {
                mining = XP.levelAtXp(XPOverlayGUI.skills.get((Object)"mining").xp);
            }
            if (XPOverlayGUI.skills.get("woodcutting") != null) {
                woodcutting = XP.levelAtXp(XPOverlayGUI.skills.get((Object)"woodcutting").xp);
            }
            if (XPOverlayGUI.skills.get("excavation") != null) {
                excavation = XP.levelAtXp(XPOverlayGUI.skills.get((Object)"excavation").xp);
            }
        } else {
            mining = XP.levelAtXp(skills.func_74760_g("mining"));
            woodcutting = XP.levelAtXp(skills.func_74760_g("woodcutting"));
            excavation = XP.levelAtXp(skills.func_74760_g("excavation"));
        }
        switch (XP.correctHarvestTool(event.getState().func_185904_a())) {
            case "pickaxe": {
                float heightMultiplier;
                float height = event.getPos().func_177956_o();
                if (height < 0.0f) {
                    height = -height;
                }
                if ((heightMultiplier = 1.0f - height / 1000.0f) < 0.5f) {
                    heightMultiplier = 0.5f;
                }
                event.setNewSpeed(event.getOriginalSpeed() * (1.0f + (float)mining * 0.01f) * heightMultiplier);
                break;
            }
            case "axe": {
                event.setNewSpeed(event.getOriginalSpeed() * (1.0f + (float)woodcutting * 0.01f));
                break;
            }
            case "shovel": {
                event.setNewSpeed(event.getOriginalSpeed() * (1.0f + (float)excavation * 0.01f));
                break;
            }
            default: {
                event.setNewSpeed(event.getOriginalSpeed());
            }
        }
    }

    public static int levelAtXp(float xp) {
        int theXp = 0;
        int level = 0;
        while (!(xp < (float)theXp) && level < 999) {
            theXp = (int)((float)theXp + (250.0f + (float)level * 50.0f));
            ++level;
        }
        return level;
    }

    public static float levelAtXpDecimal(float xp) {
        int goalXp;
        int startLevel;
        int startXp;
        if (XP.levelAtXp(xp) == 999) {
            xp = XP.xpAtLevel(999.0f);
        }
        if ((startXp = XP.xpAtLevel(startLevel = XP.levelAtXp(xp))) == (goalXp = XP.xpAtLevel(startLevel + 1))) {
            return 999.99f;
        }
        return (float)startLevel + (xp - (float)startXp) / (float)(goalXp - startXp);
    }

    public static int xpAtLevel(float givenLevel) {
        int theXp = 0;
        if (givenLevel > 999.0f) {
            givenLevel = 999.0f;
        }
        int level = 1;
        while ((float)level < givenLevel) {
            theXp = (int)((float)theXp + (250.0f + (float)(level - 1) * 50.0f));
            ++level;
        }
        return theXp;
    }

    public static float xpAtLevelDecimal(float givenLevel) {
        float startXp = XP.xpAtLevel((float)Math.floor(givenLevel));
        float endXp = XP.xpAtLevel((float)Math.floor(givenLevel + 1.0f));
        float pos = givenLevel - (float)Math.floor(givenLevel);
        return startXp + (endXp - startXp) * pos;
    }
}

