/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rareice.forge;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import me.shedaniel.rareice.forge.blocks.RareIceBlock;
import me.shedaniel.rareice.forge.blocks.entities.RareIceTileEntity;
import me.shedaniel.rareice.forge.world.gen.feature.RareIceConfig;
import me.shedaniel.rareice.forge.world.gen.feature.RareIceFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.DecoratorConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RangeDecoratorConfiguration;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.placement.FeatureDecorator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="rare_ice")
public class RareIce {
    public static final DeferredRegister<BlockEntityType<?>> TILE_ENTITY_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"rare-ice");
    public static final DeferredRegister<Block> BLOCK_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"rare-ice");
    public static final DeferredRegister<Feature<?>> FEATURE_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"rare-ice");
    public static final RegistryObject<Block> RARE_ICE_BLOCK = BLOCK_REGISTRY.register("rare_ice", () -> new RareIceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50126_).m_60922_((state, world, pos, type) -> type == EntityType.f_20514_)));
    public static final RegistryObject<BlockEntityType<RareIceTileEntity>> RARE_ICE_TILE_ENTITY_TYPE = TILE_ENTITY_REGISTRY.register("rare_ice", () -> BlockEntityType.Builder.m_155273_(RareIceTileEntity::new, (Block[])new Block[]{(Block)RARE_ICE_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<Feature<RareIceConfig>> RARE_ICE_FEATURE = FEATURE_REGISTRY.register("rare_ice", () -> new RareIceFeature(RareIceConfig.CODEC));
    public static ConfiguredFeature<?, ?> configuredFeature;
    public static boolean allowInsertingItemsToIce;
    public static int probabilityOfRareIce;

    private static void loadConfig(Path file) {
        allowInsertingItemsToIce = true;
        probabilityOfRareIce = 3;
        if (Files.exists(file, new LinkOption[0])) {
            try {
                Properties properties = new Properties();
                properties.load(Files.newBufferedReader(file));
                allowInsertingItemsToIce = properties.getProperty("allowInsertingItemsToIce", "true").equals("true");
                probabilityOfRareIce = Integer.parseInt(properties.getProperty("probabilityOfRareIce", "3"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        RareIce.saveConfig(file);
    }

    private static void saveConfig(Path file) {
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Properties properties = new Properties();
            properties.setProperty("allowInsertingItemsToIce", String.valueOf(allowInsertingItemsToIce));
            properties.setProperty("probabilityOfRareIce", String.valueOf(probabilityOfRareIce));
            properties.store(Files.newBufferedWriter(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE), "Rare Ice Configuration");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RareIce() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCK_REGISTRY.register(bus);
        TILE_ENTITY_REGISTRY.register(bus);
        FEATURE_REGISTRY.register(bus);
        bus.addListener(RareIce::onCommonSetup);
        MinecraftForge.EVENT_BUS.addListener(RareIce::rightClickBlock);
        MinecraftForge.EVENT_BUS.addListener(RareIce::modifyBiome);
    }

    public static void onCommonSetup(FMLCommonSetupEvent event) {
        RareIce.loadConfig(FMLPaths.CONFIGDIR.get().resolve("rare-ice.properties"));
        configuredFeature = (ConfiguredFeature)((ConfiguredFeature)((Feature)RARE_ICE_FEATURE.get()).m_65815_((FeatureConfiguration)RareIceConfig.DEFAULT).m_7679_(FeatureDecorator.f_70692_.m_70720_((DecoratorConfiguration)new RangeDecoratorConfiguration((HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158930_((int)32), (VerticalAnchor)VerticalAnchor.m_158935_((int)32))))).m_64152_()).m_64158_(probabilityOfRareIce);
        Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)new ResourceLocation("rare-ice:rare-ice"), configuredFeature);
    }

    public static void modifyBiome(BiomeLoadingEvent event) {
        event.getGeneration().m_47842_(GenerationStep.Decoration.UNDERGROUND_ORES, configuredFeature);
    }

    private static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!allowInsertingItemsToIce) {
            return;
        }
        Player player = event.getPlayer();
        if (player.m_6144_()) {
            return;
        }
        BlockPos pos = event.getPos();
        Level world = event.getWorld();
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() == Blocks.f_50126_ || state.m_60734_() == RARE_ICE_BLOCK.get()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity == null) {
                world.m_46597_(pos, ((Block)RARE_ICE_BLOCK.get()).m_49966_());
                blockEntity = world.m_7702_(pos);
            }
            if (blockEntity instanceof RareIceTileEntity) {
                RareIceTileEntity rareIceBlockEntity = (RareIceTileEntity)blockEntity;
                ItemStack itemStack = player.m_21120_(event.getHand());
                itemStack = player.m_150110_().f_35937_ ? itemStack.m_41777_() : itemStack;
                InteractionResult type = rareIceBlockEntity.addItem(world, itemStack, player, event.getSide().isServer());
                if (type != InteractionResult.PASS) {
                    event.setCanceled(true);
                }
                event.setCancellationResult(type);
            }
        }
    }

    static {
        allowInsertingItemsToIce = true;
        probabilityOfRareIce = 3;
    }
}

