/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rareice.forge.loot;

import com.google.common.collect.ImmutableList;
import com.mojang.realmsclient.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;

public class LootGenerator {
    private static final List<Pair<Pair<Integer, Integer>, List<Entry>>> LOOT = new ArrayList<Pair<Pair<Integer, Integer>, List<Entry>>>();

    public static void register(int min, int max, Consumer<Builder> builderConsumer) {
        ArrayList<Entry> items = new ArrayList<Entry>();
        Builder builder = new Builder(items);
        builderConsumer.accept(builder);
        LOOT.add((Pair<Pair<Integer, Integer>, List<Entry>>)Pair.of((Object)Pair.of((Object)min, (Object)(max == min ? null : Integer.valueOf(max))), items));
    }

    public static List<ItemStack> generate(Random random) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Pair<Pair<Integer, Integer>, List<Entry>> pair : LOOT) {
            int count = (Integer)((Pair)pair.first()).first() + (((Pair)pair.first()).second() != null ? random.nextInt((Integer)((Pair)pair.first()).second() - (Integer)((Pair)pair.first()).first()) : 0);
            for (int i = 0; i < count; ++i) {
                Entry entry = (Entry)WeightedRandom.func_76271_a((Random)random, (List)((List)pair.second()));
                builder.add((Object)entry.getStack(random));
            }
        }
        return builder.build();
    }

    static {
        LootGenerator.register(1, 2, builder -> {
            builder.add(new Item[]{Items.field_151148_bJ});
            builder.add(2, Items.field_151166_bC, Items.field_151045_i, Items.field_179563_cD, Items.field_151042_j, Items.field_151043_k);
            builder.add(3, Items.field_151044_h);
        });
        LootGenerator.register(1, 1, builder -> {
            builder.addBroken((Item)Items.field_151028_Y, 70, 100);
            builder.addBroken((Item)Items.field_151022_W, 70, 100);
            builder.addBroken((Item)Items.field_151027_R, 70, 100);
            builder.addBroken((Item)Items.field_151151_aj, 70, 100);
            builder.addBroken((Item)Items.field_151021_T, 70, 100);
            builder.addBroken((Item)Items.field_151149_ai, 70, 100);
            builder.addBroken((Item)Items.field_151171_ah, 70, 100);
            builder.addBroken(Items.field_151005_D, 70, 100);
            builder.addBroken(Items.field_151010_B, 70, 100);
            builder.addBroken(Items.field_151046_w, 30, 60);
            builder.addBroken(Items.field_151035_b, 30, 70);
            builder.addBroken(Items.field_151040_l, 30, 70);
            builder.addBroken(Items.field_151050_s, 20, 100);
            builder.addBroken(Items.field_151052_q, 20, 100);
            builder.addBroken(Items.field_151041_m, 20, 100);
        });
        LootGenerator.register(0, 1, builder -> builder.add(Items.field_151115_aP));
    }

    public static class Entry
    extends WeightedRandom.Item {
        private final Function<Random, ItemStack> stack;

        public Entry(int itemWeightIn, ItemStack stack) {
            this(itemWeightIn, () -> ((ItemStack)stack).func_77946_l());
        }

        public Entry(int itemWeightIn, Supplier<ItemStack> stack) {
            this(itemWeightIn, (Random random) -> (ItemStack)stack.get());
        }

        public Entry(int itemWeightIn, Function<Random, ItemStack> stack) {
            super(itemWeightIn);
            this.stack = stack;
        }

        public ItemStack getStack(Random random) {
            return this.stack.apply(random);
        }
    }

    public static class Builder {
        private List<Entry> items;

        public Builder(List<Entry> items) {
            this.items = items;
        }

        public void add(int weight, Item item) {
            this.items.add(new Entry(weight, new ItemStack(item)));
        }

        public void add(int weight, Item ... items) {
            for (Item item : items) {
                this.add(weight, item);
            }
        }

        public void add(int weight, Block block) {
            this.items.add(new Entry(weight, new ItemStack(block)));
        }

        public void add(int weight, Block ... blocks) {
            for (Block block : blocks) {
                this.add(weight, block);
            }
        }

        public void add(int weight, ItemStack stack) {
            this.items.add(new Entry(weight, stack));
        }

        public void add(int weight, ItemStack ... stacks) {
            for (ItemStack stack : stacks) {
                this.add(weight, stack);
            }
        }

        public void add(int weight, Supplier<ItemStack> stack) {
            this.items.add(new Entry(weight, stack));
        }

        @SafeVarargs
        public final void add(int weight, Supplier<ItemStack> ... stacks) {
            for (Supplier<ItemStack> stack : stacks) {
                this.add(weight, stack);
            }
        }

        public void add(int weight, Function<Random, ItemStack> stack) {
            this.items.add(new Entry(weight, stack));
        }

        @SafeVarargs
        public final void add(int weight, Function<Random, ItemStack> ... stacks) {
            for (Function<Random, ItemStack> stack : stacks) {
                this.add(weight, stack);
            }
        }

        public void add(Item ... items) {
            this.add(1, items);
        }

        public void add(Block ... blocks) {
            this.add(1, blocks);
        }

        public void add(ItemStack ... stacks) {
            this.add(1, stacks);
        }

        @SafeVarargs
        public final void add(Supplier<ItemStack> ... stacks) {
            this.add(1, stacks);
        }

        @SafeVarargs
        public final void add(Function<Random, ItemStack> ... stacks) {
            this.add(1, stacks);
        }

        public final void addBroken(int weight, Item item, int min, int max) {
            this.add(weight, (Random random) -> {
                ItemStack stack = new ItemStack(item);
                stack.func_77964_b((int)((float)stack.func_77958_k() * (1.0f - (float)(random.nextInt(max - min) + min) / 100.0f)));
                return stack;
            });
        }

        public final void addBroken(Item item, int min, int max) {
            this.addBroken(1, item, min, max);
        }
    }
}

