/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.screen.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1715;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3917;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.client.screen.builder.ExtendedScreenHandlerListener;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.util.ItemUtils;
import reborncore.mixin.common.AccessorScreenHandler;

public class BuiltScreenHandler
extends class_1703
implements ExtendedScreenHandlerListener {
    private final String name;
    private final Predicate<class_1657> canInteract;
    private final List<Range<Integer>> playerSlotRanges;
    private final List<Range<Integer>> blockEntitySlotRanges;
    private final ArrayList<MutableTriple<IntSupplier, IntConsumer, Short>> shortValues;
    private final ArrayList<MutableTriple<IntSupplier, IntConsumer, Integer>> integerValues;
    private final ArrayList<MutableTriple<Supplier, Consumer, Object>> objectValues;
    private List<Consumer<class_1715>> craftEvents;
    private Integer[] integerParts;
    private final MachineBaseBlockEntity blockEntity;
    class_3917<BuiltScreenHandler> type = null;

    public BuiltScreenHandler(int syncID, String name, Predicate<class_1657> canInteract, List<Range<Integer>> playerSlotRange, List<Range<Integer>> blockEntitySlotRange, MachineBaseBlockEntity blockEntity) {
        super(null, syncID);
        this.name = name;
        this.canInteract = canInteract;
        this.playerSlotRanges = playerSlotRange;
        this.blockEntitySlotRanges = blockEntitySlotRange;
        this.shortValues = new ArrayList();
        this.integerValues = new ArrayList();
        this.objectValues = new ArrayList();
        this.blockEntity = blockEntity;
    }

    public void addShortSync(List<Pair<IntSupplier, IntConsumer>> syncables) {
        for (Pair<IntSupplier, IntConsumer> syncable : syncables) {
            this.shortValues.add((MutableTriple<IntSupplier, IntConsumer, Short>)MutableTriple.of((Object)syncable.getLeft(), (Object)syncable.getRight(), (Object)0));
        }
        this.shortValues.trimToSize();
    }

    public void addIntegerSync(List<Pair<IntSupplier, IntConsumer>> syncables) {
        for (Pair<IntSupplier, IntConsumer> syncable : syncables) {
            this.integerValues.add((MutableTriple<IntSupplier, IntConsumer, Integer>)MutableTriple.of((Object)syncable.getLeft(), (Object)syncable.getRight(), (Object)0));
        }
        this.integerValues.trimToSize();
        this.integerParts = new Integer[this.integerValues.size()];
    }

    public void addObjectSync(List<Pair<Supplier, Consumer>> syncables) {
        for (Pair<Supplier, Consumer> syncable : syncables) {
            this.objectValues.add((MutableTriple<Supplier, Consumer, Object>)MutableTriple.of((Object)syncable.getLeft(), (Object)syncable.getRight(), null));
        }
        this.objectValues.trimToSize();
    }

    public void addCraftEvents(List<Consumer<class_1715>> craftEvents) {
        this.craftEvents = craftEvents;
    }

    public boolean method_7597(class_1657 playerIn) {
        return this.canInteract.test(playerIn);
    }

    public final void method_7609(class_1263 inv) {
        if (!this.craftEvents.isEmpty()) {
            this.craftEvents.forEach(consumer -> consumer.accept((class_1715)inv));
        }
    }

    public void method_7623() {
        super.method_7623();
        for (class_1712 listener : ((AccessorScreenHandler)((Object)this)).getListeners()) {
            int supplied;
            int i = 0;
            if (!this.shortValues.isEmpty()) {
                for (MutableTriple<IntSupplier, IntConsumer, Short> mutableTriple : this.shortValues) {
                    supplied = ((IntSupplier)mutableTriple.getLeft()).getAsInt();
                    if (supplied != (Short)mutableTriple.getRight()) {
                        listener.method_7633((class_1703)this, i, supplied);
                        mutableTriple.setRight((Object)((short)supplied));
                    }
                    ++i;
                }
            }
            if (!this.integerValues.isEmpty()) {
                for (MutableTriple mutableTriple : this.integerValues) {
                    supplied = ((IntSupplier)mutableTriple.getLeft()).getAsInt();
                    if (supplied != (Integer)mutableTriple.getRight()) {
                        listener.method_7633((class_1703)this, i, supplied >> 16);
                        listener.method_7633((class_1703)this, i + 1, (int)((short)(supplied & 0xFFFF)));
                        mutableTriple.setRight((Object)supplied);
                    }
                    i += 2;
                }
            }
            if (this.objectValues.isEmpty()) continue;
            int objects = 0;
            for (MutableTriple<Supplier, Consumer, Object> value : this.objectValues) {
                Object supplied2 = ((Supplier)value.getLeft()).get();
                if (supplied2 != value.getRight()) {
                    this.sendObject(listener, this, objects, supplied2);
                    value.setRight(supplied2);
                }
                ++objects;
            }
        }
    }

    public void method_7596(class_1712 listener) {
        super.method_7596(listener);
        int i = 0;
        if (!this.shortValues.isEmpty()) {
            for (MutableTriple<IntSupplier, IntConsumer, Short> mutableTriple : this.shortValues) {
                short s = (short)((IntSupplier)mutableTriple.getLeft()).getAsInt();
                listener.method_7633((class_1703)this, i, (int)s);
                mutableTriple.setRight((Object)s);
                ++i;
            }
        }
        if (!this.integerValues.isEmpty()) {
            for (MutableTriple mutableTriple : this.integerValues) {
                int n = ((IntSupplier)mutableTriple.getLeft()).getAsInt();
                listener.method_7633((class_1703)this, i, n >> 16);
                listener.method_7633((class_1703)this, i + 1, (int)((short)(n & 0xFFFF)));
                mutableTriple.setRight((Object)n);
                i += 2;
            }
        }
        if (!this.objectValues.isEmpty()) {
            int objects = 0;
            for (MutableTriple<Supplier, Consumer, Object> mutableTriple : this.objectValues) {
                Object supplied2 = mutableTriple.getLeft();
                this.sendObject(listener, this, objects, ((Supplier)supplied2).get());
                mutableTriple.setRight(supplied2);
                ++objects;
            }
        }
    }

    @Override
    public void handleObject(int var, Object value) {
        ((Consumer)this.objectValues.get(var).getMiddle()).accept(value);
    }

    public void method_7606(int id, int value) {
        if (id < this.shortValues.size()) {
            ((IntConsumer)this.shortValues.get(id).getMiddle()).accept((short)value);
            this.shortValues.get(id).setRight((Object)((short)value));
        } else if (id - this.shortValues.size() < this.integerValues.size() * 2) {
            if ((id - this.shortValues.size()) % 2 == 0) {
                this.integerParts[(id - this.shortValues.size()) / 2] = value;
            } else {
                ((IntConsumer)this.integerValues.get((id - this.shortValues.size()) / 2).getMiddle()).accept((this.integerParts[(id - this.shortValues.size()) / 2] & 0xFFFF) << 16 | value & 0xFFFF);
            }
        }
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 originalStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 stackInSlot = slot.method_7677();
            originalStack = stackInSlot.method_7972();
            boolean shifted = false;
            for (Range<Integer> range : this.playerSlotRanges) {
                if (!range.contains((Object)index)) continue;
                if (!this.shiftToBlockEntity(stackInSlot)) break;
                shifted = true;
                break;
            }
            if (!shifted) {
                for (Range<Integer> range : this.blockEntitySlotRanges) {
                    if (!range.contains((Object)index)) continue;
                    if (!this.shiftToPlayer(stackInSlot)) break;
                    shifted = true;
                    break;
                }
            }
            slot.method_7670(stackInSlot, originalStack);
            if (stackInSlot.method_7947() <= 0) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (stackInSlot.method_7947() == originalStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, stackInSlot);
        }
        return originalStack;
    }

    protected boolean shiftItemStack(class_1799 stackToShift, int start, int end) {
        class_1799 stackInSlot;
        class_1735 slot;
        int slotIndex;
        boolean changed = false;
        if (stackToShift.method_7946()) {
            for (slotIndex = start; stackToShift.method_7947() > 0 && slotIndex < end; ++slotIndex) {
                int max;
                slot = (class_1735)this.field_7761.get(slotIndex);
                stackInSlot = slot.method_7677();
                if (stackInSlot.method_7960() || !ItemUtils.isItemEqual(stackInSlot, stackToShift, true, true) || !slot.method_7680(stackToShift)) continue;
                int resultingStackSize = stackInSlot.method_7947() + stackToShift.method_7947();
                if (resultingStackSize <= (max = Math.min(stackToShift.method_7914(), slot.method_7675()))) {
                    stackToShift.method_7939(0);
                    stackInSlot.method_7939(resultingStackSize);
                    slot.method_7668();
                    changed = true;
                    continue;
                }
                if (stackInSlot.method_7947() >= max) continue;
                stackToShift.method_7934(max - stackInSlot.method_7947());
                stackInSlot.method_7939(max);
                slot.method_7668();
                changed = true;
            }
        }
        if (stackToShift.method_7947() > 0) {
            for (slotIndex = start; stackToShift.method_7947() > 0 && slotIndex < end; ++slotIndex) {
                slot = (class_1735)this.field_7761.get(slotIndex);
                stackInSlot = slot.method_7677();
                if (!stackInSlot.method_7960() || !slot.method_7680(stackToShift)) continue;
                int max = Math.min(stackToShift.method_7914(), slot.method_7675());
                stackInSlot = stackToShift.method_7972();
                stackInSlot.method_7939(Math.min(stackToShift.method_7947(), max));
                stackToShift.method_7934(stackInSlot.method_7947());
                slot.method_7673(stackInSlot);
                slot.method_7668();
                changed = true;
            }
        }
        return changed;
    }

    private boolean shiftToBlockEntity(class_1799 stackToShift) {
        if (!this.blockEntity.getOptionalInventory().isPresent()) {
            return false;
        }
        for (Range<Integer> range : this.blockEntitySlotRanges) {
            if (!this.shiftItemStack(stackToShift, (Integer)range.getMinimum(), (Integer)range.getMaximum() + 1)) continue;
            return true;
        }
        return false;
    }

    private boolean shiftToPlayer(class_1799 stackToShift) {
        for (Range<Integer> range : this.playerSlotRanges) {
            if (!this.shiftItemStack(stackToShift, (Integer)range.getMinimum(), (Integer)range.getMaximum() + 1)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public class_1735 method_7621(class_1735 slotIn) {
        return super.method_7621(slotIn);
    }

    public MachineBaseBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public class_2338 getPos() {
        return this.getBlockEntity().method_11016();
    }

    public void setType(class_3917<BuiltScreenHandler> type) {
        this.type = type;
    }

    public class_3917<BuiltScreenHandler> method_17358() {
        return this.type;
    }
}

