/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.blockentity;

import java.util.Random;
import java.util.function.BiPredicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_776;
import net.minecraft.class_809;

public interface MultiblockWriter {
    public MultiblockWriter add(int var1, int var2, int var3, BiPredicate<class_1922, class_2338> var4, class_2680 var5);

    default public MultiblockWriter fill(int ax, int ay, int az, int bx, int by, int bz, BiPredicate<class_1922, class_2338> predicate, class_2680 state) {
        for (int x = ax; x < bx; ++x) {
            for (int y = ay; y < by; ++y) {
                for (int z = az; z < bz; ++z) {
                    this.add(x, y, z, predicate, state);
                }
            }
        }
        return this;
    }

    default public MultiblockWriter ring(class_2350.class_2351 through, int pX, int pY, int pZ, BiPredicate<class_1922, class_2338> predicate, class_2680 state, BiPredicate<class_1922, class_2338> holePredicate, class_2680 holeHologramState) {
        block12: {
            block13: {
                block11: {
                    if (holePredicate == null) {
                        holePredicate = predicate.negate();
                    }
                    if (holeHologramState == null) {
                        holeHologramState = class_2246.field_10124.method_9564();
                    }
                    if (through != class_2350.class_2351.field_11048) break block11;
                    for (int y = 0; y < pY; ++y) {
                        for (int z = 0; z < pZ; ++z) {
                            if (y == 0 || y == pY - 1 || z == 0 || z == pZ - 1) {
                                this.add(pX, y, z, predicate, state);
                                continue;
                            }
                            this.add(pX, y, z, holePredicate, holeHologramState);
                        }
                    }
                    break block12;
                }
                if (through != class_2350.class_2351.field_11052) break block13;
                for (int x = 0; x < pX; ++x) {
                    for (int z = 0; z < pZ; ++z) {
                        if (x == 0 || x == pX - 1 || z == 0 || z == pZ - 1) {
                            this.add(x, pY, z, predicate, state);
                            continue;
                        }
                        this.add(x, pY, z, holePredicate, holeHologramState);
                    }
                }
                break block12;
            }
            if (through != class_2350.class_2351.field_11051) break block12;
            for (int x = 0; x < pX; ++x) {
                for (int y = 0; y < pY; ++y) {
                    if (x == 0 || x == pX - 1 || y == 0 || y == pY - 1) {
                        this.add(x, y, pZ, predicate, state);
                        continue;
                    }
                    this.add(x, y, pZ, holePredicate, holeHologramState);
                }
            }
        }
        return this;
    }

    default public MultiblockWriter ringWithAir(class_2350.class_2351 through, int x, int y, int z, BiPredicate<class_1922, class_2338> predicate, class_2680 state) {
        return this.ring(through, x, y, z, predicate, state, (view, pos) -> view.method_8320(pos).method_26204() == class_2246.field_10124, class_2246.field_10124.method_9564());
    }

    default public MultiblockWriter add(int x, int y, int z, class_2680 state) {
        return this.add(x, y, z, (view, pos) -> view.method_8320(pos) == state, state);
    }

    default public MultiblockWriter fill(int ax, int ay, int az, int bx, int by, int bz, class_2680 state) {
        return this.fill(ax, ay, az, bx, by, bz, (view, pos) -> view.method_8320(pos) == state, state);
    }

    default public MultiblockWriter ring(class_2350.class_2351 through, int x, int y, int z, class_2680 state, class_2680 holeState) {
        return this.ring(through, x, y, z, (view, pos) -> view.method_8320(pos) == state, state, (view, pos) -> view.method_8320(pos) == holeState, holeState);
    }

    default public MultiblockWriter ringWithAir(class_2350.class_2351 through, int x, int y, int z, class_2680 state) {
        return this.ringWithAir(through, x, y, z, (view, pos) -> view.method_8320(pos) == state, state);
    }

    default public MultiblockWriter translate(int offsetX, int offsetY, int offsetZ) {
        return (x, y, z, predicate, state) -> this.add(offsetX + x, offsetY + y, offsetZ + z, predicate, state);
    }

    default public MultiblockWriter rotate() {
        return (x, y, z, predicate, state) -> this.add(-z, y, x, predicate, state);
    }

    default public MultiblockWriter rotate(class_2350 direction) {
        MultiblockWriter w = this;
        switch (direction) {
            case field_11043: {
                w = w.rotate();
            }
            case field_11039: {
                w = w.rotate();
            }
            case field_11035: {
                w = w.rotate();
            }
        }
        return w;
    }

    @Environment(value=EnvType.CLIENT)
    public static class HologramRenderer
    implements MultiblockWriter {
        private static final class_2338 OUT_OF_WORLD_POS = new class_2338(0, 260, 0);
        private final class_1920 view;
        private final class_4587 matrix;
        private final class_4597 vertexConsumerProvider;
        private final float scale;

        public HologramRenderer(class_1920 view, class_4587 matrix, class_4597 vertexConsumerProvider, float scale) {
            this.view = view;
            this.matrix = matrix;
            this.vertexConsumerProvider = vertexConsumerProvider;
            this.scale = scale;
        }

        @Override
        public MultiblockWriter add(int x, int y, int z, BiPredicate<class_1922, class_2338> predicate, class_2680 state) {
            class_776 blockRenderManager = class_310.method_1551().method_1541();
            this.matrix.method_22903();
            this.matrix.method_22904((double)x, (double)y, (double)z);
            this.matrix.method_22904(0.5, 0.5, 0.5);
            this.matrix.method_22905(this.scale, this.scale, this.scale);
            if (state.method_26204() instanceof class_2404) {
                class_3610 fluidState = ((class_2404)state.method_26204()).method_9545(state);
                class_310.method_1551().method_1480().method_23178(new class_1799((class_1935)fluidState.method_15772().method_15774()), class_809.class_811.field_4319, 0xF000F0, class_4608.field_21444, this.matrix, this.vertexConsumerProvider);
            } else {
                this.matrix.method_22904(-0.5, -0.5, -0.5);
                class_4588 consumer = this.vertexConsumerProvider.getBuffer(class_4696.method_23679((class_2680)state));
                blockRenderManager.method_3355(state, OUT_OF_WORLD_POS, this.view, this.matrix, consumer, false, new Random());
            }
            this.matrix.method_22909();
            return this;
        }
    }

    public static class MultiblockVerifier
    implements MultiblockWriter {
        private final class_2338 relative;
        private final class_1922 view;
        private boolean valid = true;

        public MultiblockVerifier(class_2338 relative, class_1922 view) {
            this.relative = relative;
            this.view = view;
        }

        public boolean isValid() {
            return this.valid;
        }

        @Override
        public MultiblockWriter add(int x, int y, int z, BiPredicate<class_1922, class_2338> predicate, class_2680 state) {
            if (this.valid) {
                this.valid = predicate.test(this.view, this.relative.method_10069(x, y, z));
            }
            return this;
        }
    }

    public static class DebugWriter
    implements MultiblockWriter {
        private final MultiblockWriter writer;

        public DebugWriter(MultiblockWriter writer) {
            this.writer = writer;
        }

        @Override
        public MultiblockWriter add(int x, int y, int z, BiPredicate<class_1922, class_2338> predicate, class_2680 state) {
            System.out.printf("\t%d\t%d\t%d\t%s\n", x, y, z, state.method_26204());
            if (this.writer != null) {
                this.writer.add(x, y, z, predicate, state);
            }
            return this;
        }
    }
}

