/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.fluid;

import com.google.common.base.Objects;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.class_3518;

public final class FluidValue {
    public static final FluidValue EMPTY = new FluidValue(0);
    public static final FluidValue BUCKET_QUARTER = new FluidValue(250);
    public static final FluidValue BUCKET = new FluidValue(1000);
    public static final FluidValue INFINITE = new FluidValue(Integer.MAX_VALUE);
    private final int rawValue;

    private FluidValue(int rawValue) {
        this.rawValue = rawValue;
    }

    public FluidValue multiply(int value) {
        return FluidValue.fromRaw(this.rawValue * value);
    }

    public FluidValue add(FluidValue fluidValue) {
        return FluidValue.fromRaw(this.rawValue + fluidValue.rawValue);
    }

    public FluidValue subtract(FluidValue fluidValue) {
        return FluidValue.fromRaw(this.rawValue - fluidValue.rawValue);
    }

    public FluidValue min(FluidValue fluidValue) {
        return FluidValue.fromRaw(Math.min(this.rawValue, fluidValue.rawValue));
    }

    public boolean isEmpty() {
        return this.rawValue == 0;
    }

    public boolean moreThan(FluidValue value) {
        return this.rawValue > value.rawValue;
    }

    public boolean equalOrMoreThan(FluidValue value) {
        return this.rawValue >= value.rawValue;
    }

    public boolean lessThan(FluidValue value) {
        return this.rawValue < value.rawValue;
    }

    public boolean lessThanOrEqual(FluidValue value) {
        return this.rawValue <= value.rawValue;
    }

    public String toString() {
        return this.rawValue + " Mb";
    }

    @Deprecated
    public int getRawValue() {
        return this.rawValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluidValue that = (FluidValue)o;
        return this.rawValue == that.rawValue;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.rawValue});
    }

    @Deprecated
    public static FluidValue fromRaw(int rawValue) {
        if (rawValue < 0) {
            rawValue = 0;
        }
        return new FluidValue(rawValue);
    }

    public static FluidValue parseFluidValue(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject.has("buckets")) {
                int buckets = class_3518.method_15260((JsonObject)jsonObject, (String)"buckets");
                return BUCKET.multiply(buckets);
            }
        } else if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isNumber()) {
            return FluidValue.fromRaw(jsonElement.getAsJsonPrimitive().getAsInt());
        }
        throw new JsonSyntaxException("Could not parse fluid value");
    }
}

