/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.stream.Collectors;

public class TranslationTools {
    private static final Scanner SCANNER = new Scanner(System.in);

    public static void main(String[] args) throws IOException {
        Path dir = Paths.get("C:\\Users\\mark\\Desktop\\translations", new String[0]);
        TranslationTools.migrateMappings(dir);
    }

    private static void migrateMappings(Path dir) throws IOException {
        Map<String, String> keyMap = TranslationTools.readJsonFile(dir.resolve("map.json"));
        Map<String, String> newLang = TranslationTools.readJsonFile(dir.resolve("en_us.json"));
        Path outputDir = dir.resolve("out");
        Files.createDirectories(outputDir, new FileAttribute[0]);
        for (Path path : Files.walk(dir.resolve("old"), new FileVisitOption[0]).collect(Collectors.toList())) {
            if (Files.isDirectory(path, new LinkOption[0])) continue;
            Map<String, String> oldLang = TranslationTools.readLangFile(path);
            HashMap<String, String> output = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : oldLang.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (keyMap.containsKey(key)) {
                    key = keyMap.get(key);
                }
                if (!newLang.containsKey(key)) continue;
                output.put(key, value);
            }
            Path outputPath = outputDir.resolve(path.getFileName().toString().toLowerCase().replace(".lang", ".json"));
            TranslationTools.writeJsonMap(outputPath, output);
        }
    }

    private static void generateMigrationMap(Path dir) throws IOException {
        Map<String, String> oldLang = TranslationTools.readLangFile(dir.resolve("en_us.lang"));
        Map<String, String> newLang = TranslationTools.readJsonFile(dir.resolve("en_us.json"));
        HashMap<String, String> conversion = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : oldLang.entrySet()) {
            String[][] autoMatches;
            String key = entry.getKey();
            String value = entry.getValue();
            List<String> newKeys = TranslationTools.getKeysByValue(newLang, value);
            if (newKeys.size() == 1) {
                conversion.put(key, newKeys.get(0));
                continue;
            }
            if (newKeys.size() <= 0) continue;
            boolean autoMatched = false;
            for (String[] arr : autoMatches = new String[][]{{"tile.", "block."}, {"fluid.", "fluid."}}) {
                if (!key.startsWith(arr[0])) continue;
                for (String newKey : newKeys) {
                    if (!newKey.startsWith(arr[1])) continue;
                    autoMatched = true;
                    conversion.put(key, newKey);
                }
            }
            if (autoMatched) continue;
            System.out.println();
            System.out.println(key);
            System.out.println();
            for (int i = 0; i < newKeys.size(); ++i) {
                System.out.println(String.format("%d) %s", i, newKeys.get(i)));
            }
            System.out.print("Input selection:");
            int input = SCANNER.nextInt();
            conversion.put(key, newKeys.get(input));
            System.out.println();
        }
        TranslationTools.writeJsonMap(dir.resolve("map.json"), conversion);
    }

    private static Map<String, String> readJsonFile(Path path) throws IOException {
        Type mapType = new TypeToken<Map<String, String>>(){}.getType();
        return (Map)new Gson().fromJson(new String(Files.readAllBytes(path), StandardCharsets.UTF_8), mapType);
    }

    private static Map<String, String> readLangFile(Path path) throws IOException {
        List lines = Files.lines(path).collect(Collectors.toList());
        HashMap<String, String> map = new HashMap<String, String>();
        for (String line : lines) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            String[] split = line.split("=");
            if (split.length != 2) {
                throw new UnsupportedOperationException();
            }
            map.put(split[0], split[1]);
        }
        return map;
    }

    private static void writeJsonMap(Path path, Map<String, String> map) throws IOException {
        Files.deleteIfExists(path);
        String json = new Gson().toJson(map);
        Files.write(path, json.getBytes(), new OpenOption[0]);
    }

    private static <T, E> List<T> getKeysByValue(Map<T, E> map, E value) {
        ArrayList<T> keys = new ArrayList<T>();
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!Objects.equals(value, entry.getValue())) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }
}

