/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.builder.slot;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import reborncore.client.gui.GuiUtil;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.gui.builder.slot.elements.ConfigSlotElement;
import reborncore.client.gui.builder.slot.elements.ElementBase;
import reborncore.client.gui.builder.slot.elements.SlotType;
import reborncore.client.screen.builder.BuiltScreenHandler;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.network.NetworkManager;
import reborncore.common.network.ServerBoundPackets;
import reborncore.common.util.Color;
import reborncore.mixin.common.AccessorSlot;

public class SlotConfigGui {
    static HashMap<Integer, ConfigSlotElement> slotElementMap = new HashMap();
    public static int selectedSlot = 0;

    public static void reset() {
        selectedSlot = -1;
    }

    public static void init(GuiBase<?> guiBase) {
        SlotConfigGui.reset();
        slotElementMap.clear();
        BuiltScreenHandler container = guiBase.builtScreenHandler;
        for (class_1735 slot : container.field_7761) {
            if (guiBase.be != slot.field_7871) continue;
            AccessorSlot accessorSlot = (AccessorSlot)slot;
            ConfigSlotElement slotElement = new ConfigSlotElement(guiBase.getMachine().getOptionalInventory().get(), accessorSlot.getIndex(), SlotType.NORMAL, slot.field_7873 - guiBase.getGuiLeft() + 50, slot.field_7872 - guiBase.getGuiTop() - 25, guiBase);
            slotElementMap.put(accessorSlot.getIndex(), slotElement);
        }
    }

    public static void draw(class_4587 matrixStack, GuiBase<?> guiBase, int mouseX, int mouseY) {
        BuiltScreenHandler container = guiBase.builtScreenHandler;
        for (class_1735 slot : container.field_7761) {
            if (guiBase.be != slot.field_7871) continue;
            RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Color color = new Color(255, 0, 0, 128);
            GuiUtil.drawGradientRect(matrixStack, slot.field_7873 - 1, slot.field_7872 - 1, 18, 18, color.getColor(), color.getColor());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (selectedSlot != -1) {
            slotElementMap.get(selectedSlot).draw(matrixStack, guiBase);
        }
    }

    public static List<ConfigSlotElement> getVisibleElements() {
        if (selectedSlot == -1) {
            return Collections.emptyList();
        }
        return slotElementMap.values().stream().filter(configSlotElement -> configSlotElement.getId() == selectedSlot).collect(Collectors.toList());
    }

    public static void copyToClipboard() {
        MachineBaseBlockEntity machine = SlotConfigGui.getMachine();
        if (machine == null || machine.getSlotConfiguration() == null) {
            return;
        }
        String json = machine.getSlotConfiguration().toJson(machine.getClass().getCanonicalName());
        class_310.method_1551().field_1774.method_1455(json);
        class_310.method_1551().field_1724.method_9203((class_2561)new class_2585("Slot configuration copyied to clipboard"), class_156.field_25140);
    }

    public static void pasteFromClipboard() {
        MachineBaseBlockEntity machine = SlotConfigGui.getMachine();
        if (machine == null || machine.getSlotConfiguration() == null) {
            return;
        }
        String json = class_310.method_1551().field_1774.method_1460();
        try {
            machine.getSlotConfiguration().readJson(json, machine.getClass().getCanonicalName());
            NetworkManager.sendToServer(ServerBoundPackets.createPacketConfigSave(machine.method_11016(), machine.getSlotConfiguration()));
            class_310.method_1551().field_1724.method_9203((class_2561)new class_2585("Slot configuration loaded from clipboard"), class_156.field_25140);
        }
        catch (UnsupportedOperationException e) {
            class_310.method_1551().field_1724.method_9203((class_2561)new class_2585(e.getMessage()), class_156.field_25140);
        }
    }

    @Nullable
    private static MachineBaseBlockEntity getMachine() {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (!(class_4372 instanceof GuiBase)) {
            return null;
        }
        GuiBase base = (GuiBase)class_4372;
        class_2586 class_25862 = base.be;
        if (class_25862 instanceof MachineBaseBlockEntity) {
            MachineBaseBlockEntity machineBase = (MachineBaseBlockEntity)class_25862;
            return machineBase;
        }
        return null;
    }

    public static boolean mouseClicked(GuiBase<?> guiBase, double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            block0: for (ConfigSlotElement configSlotElement : SlotConfigGui.getVisibleElements()) {
                for (ElementBase element : configSlotElement.elements) {
                    if (element.isInRect(guiBase, element.x, element.y, element.getWidth(guiBase.getMachine()), element.getHeight(guiBase.getMachine()), mouseX, mouseY)) {
                        element.isPressing = true;
                        boolean action = element.onStartPress(guiBase.getMachine(), guiBase, mouseX, mouseY);
                        for (ElementBase elementBase : SlotConfigGui.getVisibleElements()) {
                            if (elementBase == element) continue;
                            elementBase.isPressing = false;
                        }
                        if (!action) continue;
                        continue block0;
                    }
                    element.isPressing = false;
                }
            }
        }
        BuiltScreenHandler screenHandler = guiBase.builtScreenHandler;
        if (SlotConfigGui.getVisibleElements().isEmpty()) {
            for (class_1735 slot : screenHandler.field_7761) {
                if (guiBase.be != slot.field_7871 || !guiBase.isPointInRect(slot.field_7873, slot.field_7872, 18, 18, mouseX, mouseY)) continue;
                AccessorSlot accessorSlot = (AccessorSlot)slot;
                selectedSlot = accessorSlot.getIndex();
                return true;
            }
        }
        return !SlotConfigGui.getVisibleElements().isEmpty();
    }

    public static void mouseClickMove(double mouseX, double mouseY, int mouseButton, long timeSinceLastClick, GuiBase<?> guiBase) {
        if (mouseButton == 0) {
            block0: for (ConfigSlotElement configSlotElement : SlotConfigGui.getVisibleElements()) {
                for (ElementBase element : configSlotElement.elements) {
                    if (element.isInRect(guiBase, element.x, element.y, element.getWidth(guiBase.getMachine()), element.getHeight(guiBase.getMachine()), mouseX, mouseY)) {
                        element.isDragging = true;
                        boolean action = element.onDrag(guiBase.getMachine(), guiBase, mouseX, mouseY);
                        for (ElementBase elementBase : SlotConfigGui.getVisibleElements()) {
                            if (elementBase == element) continue;
                            elementBase.isDragging = false;
                        }
                        if (!action) continue;
                        continue block0;
                    }
                    element.isDragging = false;
                }
            }
        }
    }

    public static boolean mouseReleased(GuiBase<?> guiBase, double mouseX, double mouseY, int mouseButton) {
        boolean clicked = false;
        if (mouseButton == 0) {
            block0: for (ConfigSlotElement configSlotElement : SlotConfigGui.getVisibleElements()) {
                if (configSlotElement.isInRect(guiBase, configSlotElement.x, configSlotElement.y, configSlotElement.getWidth(guiBase.getMachine()), configSlotElement.getHeight(guiBase.getMachine()), mouseX, mouseY)) {
                    clicked = true;
                }
                for (ElementBase element : Lists.reverse(configSlotElement.elements)) {
                    if (element.isInRect(guiBase, element.x, element.y, element.getWidth(guiBase.getMachine()), element.getHeight(guiBase.getMachine()), mouseX, mouseY)) {
                        element.isReleasing = true;
                        boolean action = element.onRelease(guiBase.getMachine(), guiBase, mouseX, mouseY);
                        for (ElementBase elementBase : SlotConfigGui.getVisibleElements()) {
                            if (elementBase == element) continue;
                            elementBase.isReleasing = false;
                        }
                        if (!action) continue block0;
                        clicked = true;
                        continue block0;
                    }
                    element.isReleasing = false;
                }
            }
        }
        return clicked;
    }
}

