/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.builder.slot.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_776;
import reborncore.RebornCore;
import reborncore.client.gui.GuiUtil;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.gui.builder.slot.elements.CheckBoxElement;
import reborncore.client.gui.builder.slot.elements.ConfigSlotElement;
import reborncore.client.gui.builder.slot.elements.ElementBase;
import reborncore.client.gui.builder.slot.elements.Sprite;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.SlotConfiguration;
import reborncore.common.network.IdentifiedPacket;
import reborncore.common.network.NetworkManager;
import reborncore.common.network.ServerBoundPackets;
import reborncore.common.util.Color;
import reborncore.common.util.MachineFacing;

public class SlotConfigPopupElement
extends ElementBase {
    int id;
    public boolean filter = false;
    ConfigSlotElement slotElement;
    boolean allowInput = true;

    public SlotConfigPopupElement(int slotId, int x, int y, ConfigSlotElement slotElement, boolean allowInput) {
        super(x, y, Sprite.SLOT_CONFIG_POPUP);
        this.id = slotId;
        this.slotElement = slotElement;
        this.allowInput = allowInput;
    }

    @Override
    public void draw(class_4587 matrixStack, GuiBase<?> gui) {
        this.drawDefaultBackground(matrixStack, (class_437)gui, this.adjustX(gui, this.getX() - 8), this.adjustY(gui, this.getY() - 7), 84, 105 + (this.filter ? 15 : 0));
        super.draw(matrixStack, gui);
        MachineBaseBlockEntity machine = (MachineBaseBlockEntity)gui.be;
        class_1937 world = machine.method_10997();
        class_2338 pos = machine.method_11016();
        class_2680 state = world.method_8320(pos);
        class_2680 actualState = state.method_26204().method_9564();
        class_776 dispatcher = class_310.method_1551().method_1541();
        class_1087 model = dispatcher.method_3351().method_3335(state.method_26204().method_9564());
        class_310.method_1551().method_1531().method_22813(class_1059.field_5275);
        this.drawState(gui, world, model, actualState, pos, dispatcher, 4, 23, class_1160.field_20705.method_23214(90.0f));
        this.drawState(gui, world, model, actualState, pos, dispatcher, 23, 4, class_1160.field_20702.method_23214(90.0f));
        this.drawState(gui, world, model, actualState, pos, dispatcher, 23, 23, null);
        this.drawState(gui, world, model, actualState, pos, dispatcher, 23, 26, class_1160.field_20703.method_23214(90.0f));
        this.drawState(gui, world, model, actualState, pos, dispatcher, 42, 23, class_1160.field_20705.method_23214(90.0f));
        this.drawState(gui, world, model, actualState, pos, dispatcher, 26, 42, class_1160.field_20705.method_23214(180.0f));
        this.drawSlotSateColor(matrixStack, gui.getMachine(), MachineFacing.UP.getFacing(machine), this.id, 22, -1, gui);
        this.drawSlotSateColor(matrixStack, gui.getMachine(), MachineFacing.FRONT.getFacing(machine), this.id, 22, 18, gui);
        this.drawSlotSateColor(matrixStack, gui.getMachine(), MachineFacing.DOWN.getFacing(machine), this.id, 22, 37, gui);
        this.drawSlotSateColor(matrixStack, gui.getMachine(), MachineFacing.RIGHT.getFacing(machine), this.id, 41, 18, gui);
        this.drawSlotSateColor(matrixStack, gui.getMachine(), MachineFacing.BACK.getFacing(machine), this.id, 41, 37, gui);
        this.drawSlotSateColor(matrixStack, gui.getMachine(), MachineFacing.LEFT.getFacing(machine), this.id, 3, 18, gui);
    }

    @Override
    public boolean onRelease(MachineBaseBlockEntity provider, GuiBase<?> gui, double mouseX, double mouseY) {
        if (this.isInBox(23, 4, 16, 16, mouseX, mouseY, gui)) {
            this.cyleSlotConfig(MachineFacing.UP.getFacing(provider), gui);
        } else if (this.isInBox(23, 23, 16, 16, mouseX, mouseY, gui)) {
            this.cyleSlotConfig(MachineFacing.FRONT.getFacing(provider), gui);
        } else if (this.isInBox(42, 23, 16, 16, mouseX, mouseY, gui)) {
            this.cyleSlotConfig(MachineFacing.RIGHT.getFacing(provider), gui);
        } else if (this.isInBox(4, 23, 16, 16, mouseX, mouseY, gui)) {
            this.cyleSlotConfig(MachineFacing.LEFT.getFacing(provider), gui);
        } else if (this.isInBox(23, 42, 16, 16, mouseX, mouseY, gui)) {
            this.cyleSlotConfig(MachineFacing.DOWN.getFacing(provider), gui);
        } else if (this.isInBox(42, 42, 16, 16, mouseX, mouseY, gui)) {
            this.cyleSlotConfig(MachineFacing.BACK.getFacing(provider), gui);
        } else {
            return false;
        }
        return true;
    }

    public void cyleSlotConfig(class_2350 side, GuiBase<?> guiBase) {
        SlotConfiguration.SlotConfig currentSlot = guiBase.getMachine().getSlotConfiguration().getSlotDetails(this.id).getSideDetail(side);
        SlotConfiguration.ExtractConfig nextConfig = currentSlot.getSlotIO().getIoConfig().getNext();
        if (!this.allowInput && nextConfig == SlotConfiguration.ExtractConfig.INPUT) {
            nextConfig = SlotConfiguration.ExtractConfig.OUTPUT;
        }
        SlotConfiguration.SlotIO slotIO = new SlotConfiguration.SlotIO(nextConfig);
        SlotConfiguration.SlotConfig newConfig = new SlotConfiguration.SlotConfig(side, slotIO, this.id);
        IdentifiedPacket packetSlotSave = ServerBoundPackets.createPacketSlotSave(guiBase.be.method_11016(), newConfig);
        NetworkManager.sendToServer(packetSlotSave);
    }

    public void updateCheckBox(CheckBoxElement checkBoxElement, String type, GuiBase<?> guiBase) {
        SlotConfiguration.SlotConfigHolder configHolder = guiBase.getMachine().getSlotConfiguration().getSlotDetails(this.id);
        boolean input = configHolder.autoInput();
        boolean output = configHolder.autoOutput();
        boolean filter = configHolder.filter();
        if (type.equalsIgnoreCase("input")) {
            boolean bl = input = !configHolder.autoInput();
        }
        if (type.equalsIgnoreCase("output")) {
            boolean bl = output = !configHolder.autoOutput();
        }
        if (type.equalsIgnoreCase("filter")) {
            filter = !configHolder.filter();
        }
        IdentifiedPacket packetSlotSave = ServerBoundPackets.createPacketIOSave(guiBase.be.method_11016(), this.id, input, output, filter);
        NetworkManager.sendToServer(packetSlotSave);
    }

    private void drawSlotSateColor(class_4587 matrices, MachineBaseBlockEntity machineBase, class_2350 side, int slotID, int inx, int iny, GuiBase<?> gui) {
        int sx = inx + this.getX() + gui.getGuiLeft();
        int sy = (iny += 4) + this.getY() + gui.getGuiTop();
        SlotConfiguration.SlotConfigHolder slotConfigHolder = machineBase.getSlotConfiguration().getSlotDetails(slotID);
        if (slotConfigHolder == null) {
            RebornCore.LOGGER.debug("Humm, this isnt suppoed to happen");
            return;
        }
        SlotConfiguration.SlotConfig slotConfig = slotConfigHolder.getSideDetail(side);
        Color color = switch (slotConfig.getSlotIO().getIoConfig()) {
            case SlotConfiguration.ExtractConfig.INPUT -> new Color(0, 0, 255, 128);
            case SlotConfiguration.ExtractConfig.OUTPUT -> new Color(255, 69, 0, 128);
            default -> new Color(0, 0, 0, 0);
        };
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiUtil.drawGradientRect(matrices, sx, sy, 18, 18, color.getColor(), color.getColor());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private boolean isInBox(int rectX, int rectY, int rectWidth, int rectHeight, double pointX, double pointY, GuiBase<?> guiBase) {
        return this.isInRect(guiBase, rectX += this.getX(), rectY += this.getY(), rectWidth, rectHeight, pointX, pointY);
    }

    public void drawState(GuiBase<?> gui, class_1937 world, class_1087 model, class_2680 actualState, class_2338 pos, class_776 dispatcher, int x, int y, class_1158 quaternion) {
        class_4587 matrixStack = new class_4587();
        matrixStack.method_22903();
        matrixStack.method_22904((double)(8 + gui.getGuiLeft() + this.x + x), (double)(8 + gui.getGuiTop() + this.y + y), 512.0);
        matrixStack.method_22905(16.0f, 16.0f, 16.0f);
        matrixStack.method_22904(0.5, 0.5, 0.5);
        matrixStack.method_22905(-1.0f, -1.0f, -1.0f);
        if (quaternion != null) {
            matrixStack.method_22907(quaternion);
        }
        class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        dispatcher.method_3350().method_3367(matrixStack.method_23760(), immediate.getBuffer(class_1921.method_23577()), actualState, model, 1.0f, 1.0f, 1.0f, class_4608.method_23210((float)15.0f), class_4608.field_21444);
        immediate.method_22993();
        matrixStack.method_22909();
    }

    public void drawState(GuiBase<?> gui, class_1937 world, class_1087 model, class_2680 actualState, class_2338 pos, class_776 dispatcher, int x, int y) {
        this.drawState(gui, world, model, actualState, pos, dispatcher, x, y, null);
    }
}

