/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.screen.builder;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1715;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3917;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.network.ClientBoundPackets;
import reborncore.common.network.NetworkManager;
import reborncore.common.util.ItemUtils;
import reborncore.mixin.common.AccessorScreenHandler;
import reborncore.mixin.ifaces.ServerPlayerEntityScreenHandler;

public class BuiltScreenHandler
extends class_1703 {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String name;
    private final Predicate<class_1657> canInteract;
    private final List<Range<Integer>> playerSlotRanges;
    private final List<Range<Integer>> blockEntitySlotRanges;
    private final Map<SyncPair, Object> syncPairCache = new HashMap<SyncPair, Object>();
    private final Int2ObjectMap<SyncPair> syncPairIdLookup = new Int2ObjectOpenHashMap();
    private List<Consumer<class_1715>> craftEvents;
    private Integer[] integerParts;
    private final MachineBaseBlockEntity blockEntity;
    class_3917<BuiltScreenHandler> type = null;

    public BuiltScreenHandler(int syncID, String name, Predicate<class_1657> canInteract, List<Range<Integer>> playerSlotRange, List<Range<Integer>> blockEntitySlotRange, MachineBaseBlockEntity blockEntity) {
        super(null, syncID);
        this.name = name;
        this.canInteract = canInteract;
        this.playerSlotRanges = playerSlotRange;
        this.blockEntitySlotRanges = blockEntitySlotRange;
        this.blockEntity = blockEntity;
    }

    public void addObjectSync(List<Pair<Supplier<?>, Consumer<?>>> syncables) {
        for (Pair<Supplier<?>, Consumer<?>> syncable : syncables) {
            int id = this.syncPairCache.size() + 1;
            SyncPair syncPair = new SyncPair((Supplier)syncable.getLeft(), (Consumer)syncable.getRight(), id);
            this.syncPairCache.put(syncPair, null);
            this.syncPairIdLookup.put(id, (Object)syncPair);
        }
    }

    public void addCraftEvents(List<Consumer<class_1715>> craftEvents) {
        this.craftEvents = craftEvents;
    }

    public boolean method_7597(class_1657 playerIn) {
        return this.canInteract.test(playerIn);
    }

    public final void method_7609(class_1263 inv) {
        if (!this.craftEvents.isEmpty()) {
            this.craftEvents.forEach(consumer -> consumer.accept((class_1715)inv));
        }
    }

    public void method_7623() {
        super.method_7623();
        for (class_1712 listener : ((AccessorScreenHandler)((Object)this)).getListeners()) {
            this.sendContentUpdatePacketToListener(listener);
        }
    }

    public void method_7596(class_1712 listener) {
        super.method_7596(listener);
        this.sendContentUpdatePacketToListener(listener);
    }

    private void sendContentUpdatePacketToListener(class_1712 listener) {
        Int2ObjectOpenHashMap updatedValues = new Int2ObjectOpenHashMap();
        this.syncPairCache.replaceAll((arg_0, arg_1) -> BuiltScreenHandler.lambda$sendContentUpdatePacketToListener$1((Int2ObjectMap)updatedValues, arg_0, arg_1));
        this.sendUpdatedValues(listener, this, (Int2ObjectMap<Object>)updatedValues);
    }

    public void handleUpdateValues(Int2ObjectMap<Object> updatedValues) {
        updatedValues.int2ObjectEntrySet().forEach(entry -> {
            SyncPair syncPair = (SyncPair)this.syncPairIdLookup.get(entry.getIntKey());
            if (syncPair == null) {
                LOGGER.warn("Unknown sync pair id: " + entry.getIntKey());
                return;
            }
            syncPair.consumer().accept(entry.getValue());
        });
    }

    private void sendUpdatedValues(class_1712 screenHandlerListener, class_1703 screenHandler, Int2ObjectMap<Object> updatedValues) {
        if (updatedValues.isEmpty()) {
            return;
        }
        class_1712 class_17122 = screenHandlerListener;
        if (class_17122 instanceof ServerPlayerEntityScreenHandler) {
            ServerPlayerEntityScreenHandler serverPlayerEntityScreenHandler = (ServerPlayerEntityScreenHandler)class_17122;
            NetworkManager.sendToPlayer(ClientBoundPackets.createPacketSendObject(screenHandler, updatedValues), serverPlayerEntityScreenHandler.rc_getServerPlayerEntity());
        }
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 originalStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 stackInSlot = slot.method_7677();
            originalStack = stackInSlot.method_7972();
            boolean shifted = false;
            for (Range<Integer> range : this.playerSlotRanges) {
                if (!range.contains((Object)index)) continue;
                if (!this.shiftToBlockEntity(stackInSlot)) break;
                shifted = true;
                break;
            }
            if (!shifted) {
                for (Range<Integer> range : this.blockEntitySlotRanges) {
                    if (!range.contains((Object)index)) continue;
                    if (!this.shiftToPlayer(stackInSlot)) break;
                    shifted = true;
                    break;
                }
            }
            slot.method_7670(stackInSlot, originalStack);
            if (stackInSlot.method_7947() <= 0) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (stackInSlot.method_7947() == originalStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, stackInSlot);
        }
        return originalStack;
    }

    protected boolean shiftItemStack(class_1799 stackToShift, int start, int end) {
        int maxCount;
        class_1799 stackInSlot;
        class_1735 slot;
        int slotIndex;
        if (stackToShift.method_7960()) {
            return false;
        }
        int inCount = stackToShift.method_7947();
        for (slotIndex = start; stackToShift.method_7947() > 0 && slotIndex < end; ++slotIndex) {
            int freeStackSpace;
            slot = (class_1735)this.field_7761.get(slotIndex);
            stackInSlot = slot.method_7677();
            maxCount = Math.min(stackToShift.method_7914(), slot.method_7675());
            if (stackToShift.method_7960() || !slot.method_7680(stackToShift) || !ItemUtils.isItemEqual(stackInSlot, stackToShift, true, false) || (freeStackSpace = maxCount - stackInSlot.method_7947()) <= 0) continue;
            int transferAmount = Math.min(freeStackSpace, stackToShift.method_7947());
            stackInSlot.method_7933(transferAmount);
            stackToShift.method_7934(transferAmount);
        }
        for (slotIndex = start; stackToShift.method_7947() > 0 && slotIndex < end; ++slotIndex) {
            slot = (class_1735)this.field_7761.get(slotIndex);
            stackInSlot = slot.method_7677();
            if (!stackInSlot.method_7960() || !slot.method_7680(stackToShift)) continue;
            maxCount = Math.min(stackToShift.method_7914(), slot.method_7675());
            int moveCount = Math.min(maxCount, stackToShift.method_7947());
            class_1799 moveStack = stackToShift.method_7972();
            moveStack.method_7939(moveCount);
            slot.method_7673(moveStack);
            stackToShift.method_7934(moveCount);
        }
        if (!stackToShift.method_7960() && stackToShift.method_7947() != inCount) {
            this.shiftItemStack(stackToShift, start, end);
        }
        return stackToShift.method_7947() != inCount;
    }

    private boolean shiftToBlockEntity(class_1799 stackToShift) {
        if (!this.blockEntity.getOptionalInventory().isPresent()) {
            return false;
        }
        for (Range<Integer> range : this.blockEntitySlotRanges) {
            if (!this.shiftItemStack(stackToShift, (Integer)range.getMinimum(), (Integer)range.getMaximum() + 1)) continue;
            return true;
        }
        return false;
    }

    private boolean shiftToPlayer(class_1799 stackToShift) {
        for (Range<Integer> range : this.playerSlotRanges) {
            if (!this.shiftItemStack(stackToShift, (Integer)range.getMinimum(), (Integer)range.getMaximum() + 1)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public class_1735 method_7621(class_1735 slotIn) {
        return super.method_7621(slotIn);
    }

    public MachineBaseBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public class_2338 getPos() {
        return this.getBlockEntity().method_11016();
    }

    public void setType(class_3917<BuiltScreenHandler> type) {
        this.type = type;
    }

    public class_3917<BuiltScreenHandler> method_17358() {
        return this.type;
    }

    private static /* synthetic */ Object lambda$sendContentUpdatePacketToListener$1(Int2ObjectMap updatedValues, SyncPair syncPair, Object cached) {
        Object value = syncPair.supplier().get();
        if (value != cached) {
            updatedValues.put(syncPair.id, value);
            return value;
        }
        return null;
    }

    private record SyncPair(Supplier supplier, Consumer consumer, int id) {
    }
}

