/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.blockentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.client.screen.builder.Syncable;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.util.BooleanFunction;
import reborncore.common.util.NBTSerializable;

public class RedstoneConfiguration
implements NBTSerializable,
Syncable {
    public static class_1799 powerStack = new class_1799((class_1935)class_1802.field_8184);
    public static class_1799 fluidStack = new class_1799((class_1935)class_1802.field_8550);
    private static List<Element> ELEMENTS = new ArrayList<Element>();
    private static Map<String, Element> ELEMENT_MAP = new HashMap<String, Element>();
    public static Element ITEM_IO = RedstoneConfiguration.newBuilder().name("item_io").icon(() -> new class_1799((class_1935)class_2246.field_10312)).build();
    public static Element POWER_IO = RedstoneConfiguration.newBuilder().name("power_io").icon(() -> powerStack).build();
    public static Element FLUID_IO = RedstoneConfiguration.newBuilder().name("fluid_io").canApply(type -> type.getTank() != null).icon(() -> fluidStack).build();
    public static Element RECIPE_PROCESSING = RedstoneConfiguration.newBuilder().name("recipe_processing").canApply(type -> type instanceof IRecipeCrafterProvider).icon(() -> new class_1799((class_1935)class_2246.field_9980)).build();
    private final MachineBaseBlockEntity blockEntity;
    private List<Element> activeElements;
    private Map<Element, State> stateMap;

    private static Element.Builder newBuilder() {
        return Element.Builder.getInstance();
    }

    public RedstoneConfiguration(MachineBaseBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public List<Element> getElements() {
        if (this.activeElements != null) {
            return this.activeElements;
        }
        this.activeElements = ELEMENTS.stream().filter(element -> element.isApplicable(this.blockEntity)).collect(Collectors.toList());
        return this.activeElements;
    }

    public void refreshCache() {
        this.activeElements = null;
        if (this.stateMap != null) {
            for (Element element : this.getElements()) {
                if (this.stateMap.containsKey(element)) continue;
                this.stateMap.put(element, State.IGNORED);
            }
        }
    }

    public State getState(Element element) {
        if (this.stateMap == null) {
            this.populateStateMap();
        }
        State state = this.stateMap.get(element);
        Validate.notNull((Object)((Object)state), (String)("Unsupported element " + element.getName() + " for machine: " + this.blockEntity.getClass().getName()), (Object[])new Object[0]);
        return state;
    }

    public void setState(Element element, State state) {
        if (this.stateMap == null) {
            this.populateStateMap();
        }
        Validate.isTrue((boolean)this.stateMap.containsKey(element));
        this.stateMap.replace(element, state);
    }

    public boolean isActive(Element element) {
        State state = this.getState(element);
        if (state == State.IGNORED) {
            return true;
        }
        boolean hasRedstonePower = this.blockEntity.method_10997().method_8479(this.blockEntity.method_11016());
        boolean enabledState = state == State.ENABLED_ON;
        return enabledState == hasRedstonePower;
    }

    private void populateStateMap() {
        Validate.isTrue((this.stateMap == null ? 1 : 0) != 0);
        this.stateMap = new HashMap<Element, State>();
        for (Element element : this.getElements()) {
            this.stateMap.put(element, State.IGNORED);
        }
    }

    @Override
    @NotNull
    public class_2487 write() {
        class_2487 tag = new class_2487();
        for (Element element : this.getElements()) {
            tag.method_10569(element.getName(), this.getState(element).ordinal());
        }
        return tag;
    }

    @Override
    public void read(@NotNull class_2487 tag) {
        this.stateMap = new HashMap<Element, State>();
        for (String key : tag.method_10541()) {
            Element element = ELEMENT_MAP.get(key);
            if (element == null) {
                System.out.println("Unknown element type: " + key);
                continue;
            }
            State state = State.values()[tag.method_10550(key)];
            this.stateMap.put(element, state);
        }
        for (Element element : this.getElements()) {
            if (this.stateMap.containsKey(element)) continue;
            this.stateMap.put(element, State.IGNORED);
        }
    }

    @Override
    public void getSyncPair(List<Pair<Supplier<?>, Consumer<?>>> pairList) {
        pairList.add(Pair.of(this::write, this::read));
    }

    public static Element getElementByName(String name) {
        return ELEMENT_MAP.get(name);
    }

    public static class Element {
        private final String name;
        private final BooleanFunction<MachineBaseBlockEntity> isApplicable;
        private final Supplier<class_1799> icon;

        public Element(String name, BooleanFunction<MachineBaseBlockEntity> isApplicable, Supplier<class_1799> icon) {
            this.name = name;
            this.isApplicable = isApplicable;
            this.icon = icon;
        }

        public boolean isApplicable(MachineBaseBlockEntity blockEntity) {
            return this.isApplicable.get(blockEntity);
        }

        public String getName() {
            return this.name;
        }

        public class_1799 getIcon() {
            return this.icon.get();
        }

        public static class Builder {
            private String name;
            private BooleanFunction<MachineBaseBlockEntity> isApplicable = be -> true;
            private Supplier<class_1799> icon = () -> class_1799.field_8037;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder canApply(BooleanFunction<MachineBaseBlockEntity> isApplicable) {
                this.isApplicable = isApplicable;
                return this;
            }

            public Builder icon(Supplier<class_1799> stack) {
                this.icon = stack;
                return this;
            }

            public Element build() {
                Validate.isTrue((!StringUtils.isEmpty((CharSequence)this.name) ? 1 : 0) != 0);
                Element element = new Element(this.name, this.isApplicable, this.icon);
                ELEMENTS.add(element);
                ELEMENT_MAP.put(element.getName(), element);
                return element;
            }

            public static Builder getInstance() {
                return new Builder();
            }
        }
    }

    public static enum State {
        IGNORED,
        ENABLED_ON,
        ENABLED_OFF;

    }
}

