/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import reborncore.RebornCore;
import reborncore.common.crafting.ConditionManager;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RecipeUtils;
import reborncore.common.util.serialization.SerializationUtil;

public record RebornRecipeType<R extends RebornRecipe>(BiFunction<RebornRecipeType<R>, class_2960, R> recipeFunction, class_2960 name) implements class_3956,
class_1865
{
    public R read(class_2960 recipeId, JsonObject json) {
        class_2960 type = new class_2960(class_3518.method_15265((JsonObject)json, (String)"type"));
        if (!type.equals((Object)this.name)) {
            throw new RuntimeException("RebornRecipe type not supported!");
        }
        R recipe = this.newRecipe(recipeId);
        try {
            if (!ConditionManager.shouldLoadRecipe(json)) {
                ((RebornRecipe)recipe).makeDummy();
                return recipe;
            }
            ((RebornRecipe)recipe).deserialize(json);
        }
        catch (Throwable t) {
            t.printStackTrace();
            RebornCore.LOGGER.error("Failed to read recipe: " + recipeId);
        }
        return recipe;
    }

    public JsonObject toJson(R recipe) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", this.name.toString());
        ((RebornRecipe)recipe).serialize(jsonObject);
        return jsonObject;
    }

    public R fromJson(class_2960 recipeType, JsonObject json) {
        return this.read(recipeType, json);
    }

    R newRecipe(class_2960 recipeId) {
        return (R)((RebornRecipe)this.recipeFunction.apply(this, recipeId));
    }

    public R read(class_2960 recipeId, class_2540 buffer) {
        String input = buffer.method_10800(buffer.readInt());
        R r = this.read(recipeId, (JsonObject)SerializationUtil.GSON_FLAT.fromJson(input, JsonObject.class));
        ((RebornRecipe)r).deserialize(buffer);
        return r;
    }

    public void method_8124(class_2540 buffer, class_1860 recipe) {
        JsonObject jsonObject = this.toJson((RebornRecipe)recipe);
        String output = SerializationUtil.GSON_FLAT.toJson((JsonElement)jsonObject);
        buffer.writeInt(output.length());
        buffer.method_10814(output);
        ((RebornRecipe)recipe).serialize(buffer);
    }

    public List<R> getRecipes(class_1937 world) {
        return RecipeUtils.getRecipes(world, this);
    }
}

