/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.fluid;

import com.google.common.base.Objects;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.class_3518;
import reborncore.common.util.FluidTextHelper;

public final class FluidValue {
    public static final FluidValue EMPTY = new FluidValue(0L);
    public static final FluidValue BUCKET_QUARTER = new FluidValue(20250L);
    public static final FluidValue BUCKET = new FluidValue(81000L);
    public static final FluidValue INFINITE = new FluidValue(Long.MAX_VALUE);
    private final long rawValue;

    private static FluidValue fromMillibuckets(long millibuckets) {
        return new FluidValue(millibuckets * 81L);
    }

    private FluidValue(long rawValue) {
        this.rawValue = rawValue;
    }

    public FluidValue multiply(long value) {
        return FluidValue.fromRaw(this.rawValue * value);
    }

    public FluidValue fraction(long divider) {
        return FluidValue.fromRaw(this.rawValue / divider);
    }

    public FluidValue add(FluidValue fluidValue) {
        return FluidValue.fromRaw(this.rawValue + fluidValue.rawValue);
    }

    public FluidValue subtract(FluidValue fluidValue) {
        return FluidValue.fromRaw(this.rawValue - fluidValue.rawValue);
    }

    public FluidValue min(FluidValue fluidValue) {
        return FluidValue.fromRaw(Math.min(this.rawValue, fluidValue.rawValue));
    }

    public boolean isEmpty() {
        return this.rawValue == 0L;
    }

    public boolean moreThan(FluidValue value) {
        return this.rawValue > value.rawValue;
    }

    public boolean equalOrMoreThan(FluidValue value) {
        return this.rawValue >= value.rawValue;
    }

    public boolean lessThan(FluidValue value) {
        return this.rawValue < value.rawValue;
    }

    public boolean lessThanOrEqual(FluidValue value) {
        return this.rawValue <= value.rawValue;
    }

    public String toString() {
        return FluidTextHelper.getValueDisplay(this) + " Mb";
    }

    @Deprecated
    public long getRawValue() {
        return this.rawValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluidValue that = (FluidValue)o;
        return this.rawValue == that.rawValue;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.rawValue});
    }

    @Deprecated
    public static FluidValue fromRaw(long rawValue) {
        if (rawValue < 0L) {
            rawValue = 0L;
        }
        return new FluidValue(rawValue);
    }

    public static FluidValue parseFluidValue(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject.has("buckets")) {
                int buckets = class_3518.method_15260((JsonObject)jsonObject, (String)"buckets");
                return BUCKET.multiply(buckets);
            }
            if (jsonObject.has("droplets")) {
                long droplets = class_3518.method_22449((JsonObject)jsonObject, (String)"droplets");
                return FluidValue.fromRaw(droplets);
            }
        } else if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isNumber()) {
            return FluidValue.fromMillibuckets(jsonElement.getAsJsonPrimitive().getAsInt());
        }
        throw new JsonSyntaxException("Could not parse fluid value");
    }
}

