/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import reborncore.common.RebornCoreConfig;

public class PowerSystem {
    private static EnergySystem selectedSystem = EnergySystem.values()[0];
    private static final char[] magnitude = new char[]{'k', 'M', 'G', 'T'};
    private static Locale locale = Locale.ROOT;

    public static String getLocalizedPower(double power) {
        return PowerSystem.getRoundedString(power, PowerSystem.selectedSystem.abbreviation, true);
    }

    public static String getLocalizedPowerNoSuffix(double power) {
        return PowerSystem.getRoundedString((int)power, "", true);
    }

    public static String getLocalizedPowerNoFormat(double power) {
        return PowerSystem.getRoundedString(power, PowerSystem.selectedSystem.abbreviation, false);
    }

    public static String getLocalizedPowerNoSuffixNoFormat(double power) {
        return PowerSystem.getRoundedString(power, "", false);
    }

    public static String getLocalizedPowerFull(double power) {
        return PowerSystem.getFullPower(power, PowerSystem.selectedSystem.abbreviation);
    }

    public static String getLocalizedPowerFullNoSuffix(double power) {
        return PowerSystem.getFullPower(power, "");
    }

    private static String getFullPower(double power, String units) {
        PowerSystem.checkLocale();
        DecimalFormat formatter = (DecimalFormat)DecimalFormat.getInstance(locale);
        return formatter.format(power) + " " + units;
    }

    private static String getRoundedString(double originalValue, String units, boolean doFormat) {
        Object ret = "";
        double value = 0.0;
        int i = 0;
        boolean showMagnitude = true;
        double euValue = originalValue;
        if (euValue < 0.0) {
            ret = "-";
            euValue = -euValue;
        }
        if (euValue < 1000.0) {
            doFormat = false;
            showMagnitude = false;
            value = euValue;
        } else if (euValue >= 1000.0) {
            i = 0;
            while (true) {
                if (euValue < 10000.0 && euValue % 1000.0 >= 100.0) {
                    value = Math.floor(euValue / 1000.0);
                    value += (double)((float)euValue % 1000.0f / 1000.0f);
                    break;
                }
                if ((euValue /= 1000.0) < 1000.0) {
                    value = euValue;
                    break;
                }
                ++i;
            }
        }
        if (i > 10) {
            doFormat = false;
            showMagnitude = false;
        } else if (i > 3) {
            value = originalValue;
            showMagnitude = false;
        }
        if (doFormat) {
            PowerSystem.checkLocale();
            DecimalFormat formatter = (DecimalFormat)DecimalFormat.getInstance(locale);
            ret = (String)ret + formatter.format(value);
            int idx = ((String)ret).lastIndexOf(formatter.getDecimalFormatSymbols().getDecimalSeparator());
            if (idx > 0) {
                ret = ((String)ret).substring(0, idx + 2);
            }
        } else {
            ret = i > 10 ? (String)ret + "\u221e" : (String)ret + value;
        }
        if (showMagnitude) {
            ret = (String)ret + magnitude[i];
        }
        if (!units.equals("")) {
            ret = (String)ret + " " + units;
        }
        return ret;
    }

    public static EnergySystem getDisplayPower() {
        if (!PowerSystem.selectedSystem.enabled.get().booleanValue()) {
            PowerSystem.bumpPowerConfig();
        }
        return selectedSystem;
    }

    public static void bumpPowerConfig() {
        int value = selectedSystem.ordinal() + 1;
        if (value == EnergySystem.values().length) {
            value = 0;
        }
        selectedSystem = EnergySystem.values()[value];
    }

    public static void init() {
        selectedSystem = Arrays.stream(EnergySystem.values()).filter(energySystem -> energySystem.abbreviation.equalsIgnoreCase(RebornCoreConfig.selectedSystem)).findFirst().orElse(EnergySystem.values()[0]);
        if (!PowerSystem.selectedSystem.enabled.get().booleanValue()) {
            PowerSystem.bumpPowerConfig();
        }
    }

    private static void checkLocale() {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return;
        }
        class_310 instance = class_310.method_1551();
        if (instance == null) {
            return;
        }
        String strangeMcLang = instance.method_1526().method_4669().getCode();
        locale = Locale.forLanguageTag(strangeMcLang.substring(0, 2));
    }

    public static enum EnergySystem {
        EU(-8387072, "E", 141, 151, -10027008);

        public int colour;
        public int altColour;
        public String abbreviation;
        public int xBar;
        public int yBar;
        public Supplier<Boolean> enabled = () -> true;

        private EnergySystem(int colour, String abbreviation, int xBar, int yBar, int altColour) {
            this.colour = colour;
            this.abbreviation = abbreviation;
            this.xBar = xBar;
            this.yBar = yBar;
            this.altColour = altColour;
        }
    }
}

