/*
 * Decompiled with CFR 0.152.
 */
package net.rpgz.mixin;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.rpgz.access.IInventoryAccess;
import net.rpgz.forge.config.RPGZConfig;
import net.rpgz.tag.Tags;
import net.rpgz.ui.LivingEntityScreenHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements IInventoryAccess {
    @Shadow
    public int field_70725_aQ;
    @Shadow
    public float field_70761_aq;
    @Shadow
    protected int field_70718_bc;
    Inventory dropInventory = new Inventory(9);

    public LivingEntityMixin(EntityType<? extends LivingEntity> entityType, World world) {
        super(entityType, world);
    }

    @Inject(method={"livingTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void livingTickMixin(CallbackInfo info) {
        LivingEntityMixin entity = this;
        LivingEntity livingEntity = (LivingEntity)entity;
        if (this.field_70725_aQ > 19 && livingEntity instanceof MobEntity) {
            if (this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_196958_f()) {
                if (livingEntity instanceof FlyingEntity) {
                    this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() - 0.25, this.func_226281_cx_());
                } else if (!this.field_70122_E) {
                    if (this.func_213322_ci().field_72448_b > 0.0) {
                        this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() - this.func_213322_ci().field_72448_b, this.func_226281_cx_());
                    } else if (this.func_213322_ci().field_72448_b < 0.0) {
                        this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() + this.func_213322_ci().field_72448_b, this.func_226281_cx_());
                    } else {
                        this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() - 0.1, this.func_226281_cx_());
                    }
                }
            } else if (this.field_70170_p.func_72953_d(this.func_174813_aQ().func_72317_d(0.0, -this.func_174813_aQ().func_216360_c() + this.func_174813_aQ().func_216360_c() / 5.0, 0.0))) {
                if (this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_204520_s().func_206884_a((ITag)FluidTags.field_206960_b) && this.func_230285_a_((Fluid)Fluids.field_204547_b)) {
                    this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() + 0.1, this.func_226281_cx_());
                } else if (!this.field_70122_E) {
                    this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() - 0.06, this.func_226281_cx_());
                }
            }
            info.cancel();
        }
    }

    @Overwrite
    public void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.func_70027_ad() && this.field_70725_aQ == 1) {
            this.func_70066_B();
        }
        if (this.func_184187_bx() != null) {
            this.func_184210_p();
        }
        if (this.field_70725_aQ >= 20) {
            AxisAlignedBB newBoundingBox = new AxisAlignedBB(this.func_226277_ct_() - (double)(this.func_213311_cf() / 3.0f), this.func_226278_cu_() - (double)(this.func_213311_cf() / 3.0f), this.func_226281_cx_() - (double)(this.func_213311_cf() / 3.0f), this.func_226277_ct_() + (double)(this.func_213311_cf() / 1.5f), this.func_226278_cu_() + (double)(this.func_213311_cf() / 1.5f), this.func_226281_cx_() + (double)(this.func_213311_cf() / 1.5f));
            if (this.func_213305_a((Pose)Pose.STANDING).field_220316_b < 1.0f && this.func_213305_a((Pose)Pose.STANDING).field_220315_a < 1.0f || this.func_213305_a((Pose)Pose.STANDING).field_220315_a / this.func_213305_a((Pose)Pose.STANDING).field_220316_b > 1.395f) {
                this.func_174826_a(newBoundingBox);
            } else {
                this.func_174826_a(newBoundingBox.func_191194_a(this.func_174806_f(0.0f, this.field_70761_aq).func_178785_b(-30.0f)));
            }
            AxisAlignedBB box = this.func_174813_aQ();
            BlockPos blockPos = new BlockPos(box.field_72340_a + 0.001, box.field_72338_b + 0.001, box.field_72339_c + 0.001).func_177984_a();
            BlockPos blockPos2 = new BlockPos(box.field_72336_d - 0.001, box.field_72337_e - 0.001, box.field_72334_f - 0.001);
            if (this.field_70170_p.func_175707_a(blockPos, blockPos2) && (!this.field_70170_p.field_72995_K && !this.dropInventory.func_191420_l() && (this.field_70170_p.func_180495_p(blockPos).func_235785_r_((IBlockReader)this.field_70170_p, blockPos) || this.field_70170_p.func_180495_p(blockPos2).func_235785_r_((IBlockReader)this.field_70170_p, blockPos2) || this.func_70631_g_() || ((Boolean)RPGZConfig.drop_unlooted.get()).booleanValue() && this.field_70725_aQ > (Integer)RPGZConfig.drop_after_ticks.get()) || this.func_200600_R().func_220341_a(Tags.EXCLUDED_ENTITIES) || ((List)RPGZConfig.excluded_entities.get()).contains(this.func_200600_R().toString().replace("entity.", "")))) {
                this.dropInventory.func_233543_f_().forEach(arg_0 -> ((LivingEntityMixin)this).func_199701_a_(arg_0));
            }
        }
        if (this.field_70725_aQ >= 20 && !this.field_70170_p.field_72995_K && this.dropInventory.func_191420_l() && ((Boolean)RPGZConfig.despawn_immediately_when_empty.get()).booleanValue() || this.field_70725_aQ == (Integer)RPGZConfig.despawn_corps_after_ticks.get()) {
            if (!this.field_70170_p.field_72995_K) {
                this.despawnParticlesServer();
            }
            this.remove(this instanceof ServerPlayerEntity);
        }
    }

    private void despawnParticlesServer() {
        for (int i = 0; i < 20; ++i) {
            double d = this.field_70146_Z.nextGaussian() * 0.025;
            double e = this.field_70146_Z.nextGaussian() * 0.025;
            double f = this.field_70146_Z.nextGaussian() * 0.025;
            double x = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.func_174813_aQ().field_72340_a - 0.5), (double)this.func_174813_aQ().field_72336_d) + 0.5;
            double y = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)this.func_174813_aQ().field_72338_b, (double)this.func_174813_aQ().field_72337_e) + 0.5;
            double z = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.func_174813_aQ().field_72339_c - 0.5), (double)this.func_174813_aQ().field_72334_f) + 0.5;
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197598_I, x, y, z, 0, d, e, f, 0.01);
        }
    }

    @Inject(method={"dropLoot"}, at={@At(value="HEAD")}, cancellable=true)
    private void dropLootMixin(DamageSource source, boolean causedByPlayer, CallbackInfo info) {
        LivingEntityMixin entity = this;
        if (entity instanceof MobEntity) {
            LootTable lootTable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(this.func_200600_R().func_220348_g());
            LootContext.Builder builder = this.func_213363_a(causedByPlayer, source);
            lootTable.func_216120_b(builder.func_216022_a(LootParameterSets.field_216263_d), this::addingInventoryItems);
            info.cancel();
        }
    }

    @Override
    public void addingInventoryItems(ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.dropInventory.func_174894_a(stack);
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d hitPos, Hand hand) {
        if (this.field_70170_p.field_72995_K && this.field_70725_aQ > 20) {
            return ActionResultType.SUCCESS;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70725_aQ > 20 && !this.dropInventory.func_191420_l()) {
            player.func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((syncId, inv, p) -> new LivingEntityScreenHandler(syncId, p.field_71071_by, this.dropInventory), (ITextComponent)new StringTextComponent("")));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Shadow
    protected LootContext.Builder func_213363_a(boolean causedByPlayer, DamageSource source) {
        return new LootContext.Builder((ServerWorld)this.field_70170_p);
    }

    @Shadow
    public boolean func_230285_a_(Fluid fluid) {
        return false;
    }

    @Shadow
    public boolean func_70631_g_() {
        return false;
    }

    @Override
    public Inventory getDropsInventory() {
        return this.dropInventory;
    }

    @Override
    public void setDropsInventory(Inventory inventory) {
        this.dropInventory = inventory;
    }
}

