/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.math.MathUtil;
import xyz.przemyk.simpleplanes.math.Quaternion;
import xyz.przemyk.simpleplanes.render.BackSeatBlockModel;
import xyz.przemyk.simpleplanes.render.PropellerModel;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;

public abstract class AbstractPlaneRenderer<T extends PlaneEntity>
extends Render<T> {
    protected PropellerModel propellerModel = new PropellerModel();

    protected AbstractPlaneRenderer(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(T planeEntity, double x, double y, double z, float entityYaw, float partialTicks) {
        boolean isPlayerRidingInFirstPersonView;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 0.375f), (float)((float)z));
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)0.0, (double)-0.5, (double)0.0);
        GlStateManager.func_187444_a((org.lwjgl.util.vector.Quaternion)MathUtil.rotationDegreesY(180.0f).convert());
        this.func_180548_c((Entity)planeEntity);
        double firstPersonYOffset = -0.7;
        boolean bl = isPlayerRidingInFirstPersonView = Minecraft.func_71410_x().field_71439_g != null && planeEntity.func_184196_w((Entity)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0;
        if (isPlayerRidingInFirstPersonView) {
            GlStateManager.func_179137_b((double)0.0, (double)firstPersonYOffset, (double)0.0);
        }
        Quaternion q = MathUtil.lerpQ(partialTicks, ((PlaneEntity)((Object)planeEntity)).getQ_Prev(), ((PlaneEntity)((Object)planeEntity)).getQ_Client());
        GlStateManager.func_187444_a((org.lwjgl.util.vector.Quaternion)q.convert());
        float rockingAngle = ((PlaneEntity)((Object)planeEntity)).getRockingAngle(partialTicks);
        float f = (float)((PlaneEntity)((Object)planeEntity)).getTimeSinceHit() - partialTicks;
        float f1 = ((PlaneEntity)((Object)planeEntity)).getDamageTaken() - partialTicks;
        if (f1 < 0.1f) {
            f1 = 0.1f;
        }
        if (f > 0.0f) {
            float angle = MathUtil.func_76131_a((float)(f * f1 / 200.0f), (float)-30.0f, (float)30.0f);
            f = (float)((PlaneEntity)((Object)planeEntity)).field_70173_aa + partialTicks;
            GlStateManager.func_187444_a((org.lwjgl.util.vector.Quaternion)MathUtil.rotationDegreesZ(MathHelper.func_76126_a((float)f) * angle).convert());
        }
        GlStateManager.func_179137_b((double)0.0, (double)-0.6, (double)0.0);
        if (isPlayerRidingInFirstPersonView) {
            GlStateManager.func_179137_b((double)0.0, (double)(-firstPersonYOffset), (double)0.0);
        }
        ModelBase planeModel = this.getModel();
        boolean enchanted_plane = ((PlaneEntity)((Object)planeEntity)).getHealth() > ((PlaneEntity)((Object)planeEntity)).getMaxHealth();
        planeModel.func_78087_a(partialTicks, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, planeEntity);
        planeModel.func_78088_a(planeEntity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        int seat = 0;
        for (Upgrade upgrade : ((PlaneEntity)((Object)planeEntity)).upgrades.values()) {
            GlStateManager.func_179094_E();
            ResourceLocation texture = upgrade.getTexture();
            if (texture != null) {
                this.func_110776_a(texture);
            }
            if (upgrade.getType().occupyBackSeat) {
                for (int i = 0; i < upgrade.getSeats(); ++i) {
                    GlStateManager.func_179094_E();
                    BackSeatBlockModel.moveMatrix(planeEntity, seat);
                    upgrade.render(partialTicks, 0.0625f);
                    ++seat;
                    GlStateManager.func_179121_F();
                }
            } else {
                upgrade.render(partialTicks, 0.0625f);
            }
            GlStateManager.func_179121_F();
        }
        String resourceName = ((PlaneEntity)((Object)planeEntity)).getMaterial().fireResistant ? "textures/block/netherite_block.png" : "textures/blocks/iron_block.png";
        this.propellerModel.func_78087_a(partialTicks, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, (Entity)planeEntity);
        this.func_110776_a(new ResourceLocation(resourceName));
        this.propellerModel.func_78088_a((Entity)planeEntity, partialTicks, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.func_179094_E();
        this.renderAdditional(planeEntity, partialTicks);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        super.func_76986_a(planeEntity, x, y, z, entityYaw, partialTicks);
    }

    protected void renderAdditional(T planeEntity, float partialTicks) {
    }

    protected abstract ModelBase getModel();
}

