/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.setup;

import java.util.ArrayList;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xyz.przemyk.simpleplanes.entities.HelicopterEntity;
import xyz.przemyk.simpleplanes.entities.LargePlaneEntity;
import xyz.przemyk.simpleplanes.entities.MegaPlaneEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.items.InformationItem;
import xyz.przemyk.simpleplanes.items.PlaneItem;
import xyz.przemyk.simpleplanes.setup.SimplePlanesMaterials;

@Mod.EventBusSubscriber(modid="simpleplanes")
public class SimplePlanesItems {
    public static final ArrayList<Item> ITEMS = new ArrayList();
    public static CreativeTabs tab = new CreativeTabs("simple planes"){

        public ItemStack func_78016_d() {
            return new ItemStack(PROPELLER);
        }
    };
    public static final Item PROPELLER = SimplePlanesItems.register("propeller", new Item());
    public static final Item FURNACE_ENGINE = SimplePlanesItems.register("furnace_engine", new Item());
    public static final Item JUNK_ENGINE = SimplePlanesItems.register("junk_engine", new Item());
    public static final Item SPRAYER = SimplePlanesItems.register("sprayer", new InformationItem((ITextComponent)new TextComponentTranslation("description.simpleplanes.sprayer", new Object[0])));
    public static final Item BOOSTER = SimplePlanesItems.register("booster", new InformationItem((ITextComponent)new TextComponentTranslation("description.simpleplanes.booster", new Object[0])));
    public static final Item FLOATY_BEDDING = SimplePlanesItems.register("floaty_bedding", new InformationItem((ITextComponent)new TextComponentTranslation("description.simpleplanes.floaty_bedding", new Object[0])));
    public static final Item SHOOTER = SimplePlanesItems.register("shooter", new InformationItem((ITextComponent)new TextComponentTranslation("description.simpleplanes.shooter", new Object[0])));
    public static final Item FOLDING = SimplePlanesItems.register("folding", new InformationItem((ITextComponent)new TextComponentTranslation("description.simpleplanes.folding", new Object[0])));
    public static final Item HEALING = SimplePlanesItems.register("healing", new InformationItem((ITextComponent)new TextComponentTranslation("description.simpleplanes.healing", new Object[0])));

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : ITEMS) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    public static void init() {
        for (String name : SimplePlanesMaterials.MATERIALS) {
            SimplePlanesItems.register(name + "_plane", new PlaneItem(world -> new PlaneEntity((World)world, SimplePlanesMaterials.getMaterial(name))));
            SimplePlanesItems.register(name + "_large_plane", new PlaneItem(world -> new LargePlaneEntity((World)world, SimplePlanesMaterials.getMaterial(name))));
            SimplePlanesItems.register(name + "_helicopter", new PlaneItem(world -> new HelicopterEntity((World)world, SimplePlanesMaterials.getMaterial(name))));
            SimplePlanesItems.register(name + "_mega_plane", new PlaneItem(world -> new MegaPlaneEntity((World)world, SimplePlanesMaterials.getMaterial(name))));
        }
    }

    private static Item register(String id, Item item) {
        ITEMS.add(item);
        item.setRegistryName("simpleplanes", id);
        item.func_77637_a(tab);
        item.func_77655_b(id);
        return item;
    }
}

