/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.shooter;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.math.Vector3f;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.shooter.ShooterModel;

public class ShooterUpgrade
extends Upgrade {
    public static final ResourceLocation TEXTURE = new ResourceLocation("simpleplanes", "textures/plane_upgrades/shooter.png");
    private boolean shootSide = false;

    public ShooterUpgrade(PlaneEntity planeEntity) {
        super(SimplePlanesUpgrades.SHOOTER, planeEntity);
    }

    @Override
    public boolean onItemRightClick(EntityPlayer player, World world, EnumHand hand, ItemStack itemStack) {
        Vector3f motion1 = this.planeEntity.transformPos(new Vector3f(0.0f, 0.0f, (float)(1.0 + this.planeEntity.getMotion().func_72433_c())));
        Vec3d motion = new Vec3d((double)motion1.x, (double)motion1.y, (double)motion1.z);
        Random random = world.field_73012_v;
        Vector3f pos = this.planeEntity.transformPos(new Vector3f(this.shootSide ? 0.8f : -0.8f, 0.8f, 0.8f));
        this.shootSide = !this.shootSide;
        double x = (double)pos.getX() + this.planeEntity.getPosX();
        double y = (double)pos.getY() + this.planeEntity.getPosY();
        double z = (double)pos.getZ() + this.planeEntity.getPosZ();
        Item item = itemStack.func_77973_b();
        if (item == Items.field_151152_bP) {
            EntityFireworkRocket fireworkrocketentity = new EntityFireworkRocket(world, x, y, z, itemStack);
            fireworkrocketentity.func_70016_h(-motion.field_72450_a, -motion.field_72448_b, -motion.field_72449_c);
            world.func_72838_d((Entity)fireworkrocketentity);
            if (!player.func_184812_l_()) {
                itemStack.func_190918_g(1);
            }
        } else if (item == Items.field_151059_bz) {
            double d3 = random.nextGaussian() * 0.05 + 2.0 * motion.field_72450_a;
            double d4 = random.nextGaussian() * 0.05;
            double d5 = random.nextGaussian() * 0.05 + 2.0 * motion.field_72449_c;
            world.func_72838_d((Entity)new EntitySmallFireball(world, x, y, z, d3, d4, d5));
            if (!player.func_184812_l_()) {
                itemStack.func_190918_g(1);
            }
        } else if (item == Items.field_151032_g) {
            EntityTippedArrow arrowEntity = new EntityTippedArrow(world, x, y, z);
            Vec3d m = motion.func_186678_a(Math.max(motion.func_72433_c() * 1.5, 3.0) / motion.func_72433_c());
            arrowEntity.field_70250_c = this.planeEntity;
            arrowEntity.func_70016_h(m.field_72450_a, m.field_72448_b, m.field_72449_c);
            if (!player.func_184812_l_()) {
                itemStack.func_190918_g(1);
                arrowEntity.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
            }
            world.func_72838_d((Entity)arrowEntity);
        } else if (item == Items.field_185167_i) {
            EntityTippedArrow arrowEntity = new EntityTippedArrow(world, x, y, z);
            Vec3d m = motion.func_186678_a(Math.max(motion.func_72433_c() * 1.5, 3.0) / motion.func_72433_c());
            arrowEntity.field_70250_c = this.planeEntity;
            arrowEntity.func_184555_a(itemStack);
            arrowEntity.func_70016_h(m.field_72450_a, m.field_72448_b, m.field_72449_c);
            if (!player.func_184812_l_()) {
                itemStack.func_190918_g(1);
                arrowEntity.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
            }
            world.func_72838_d((Entity)arrowEntity);
        } else if (item == Items.field_185166_h) {
            EntitySpectralArrow arrowEntity = new EntitySpectralArrow(world, x, y, z);
            Vec3d m = motion.func_186678_a(Math.max(motion.func_72433_c() * 1.5, 3.0) / motion.func_72433_c());
            arrowEntity.field_70250_c = this.planeEntity;
            arrowEntity.func_70016_h(m.field_72450_a, m.field_72448_b, m.field_72449_c);
            if (!player.func_184812_l_()) {
                itemStack.func_190918_g(1);
                arrowEntity.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
            }
            world.func_72838_d((Entity)arrowEntity);
        }
        return false;
    }

    @Override
    public void render(float partialticks, float scale) {
        ShooterModel.INSTANCE.func_78088_a(this.planeEntity, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, scale);
    }

    @Override
    public ResourceLocation getTexture() {
        return TEXTURE;
    }
}

