/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.handler;

import java.util.function.Supplier;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import xyz.przemyk.simpleplanes.MathUtil;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesDataSerializers;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.storage.ChestUpgrade;

public class PlaneNetworking {
    public static final int MSG_PLANE_QUAT = 0;
    public static final int MSG_PLANE_BOOST = 1;
    public static final int MSG_PLANE_INVENTORY = 2;
    private static final String PROTOCOL_VERSION = "3";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("simpleplanes", "plane_rotation"), () -> "3", "3"::equals, "3"::equals);
    public static final SimpleChannel OPEN_INVENTORY = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("simpleplanes", "plane_inventory"), () -> "3", "3"::equals, "3"::equals);

    public static void init() {
        INSTANCE.registerMessage(0, Quaternion.class, (msg, buff) -> SimplePlanesDataSerializers.QUATERNION_SERIALIZER.func_187160_a(buff, msg), arg_0 -> SimplePlanesDataSerializers.QUATERNION_SERIALIZER.func_187159_a(arg_0), PlaneNetworking::handle_q);
        INSTANCE.registerMessage(1, Boolean.class, (msg, buff) -> DataSerializers.field_187198_h.func_187160_a(buff, msg), arg_0 -> ((IDataSerializer)DataSerializers.field_187198_h).func_187159_a(arg_0), PlaneNetworking::handle_boost);
        OPEN_INVENTORY.registerMessage(2, Boolean.class, (msg, buff) -> DataSerializers.field_187198_h.func_187160_a(buff, msg), arg_0 -> ((IDataSerializer)DataSerializers.field_187198_h).func_187159_a(arg_0), PlaneNetworking::handle_inventory);
    }

    private static void handle_inventory(Boolean msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            switch (((NetworkEvent.Context)ctx.get()).getDirection()) {
                case PLAY_TO_SERVER: {
                    if (player == null || !(player.func_184187_bx() instanceof PlaneEntity)) break;
                    PlaneEntity plane = (PlaneEntity)player.func_184187_bx();
                    Upgrade chest = plane.upgrades.getOrDefault(SimplePlanesUpgrades.CHEST.getId(), null);
                    if (!(chest instanceof ChestUpgrade)) break;
                    ChestUpgrade chest1 = (ChestUpgrade)chest;
                    if (chest1.inventory == null) break;
                    player.func_213829_a((INamedContainerProvider)chest1);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void handle_q(Quaternion msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity ServerPlayerEntity2 = ((NetworkEvent.Context)ctx.get()).getSender();
            if (ServerPlayerEntity2 != null && ServerPlayerEntity2.func_184187_bx() instanceof PlaneEntity) {
                PlaneEntity planeEntity = (PlaneEntity)ServerPlayerEntity2.func_184187_bx();
                planeEntity.setQ(msg);
                MathUtil.EulerAngles eulerAngles = MathUtil.toEulerAngles(msg);
                planeEntity.field_70177_z = (float)eulerAngles.yaw;
                planeEntity.field_70125_A = (float)eulerAngles.pitch;
                planeEntity.rotationRoll = (float)eulerAngles.roll;
                planeEntity.setQ_Client(msg);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void handle_boost(Boolean msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity ServerPlayerEntity2 = ((NetworkEvent.Context)ctx.get()).getSender();
            if (ServerPlayerEntity2 != null && ServerPlayerEntity2.func_184187_bx() instanceof PlaneEntity) {
                PlaneEntity planeEntity = (PlaneEntity)ServerPlayerEntity2.func_184187_bx();
                planeEntity.func_70031_b(msg);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

