/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.integration.liquid;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import xyz.przemyk.simpleplanes.Config;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.integration.liquid.PlaneFluidHandler;
import xyz.przemyk.simpleplanes.setup.SimplePlanesBlocks;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;

public class LiquidFuelingTileEntity
extends TileEntity
implements ITickableTileEntity {
    protected PlaneFluidHandler tank = new PlaneFluidHandler(this);
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(cap, side);
    }

    public LiquidFuelingTileEntity() {
        super((TileEntityType)SimplePlanesBlocks.FUELING_TILE.get());
    }

    public void func_73660_a() {
    }

    public boolean onActivated(PlayerEntity player) {
        ItemStack heldItem = player.func_184586_b(player.func_184600_cs());
        LazyOptional capability = heldItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (capability.isPresent()) {
            IFluidHandlerItem iFluidHandler = (IFluidHandlerItem)capability.orElse(null);
            FluidStack fluidInTank = iFluidHandler.getFluidInTank(0);
            int fill = this.fill(fluidInTank, IFluidHandler.FluidAction.SIMULATE);
            FluidStack drain = iFluidHandler.drain(fill, IFluidHandler.FluidAction.SIMULATE);
            int fill_real = this.fill(drain, IFluidHandler.FluidAction.EXECUTE);
            iFluidHandler.drain(fill_real, IFluidHandler.FluidAction.EXECUTE);
            player.func_184611_a(player.func_184600_cs(), iFluidHandler.getContainer());
            return true;
        }
        return false;
    }

    int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int i = 0;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && !resource.isEmpty()) {
            Integer cost = (Integer)Config.LAVA_COST.get();
            List planes = this.field_145850_b.func_175647_a(PlaneEntity.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c).func_186662_g(5.0), playerEntity -> true);
            for (PlaneEntity planeEntity : planes) {
                if (!planeEntity.upgrades.containsKey(SimplePlanesUpgrades.LAVA_ENGINE.getId())) continue;
                if (planeEntity.getFuel() <= (Integer)Config.LAVA_MAX_FUEL.get() - (Integer)Config.LAVA_FLY_TICKS.get()) {
                    if (action.simulate()) {
                        i += cost.intValue();
                        continue;
                    }
                    int amount = resource.getAmount();
                    if (cost <= amount) {
                        planeEntity.addFuel((Integer)Config.LAVA_FLY_TICKS.get());
                        resource.shrink(cost.intValue());
                        i += cost.intValue();
                        continue;
                    }
                    if (amount <= 0) continue;
                    resource.shrink(amount);
                    i += amount;
                    planeEntity.addFuel((Integer)Config.LAVA_FLY_TICKS.get() / cost * amount);
                    continue;
                }
                System.out.println("full");
            }
        }
        return i;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        return super.func_189515_b(compound);
    }
}

