/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.setup;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;
import xyz.przemyk.simpleplanes.entities.HelicopterEntity;
import xyz.przemyk.simpleplanes.entities.LargePlaneEntity;
import xyz.przemyk.simpleplanes.entities.MegaPlaneEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.items.InformationItem;
import xyz.przemyk.simpleplanes.items.PlaneItem;
import xyz.przemyk.simpleplanes.setup.SimplePlanesBlocks;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesMaterials;
import xyz.przemyk.simpleplanes.upgrades.cloud.CloudBlock;

@Mod.EventBusSubscriber(modid="simpleplanes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SimplePlanesItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"simpleplanes");
    public static final ItemGroup SIMPLE_PLANES_ITEM_GROUP = new ItemGroup("simpleplanes"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)((RegistryObject)ITEMS.getEntries().iterator().next()).get());
        }
    };
    @ObjectHolder(value="simpleplanes:oak_plane")
    public static final Item OAK_PLANE = null;
    public static final RegistryObject<Item> PROPELLER = ITEMS.register("propeller", () -> new Item(new Item.Properties().func_200916_a(SIMPLE_PLANES_ITEM_GROUP)));
    public static final RegistryObject<Item> FURNACE_ENGINE = ITEMS.register("furnace_engine", () -> new Item(new Item.Properties().func_200916_a(SIMPLE_PLANES_ITEM_GROUP)));
    public static final RegistryObject<Item> SPRAYER = ITEMS.register("sprayer", () -> new InformationItem((ITextComponent)new TranslationTextComponent("description.simpleplanes.sprayer", new Object[0])));
    public static final RegistryObject<Item> BOOSTER = ITEMS.register("booster", () -> new InformationItem((ITextComponent)new TranslationTextComponent("description.simpleplanes.booster", new Object[0])));
    public static final RegistryObject<Item> FLOATY_BEDDING = ITEMS.register("floaty_bedding", () -> new InformationItem((ITextComponent)new TranslationTextComponent("description.simpleplanes.floaty_bedding", new Object[0])));
    public static final RegistryObject<Item> SHOOTER = ITEMS.register("shooter", () -> new InformationItem((ITextComponent)new TranslationTextComponent("description.simpleplanes.shooter", new Object[0])));
    public static final RegistryObject<Item> FOLDING = ITEMS.register("folding", () -> new InformationItem((ITextComponent)new TranslationTextComponent("description.simpleplanes.folding", new Object[0])));
    public static final RegistryObject<Item> HEALING = ITEMS.register("healing", () -> new InformationItem((ITextComponent)new TranslationTextComponent("description.simpleplanes.healing", new Object[0])));
    public static final RegistryObject<Item> CLOUD = ITEMS.register("cloud", () -> new InformationItem((ITextComponent)new TranslationTextComponent("description.simpleplanes.cloud", new Object[0])){

        public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
            ItemStack itemstack = playerIn.func_184586_b(handIn);
            playerIn.func_184598_c(handIn);
            CloudBlock.placeCloud(playerIn.func_180425_c(), worldIn);
            return ActionResult.func_226249_b_((Object)itemstack);
        }

        public ActionResultType func_195939_a(ItemUseContext context) {
            CloudBlock.placeCloud(context.func_195995_a(), context.func_195991_k());
            return ActionResultType.CONSUME;
        }
    });
    public static final RegistryObject<Item> CHARGER_BLOCK = ITEMS.register("charger_block", () -> new BlockItem((Block)SimplePlanesBlocks.CHARGER_BLOCK.get(), new Item.Properties().func_200916_a(SIMPLE_PLANES_ITEM_GROUP)));
    public static final RegistryObject<Item> FUELING_BLOCK = ITEMS.register("fueling_block", () -> new BlockItem((Block)SimplePlanesBlocks.FUELING_BLOCK.get(), new Item.Properties().func_200916_a(SIMPLE_PLANES_ITEM_GROUP)));

    public static void init() {
        for (String name : SimplePlanesMaterials.MATERIALS) {
            ITEMS.register(name + "_plane", () -> new PlaneItem(new Item.Properties().func_200916_a(SIMPLE_PLANES_ITEM_GROUP), world -> new PlaneEntity((EntityType<? extends PlaneEntity>)((EntityType)SimplePlanesEntities.PLANE.get()), (World)world, SimplePlanesMaterials.getMaterial(name))));
            ITEMS.register(name + "_large_plane", () -> new PlaneItem(new Item.Properties().func_200916_a(SIMPLE_PLANES_ITEM_GROUP), world -> new LargePlaneEntity((EntityType<? extends LargePlaneEntity>)((EntityType)SimplePlanesEntities.LARGE_PLANE.get()), (World)world, SimplePlanesMaterials.getMaterial(name))));
            ITEMS.register(name + "_helicopter", () -> new PlaneItem(new Item.Properties().func_200916_a(SIMPLE_PLANES_ITEM_GROUP), world -> new HelicopterEntity((EntityType<? extends HelicopterEntity>)((EntityType)SimplePlanesEntities.HELICOPTER.get()), (World)world, SimplePlanesMaterials.getMaterial(name))));
            ITEMS.register(name + "_mega_plane", () -> new PlaneItem(new Item.Properties().func_200916_a(SIMPLE_PLANES_ITEM_GROUP), world -> new MegaPlaneEntity((EntityType<? extends LargePlaneEntity>)((EntityType)SimplePlanesEntities.MEGA_PLANE.get()), (World)world, SimplePlanesMaterials.getMaterial(name))));
        }
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }
}

