/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.setup;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ObjectHolder;
import xyz.przemyk.simpleplanes.PlaneMaterial;
import xyz.przemyk.simpleplanes.setup.SimplePlanesRegistries;
import xyz.przemyk.simpleplanes.upgrades.paint.PaintUpgrade;

@Mod.EventBusSubscriber(modid="simpleplanes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SimplePlanesMaterials {
    public static final String[] MATERIALS = new String[]{"oak", "acacia", "birch", "crimson", "dark_oak", "jungle", "spruce", "warped", "bop_cherry", "bop_dead", "bop_fir", "bop_hellbark", "bop_jacaranda", "bop_mahogany", "bop_magic", "bop_palm", "bop_redwood", "bop_umbran", "bop_willow", "byg_aspen", "byg_baobab", "byg_blue_enchanted", "byg_cherry", "byg_cika", "byg_cypress", "byg_ebony", "byg_fir", "byg_green_enchanted", "byg_holly", "byg_jacaranda", "byg_mahogany", "byg_mangrove", "byg_maple", "byg_pine", "byg_rainbow_eucalyptus", "byg_redwood", "byg_skyris", "byg_willow", "byg_witch_hazel", "byg_zelkova", "ft_cherry", "ft_citrus"};
    public static final String[] FIRE_RESISTANT = new String[]{"crimson", "warped", "bop_hellbark"};
    @ObjectHolder(value="simpleplanes:oak")
    public static final PlaneMaterial OAK = null;

    public static Set<Map.Entry<ResourceLocation, PlaneMaterial>> getMaterials() {
        return SimplePlanesRegistries.PLANE_MATERIALS.getEntries();
    }

    public static PlaneMaterial getMaterial(ResourceLocation name) {
        return (PlaneMaterial)SimplePlanesRegistries.PLANE_MATERIALS.getValue(name);
    }

    @SubscribeEvent
    public static void registerMaterials(RegistryEvent.Register<PlaneMaterial> event) {
        List<String> fire = Arrays.asList(FIRE_RESISTANT);
        for (String name : MATERIALS) {
            SimplePlanesMaterials.register(event, fire, name);
        }
        PaintUpgrade.init();
        for (String name : PaintUpgrade.PAINTS.values()) {
            SimplePlanesMaterials.register(event, fire, name);
        }
    }

    public static void register(RegistryEvent.Register<PlaneMaterial> event, List<String> fire, String name) {
        event.getRegistry().register(new PlaneMaterial(name, fire.contains(name)).setRegistryName("simpleplanes", name));
    }

    public static PlaneMaterial getMaterial(String name) {
        return SimplePlanesMaterials.getMaterial(new ResourceLocation("simpleplanes", name));
    }
}

